/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public class Timer
implements Serializable,
StringBuilderFormattable {
    private static final long serialVersionUID = 9175191792439630013L;
    private final String name;
    private Status status;
    private long elapsedTime;
    private final int iterations;
    private static long NANO_PER_SECOND = 1000000000L;
    private static long NANO_PER_MINUTE = 1000000000L * 60L;
    private static long NANO_PER_HOUR = NANO_PER_MINUTE * 60L;
    private ThreadLocal<Long> startTime = new ThreadLocal<Long>(this){
        final /* synthetic */ Timer this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        protected Long initialValue() {
            return 0L;
        }
    };

    /*
     * WARNING - void declaration
     */
    public Timer(String name) {
        this((String)var1_1, 0);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Timer(String name, int iterations) {
        int n;
        void var1_1;
        this.name = var1_1;
        this.status = Status.Stopped;
        this.iterations = iterations > 0 ? n : 0;
    }

    public synchronized void start() {
        this.startTime.set(System.nanoTime());
        this.elapsedTime = 0L;
        this.status = Status.Started;
    }

    public synchronized void startOrResume() {
        if (this.status == Status.Stopped) {
            this.start();
            return;
        }
        this.resume();
    }

    public synchronized String stop() {
        this.elapsedTime += System.nanoTime() - this.startTime.get();
        this.startTime.set(0L);
        this.status = Status.Stopped;
        return this.toString();
    }

    public synchronized void pause() {
        this.elapsedTime += System.nanoTime() - this.startTime.get();
        this.startTime.set(0L);
        this.status = Status.Paused;
    }

    public synchronized void resume() {
        this.startTime.set(System.nanoTime());
        this.status = Status.Started;
    }

    public String getName() {
        return this.name;
    }

    public long getElapsedTime() {
        return this.elapsedTime / 1000000L;
    }

    public long getElapsedNanoTime() {
        return this.elapsedTime;
    }

    public Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder result = new StringBuilder();
        this.formatTo(result);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void formatTo(StringBuilder buffer) {
        buffer.append("Timer ").append(this.name);
        switch (this.status) {
            case Started: {
                buffer.append(" started");
                return;
            }
            case Paused: {
                buffer.append(" paused");
                return;
            }
            case Stopped: {
                void var2_2;
                long nanoseconds = this.elapsedTime;
                long hours = nanoseconds / NANO_PER_HOUR;
                long minutes = (nanoseconds %= NANO_PER_HOUR) / NANO_PER_MINUTE;
                long seconds = (nanoseconds %= NANO_PER_MINUTE) / NANO_PER_SECOND;
                nanoseconds %= NANO_PER_SECOND;
                String elapsed = "";
                if (hours > 0L) {
                    elapsed = elapsed + hours + " hours ";
                }
                if (minutes > 0L || hours > 0L) {
                    elapsed = elapsed + minutes + " minutes ";
                }
                DecimalFormat numFormat322 = new DecimalFormat("#0");
                elapsed = elapsed + numFormat322.format(seconds) + '.';
                numFormat322 = new DecimalFormat("000000000");
                elapsed = elapsed + numFormat322.format(nanoseconds) + " seconds";
                buffer.append(" stopped. Elapsed time: ").append(elapsed);
                if (this.iterations <= 0) break;
                nanoseconds = this.elapsedTime / (long)this.iterations;
                long numFormat322 = nanoseconds / NANO_PER_HOUR;
                minutes = (nanoseconds %= NANO_PER_HOUR) / NANO_PER_MINUTE;
                seconds = (nanoseconds %= NANO_PER_MINUTE) / NANO_PER_SECOND;
                nanoseconds %= NANO_PER_SECOND;
                elapsed = "";
                if (numFormat322 > 0L) {
                    elapsed = elapsed + numFormat322 + " hours ";
                }
                if (minutes > 0L || numFormat322 > 0L) {
                    elapsed = elapsed + minutes + " minutes ";
                }
                DecimalFormat numFormat322 = new DecimalFormat("#0");
                elapsed = elapsed + numFormat322.format(seconds) + '.';
                numFormat322 = new DecimalFormat("000000000");
                elapsed = elapsed + numFormat322.format((long)var2_2) + " seconds";
                buffer.append(" Average per iteration: ").append(elapsed);
                return;
            }
            default: {
                void var1_1;
                var1_1.append(' ').append((Object)this.status);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Timer)) {
            return false;
        }
        Timer timer = (Timer)o;
        if (this.elapsedTime != timer.elapsedTime) {
            return false;
        }
        if (this.startTime != timer.startTime) {
            return false;
        }
        if (this.name != null ? !this.name.equals(timer.name) : timer.name != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals((Object)timer.status) : var1_1.status != null);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        void var2_2;
        int result = this.name != null ? this.name.hashCode() : 0;
        result = result * 29 + (this.status != null ? this.status.hashCode() : 0);
        long time = this.startTime.get();
        void v0 = var2_2;
        result = result * 29 + (int)(v0 ^ v0 >>> 32);
        var1_1 = var1_1 * 29 + (int)(this.elapsedTime ^ this.elapsedTime >>> 32);
        return (int)var1_1;
    }

    public static enum Status {
        Started,
        Stopped,
        Paused;

    }
}

