/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.util.SystemPropertiesPropertySource;

public final class Strings {
    private static final ThreadLocal<StringBuilder> tempStr = ThreadLocal.withInitial(StringBuilder::new);
    public static final String EMPTY = "";
    private static final String COMMA_DELIMITED_RE = "\\s*,\\s*";
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String LINE_SEPARATOR = SystemPropertiesPropertySource.getSystemProperty("line.separator", "\n");

    public static String dquote(String str) {
        String string;
        return "\"" + string + '\"';
    }

    public static boolean isBlank(String s) {
        if (s == null || s.isEmpty()) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs) {
        CharSequence charSequence;
        return cs == null || charSequence.length() == 0;
    }

    public static boolean isNotBlank(String s) {
        return !Strings.isBlank(s);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !Strings.isEmpty(cs);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterable<?> iterable, char separator) {
        void var1_1;
        Iterable<?> iterable2;
        if (iterable == null) {
            return null;
        }
        return Strings.join(iterable2.iterator(), (char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterator<?> iterator, char separator) {
        void var3_3;
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first, EMPTY);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            void var2_2;
            buf.append(separator);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(var2_2);
        }
        return var3_3.toString();
    }

    public static String[] splitList(String string) {
        if (string != null) {
            String string2;
            return string2.split(COMMA_DELIMITED_RE);
        }
        return new String[0];
    }

    /*
     * WARNING - void declaration
     */
    public static String left(String str, int len) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return string.substring(0, (int)var1_1);
    }

    public static String quote(String str) {
        String string;
        return "'" + string + '\'';
    }

    public static String trimToNull(String str) {
        String string;
        String ts = str == null ? null : str.trim();
        if (Strings.isEmpty(ts)) {
            return null;
        }
        return string;
    }

    private Strings() {
    }

    public static String toRootLowerCase(String str) {
        return str.toLowerCase(Locale.ROOT);
    }

    public static String toRootUpperCase(String str) {
        return str.toUpperCase(Locale.ROOT);
    }

    /*
     * WARNING - void declaration
     */
    public static String concat(String str1, String str2) {
        if (Strings.isEmpty(str1)) {
            return str2;
        }
        if (Strings.isEmpty(str2)) {
            return str1;
        }
        StringBuilder sb = tempStr.get();
        try {
            void var1_2;
            String string;
            string = sb.append(string).append((String)var1_2).toString();
            sb.setLength(0);
            return string;
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.setLength(0);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String repeat(String str, int count) {
        Objects.requireNonNull(str, "str");
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        StringBuilder sb = tempStr.get();
        try {
            for (int index = 0; index < count; ++index) {
                sb.append(str);
            }
            String string = sb.toString();
            sb.setLength(0);
            return string;
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.setLength(0);
            throw throwable;
        }
    }
}

