/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.time.temporal.Temporal;
import java.util.Map;
import org.apache.logging.log4j.util.Chars;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public final class StringBuilders {
    private static final Class<?> timeClass;

    private StringBuilders() {
    }

    /*
     * WARNING - void declaration
     */
    public static StringBuilder appendDqValue(StringBuilder sb, Object value) {
        void var1_1;
        return sb.append('\"').append(var1_1).append('\"');
    }

    /*
     * WARNING - void declaration
     */
    public static StringBuilder appendKeyDqValue(StringBuilder sb, Map.Entry<String, String> entry) {
        void var1_1;
        return StringBuilders.appendKeyDqValue(sb, entry.getKey(), var1_1.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public static StringBuilder appendKeyDqValue(StringBuilder sb, String key, Object value) {
        void var2_2;
        void var1_1;
        return sb.append((String)var1_1).append('=').append('\"').append(var2_2).append('\"');
    }

    /*
     * WARNING - void declaration
     */
    public static void appendValue(StringBuilder stringBuilder, Object obj) {
        if (!StringBuilders.appendSpecificTypes(stringBuilder, obj)) {
            void var1_1;
            StringBuilder stringBuilder2;
            stringBuilder2.append(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean appendSpecificTypes(StringBuilder stringBuilder, Object obj) {
        if (obj == null || obj instanceof String) {
            stringBuilder.append((String)obj);
        } else if (obj instanceof StringBuilderFormattable) {
            ((StringBuilderFormattable)obj).formatTo(stringBuilder);
        } else if (obj instanceof CharSequence) {
            stringBuilder.append((CharSequence)obj);
        } else if (obj instanceof Integer) {
            stringBuilder.append((Integer)obj);
        } else if (obj instanceof Long) {
            stringBuilder.append((Long)obj);
        } else if (obj instanceof Double) {
            stringBuilder.append((Double)obj);
        } else if (obj instanceof Boolean) {
            stringBuilder.append((Boolean)obj);
        } else if (obj instanceof Character) {
            stringBuilder.append(((Character)obj).charValue());
        } else if (obj instanceof Short) {
            stringBuilder.append(((Short)obj).shortValue());
        } else if (obj instanceof Float) {
            stringBuilder.append(((Float)obj).floatValue());
        } else if (obj instanceof Byte) {
            stringBuilder.append(((Byte)obj).byteValue());
        } else if (StringBuilders.isTime(obj) || obj instanceof Temporal) {
            void var1_1;
            StringBuilder stringBuilder2;
            stringBuilder2.append(var1_1);
        } else {
            return false;
        }
        return true;
    }

    private static boolean isTime(Object obj) {
        Object object;
        return timeClass != null && timeClass.isAssignableFrom(object.getClass());
    }

    public static boolean equals(CharSequence left, int leftOffset, int leftLength, CharSequence right, int rightOffset, int rightLength) {
        if (leftLength == rightLength) {
            for (int i = 0; i < rightLength; ++i) {
                if (left.charAt(i + leftOffset) == right.charAt(i + rightOffset)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(CharSequence left, int leftOffset, int leftLength, CharSequence right, int rightOffset, int rightLength) {
        if (leftLength == rightLength) {
            for (int i = 0; i < rightLength; ++i) {
                if (Character.toLowerCase(left.charAt(i + leftOffset)) == Character.toLowerCase(right.charAt(i + rightOffset))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void trimToMaxSize(StringBuilder stringBuilder, int maxSize) {
        if (stringBuilder != null && stringBuilder.capacity() > maxSize) {
            StringBuilder stringBuilder2;
            void var1_1;
            stringBuilder.setLength((int)var1_1);
            stringBuilder2.trimToSize();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void escapeJson(StringBuilder toAppendTo, int start) {
        void i;
        int escapeCount = 0;
        while (i < toAppendTo.length()) {
            char c = toAppendTo.charAt((int)i);
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '\\': {
                    ++escapeCount;
                    break;
                }
                default: {
                    if (!Character.isISOControl(c)) break;
                    escapeCount += 5;
                }
            }
            ++i;
        }
        int lastChar = toAppendTo.length() - 1;
        StringBuilder stringBuilder = toAppendTo;
        stringBuilder.setLength(stringBuilder.length() + escapeCount);
        int lastPos = toAppendTo.length() - 1;
        while (lastPos > i) {
            char c = toAppendTo.charAt((int)i);
            switch (c) {
                case '\b': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, 'b');
                    break;
                }
                case '\t': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, 't');
                    break;
                }
                case '\f': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, 'f');
                    break;
                }
                case '\n': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, 'n');
                    break;
                }
                case '\r': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, 'r');
                    break;
                }
                case '\"': 
                case '\\': {
                    lastPos = StringBuilders.escapeAndDecrement(toAppendTo, lastPos, c);
                    break;
                }
                default: {
                    void var2_2;
                    if (Character.isISOControl(c)) {
                        toAppendTo.setCharAt(lastPos--, Chars.getUpperCaseHex(c & 0xF));
                        toAppendTo.setCharAt(lastPos--, Chars.getUpperCaseHex((c & 0xF0) >> 4));
                        toAppendTo.setCharAt(lastPos--, '0');
                        toAppendTo.setCharAt(lastPos--, '0');
                        toAppendTo.setCharAt(lastPos--, 'u');
                        toAppendTo.setCharAt(lastPos--, '\\');
                        break;
                    }
                    toAppendTo.setCharAt(lastPos, (char)var2_2);
                    --lastPos;
                }
            }
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int escapeAndDecrement(StringBuilder toAppendTo, int lastPos, char c) {
        void var1_1;
        StringBuilder stringBuilder;
        void var2_2;
        toAppendTo.setCharAt(lastPos--, (char)var2_2);
        stringBuilder.setCharAt(lastPos--, '\\');
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void escapeXml(StringBuilder toAppendTo, int start) {
        void i;
        int escapeCount = 0;
        while (i < toAppendTo.length()) {
            char c = toAppendTo.charAt((int)i);
            switch (c) {
                case '&': {
                    escapeCount += 4;
                    break;
                }
                case '<': 
                case '>': {
                    escapeCount += 3;
                    break;
                }
                case '\"': 
                case '\'': {
                    escapeCount += 5;
                }
            }
            ++i;
        }
        int lastChar = toAppendTo.length() - 1;
        StringBuilder stringBuilder = toAppendTo;
        stringBuilder.setLength(stringBuilder.length() + escapeCount);
        int lastPos = toAppendTo.length() - 1;
        while (lastPos > i) {
            char c = toAppendTo.charAt((int)i);
            switch (c) {
                case '&': {
                    toAppendTo.setCharAt(lastPos--, ';');
                    toAppendTo.setCharAt(lastPos--, 'p');
                    toAppendTo.setCharAt(lastPos--, 'm');
                    toAppendTo.setCharAt(lastPos--, 'a');
                    toAppendTo.setCharAt(lastPos--, '&');
                    break;
                }
                case '<': {
                    toAppendTo.setCharAt(lastPos--, ';');
                    toAppendTo.setCharAt(lastPos--, 't');
                    toAppendTo.setCharAt(lastPos--, 'l');
                    toAppendTo.setCharAt(lastPos--, '&');
                    break;
                }
                case '>': {
                    toAppendTo.setCharAt(lastPos--, ';');
                    toAppendTo.setCharAt(lastPos--, 't');
                    toAppendTo.setCharAt(lastPos--, 'g');
                    toAppendTo.setCharAt(lastPos--, '&');
                    break;
                }
                case '\"': {
                    toAppendTo.setCharAt(lastPos--, ';');
                    toAppendTo.setCharAt(lastPos--, 't');
                    toAppendTo.setCharAt(lastPos--, 'o');
                    toAppendTo.setCharAt(lastPos--, 'u');
                    toAppendTo.setCharAt(lastPos--, 'q');
                    toAppendTo.setCharAt(lastPos--, '&');
                    break;
                }
                case '\'': {
                    toAppendTo.setCharAt(lastPos--, ';');
                    toAppendTo.setCharAt(lastPos--, 's');
                    toAppendTo.setCharAt(lastPos--, 'o');
                    toAppendTo.setCharAt(lastPos--, 'p');
                    toAppendTo.setCharAt(lastPos--, 'a');
                    toAppendTo.setCharAt(lastPos--, '&');
                    break;
                }
                default: {
                    void var2_2;
                    toAppendTo.setCharAt(lastPos--, (char)var2_2);
                }
            }
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        Class<?> clazz;
        try {
            clazz = Class.forName("java.sql.Time");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        timeClass = var0;
    }
}

