/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StackLocator;

public final class StackLocatorUtil {
    private static StackLocator stackLocator = null;
    private static volatile boolean errorLogged;

    private StackLocatorUtil() {
    }

    @PerformanceSensitive
    public static Class<?> getCallerClass(int depth) {
        int n;
        return stackLocator.getCallerClass(n + 1);
    }

    public static StackTraceElement getStackTraceElement(int depth) {
        int n;
        return stackLocator.getStackTraceElement(n + 1);
    }

    @PerformanceSensitive
    public static Class<?> getCallerClass(String fqcn) {
        return StackLocatorUtil.getCallerClass(fqcn, "");
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    public static Class<?> getCallerClass(String fqcn, String pkg) {
        void var1_1;
        String string;
        return stackLocator.getCallerClass(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    public static ClassLoader getCallerClassLoader(int depth) {
        Class<?> callerClass = stackLocator.getCallerClass(depth + 1);
        if (callerClass != null) {
            void var0_1;
            return var0_1.getClassLoader();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    public static Class<?> getCallerClass(Class<?> sentinelClass, Predicate<Class<?>> callerPredicate) {
        void var1_1;
        Class<?> clazz;
        return stackLocator.getCallerClass(clazz, (Predicate<Class<?>>)var1_1);
    }

    @PerformanceSensitive
    public static Class<?> getCallerClass(Class<?> anchor) {
        Class<?> clazz;
        return stackLocator.getCallerClass(clazz);
    }

    @PerformanceSensitive
    public static Deque<Class<?>> getCurrentStackTrace() {
        return stackLocator.getCurrentStackTrace();
    }

    /*
     * WARNING - void declaration
     */
    public static StackTraceElement calcLocation(String fqcnOfLogger) {
        try {
            return stackLocator.calcLocation(fqcnOfLogger);
        }
        catch (NoSuchElementException ex) {
            if (!errorLogged) {
                void var1_1;
                String string;
                errorLogged = true;
                StatusLogger.getLogger().warn("Unable to locate stack trace element for {}", (Object)string, (Object)var1_1);
            }
            return null;
        }
    }

    static {
        stackLocator = StackLocator.getInstance();
    }
}

