/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PrivateSecurityManagerStackTraceUtil;

public final class StackLocator {
    static final int JDK_7U25_OFFSET;
    private static final Method GET_CALLER_CLASS_METHOD;
    private static final StackLocator INSTANCE;
    private static final Class<?> DEFAULT_CALLER_CLASS;

    public static StackLocator getInstance() {
        return INSTANCE;
    }

    private StackLocator() {
    }

    @PerformanceSensitive
    public final Class<?> getCallerClass(Class<?> sentinelClass, Predicate<Class<?>> callerPredicate) {
        Class<?> clazz;
        if (sentinelClass == null) {
            throw new IllegalArgumentException("sentinelClass cannot be null");
        }
        if (callerPredicate == null) {
            throw new IllegalArgumentException("callerPredicate cannot be null");
        }
        boolean foundSentinel = false;
        int i = 2;
        while (null != (clazz = this.getCallerClass(i))) {
            if (sentinelClass.equals(clazz)) {
                foundSentinel = true;
            } else if (foundSentinel && callerPredicate.test(clazz)) {
                return clazz;
            }
            ++i;
        }
        return DEFAULT_CALLER_CLASS;
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    public final Class<?> getCallerClass(int depth) {
        if (depth < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(depth));
        }
        if (GET_CALLER_CLASS_METHOD == null) {
            return DEFAULT_CALLER_CLASS;
        }
        try {
            void var1_1;
            return (Class)GET_CALLER_CLASS_METHOD.invoke(null, (int)(var1_1 + true + JDK_7U25_OFFSET));
        }
        catch (Exception exception) {
            return DEFAULT_CALLER_CLASS;
        }
    }

    @PerformanceSensitive
    public final Class<?> getCallerClass(String fqcn, String pkg) {
        Class<?> clazz;
        boolean next = false;
        int i = 2;
        while (null != (clazz = this.getCallerClass(i))) {
            if (fqcn.equals(clazz.getName())) {
                next = true;
            } else if (next && clazz.getName().startsWith(pkg)) {
                return clazz;
            }
            ++i;
        }
        return DEFAULT_CALLER_CLASS;
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    public final Class<?> getCallerClass(Class<?> anchor) {
        Class<?> clazz;
        boolean next = false;
        int i = 2;
        while (null != (clazz = this.getCallerClass(i))) {
            if (anchor.equals(clazz)) {
                next = true;
            } else if (next) {
                void var3_4;
                return var3_4;
            }
            ++i;
        }
        return Object.class;
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    public final Deque<Class<?>> getCurrentStackTrace() {
        void var1_1;
        Class<?> clazz;
        if (PrivateSecurityManagerStackTraceUtil.isEnabled()) {
            return PrivateSecurityManagerStackTraceUtil.getCurrentStackTrace();
        }
        ArrayDeque<void> classes = new ArrayDeque<void>();
        int i = 1;
        while (null != (clazz = this.getCallerClass(i))) {
            void var2_3;
            classes.addLast(var2_3);
            ++i;
        }
        return var1_1;
    }

    public final StackTraceElement calcLocation(String fqcnOfLogger) {
        if (fqcnOfLogger == null) {
            return null;
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        boolean found = false;
        for (int i = 0; i < stackTrace.length; ++i) {
            String className = stackTrace[i].getClassName();
            if (fqcnOfLogger.equals(className)) {
                found = true;
                continue;
            }
            if (!found || fqcnOfLogger.equals(className)) continue;
            return stackTrace[i];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final StackTraceElement getStackTraceElement(int depth) {
        void var1_1;
        int i = 0;
        for (StackTraceElement element : new Throwable().getStackTrace()) {
            if (!this.isValid(element)) continue;
            if (i == depth) {
                return element;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException(Integer.toString((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValid(StackTraceElement element) {
        void var1_1;
        void var2_2;
        if (element.isNativeMethod()) {
            return false;
        }
        String cn = element.getClassName();
        if (cn.startsWith("sun.reflect.")) {
            return false;
        }
        String mn = element.getMethodName();
        if (cn.startsWith("java.lang.reflect.") && (mn.equals("invoke") || mn.equals("newInstance"))) {
            return false;
        }
        if (cn.startsWith("jdk.internal.reflect.")) {
            return false;
        }
        if (cn.equals("java.lang.Class") && mn.equals("newInstance")) {
            return false;
        }
        return !var2_2.equals("java.lang.invoke.MethodHandle") || !var1_1.startsWith("invoke");
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1;
        void var0_2;
        Method getCallerClassMethod;
        DEFAULT_CALLER_CLASS = null;
        int java7u25CompensationOffset = 0;
        try {
            Object object;
            Class<?> sunReflectionClass = LoaderUtil.loadClass("sun.reflect.Reflection");
            getCallerClassMethod = sunReflectionClass.getDeclaredMethod("getCallerClass", Integer.TYPE);
            Object o = getCallerClassMethod.invoke(null, 0);
            getCallerClassMethod.invoke(null, 0);
            if (o == null || object != sunReflectionClass) {
                getCallerClassMethod = null;
                java7u25CompensationOffset = -1;
            } else {
                void var2_1;
                object = getCallerClassMethod.invoke(null, 1);
                if (object == var2_1) {
                    System.out.println("WARNING: Unexpected result from sun.reflect.Reflection.getCallerClass(int), adjusting offset for future calls.");
                    java7u25CompensationOffset = 1;
                }
            }
        }
        catch (Exception | LinkageError throwable) {
            System.out.println("WARNING: sun.reflect.Reflection.getCallerClass is not supported. This will impact performance.");
            getCallerClassMethod = null;
            java7u25CompensationOffset = -1;
        }
        GET_CALLER_CLASS_METHOD = var0_2;
        JDK_7U25_OFFSET = var1;
        INSTANCE = new StackLocator();
    }
}

