/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.FilteredObjectInputStream;
import org.apache.logging.log4j.util.IndexedStringMap;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.log4j.util.TriConsumer;

public class SortedArrayStringMap
implements IndexedStringMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 4;
    private static final long serialVersionUID = -5748905872274478116L;
    private static final int HASHVAL = 31;
    private static final TriConsumer<String, Object, StringMap> PUT_ALL;
    private static final String[] EMPTY;
    private static final String FROZEN = "Frozen collection cannot be modified";
    private transient String[] keys = EMPTY;
    private transient Object[] values = EMPTY;
    private transient int size;
    private static final Method setObjectInputFilter;
    private static final Method getObjectInputFilter;
    private static final Method newObjectInputFilter;
    private int threshold;
    private boolean immutable;
    private transient boolean iterating;

    public SortedArrayStringMap() {
        this(4);
    }

    /*
     * WARNING - void declaration
     */
    public SortedArrayStringMap(int initialCapacity) {
        void var1_1;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be at least zero but was " + initialCapacity);
        }
        this.threshold = SortedArrayStringMap.ceilingNextPowerOfTwo(initialCapacity == 0 ? 1 : var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public SortedArrayStringMap(ReadOnlyStringMap other) {
        if (other instanceof SortedArrayStringMap) {
            this.initFrom0((SortedArrayStringMap)other);
            return;
        }
        if (other != null) {
            void var1_1;
            this.resize(SortedArrayStringMap.ceilingNextPowerOfTwo(other.size()));
            var1_1.forEach(PUT_ALL, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SortedArrayStringMap(Map<String, ?> map) {
        Iterator iterator;
        this.resize(SortedArrayStringMap.ceilingNextPowerOfTwo(map.size()));
        for (Map.Entry entry : iterator.entrySet()) {
            void var2_2;
            this.putValue(Objects.toString(entry.getKey(), null), var2_2.getValue());
        }
    }

    private void assertNotFrozen() {
        if (this.immutable) {
            throw new UnsupportedOperationException(FROZEN);
        }
    }

    private void assertNoConcurrentModification() {
        if (this.iterating) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        if (this.keys == EMPTY) {
            return;
        }
        this.assertNotFrozen();
        this.assertNoConcurrentModification();
        Arrays.fill(this.keys, 0, this.size, null);
        Arrays.fill(this.values, 0, this.size, null);
        this.size = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(String key) {
        void var1_1;
        return this.indexOfKey((String)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> toMap() {
        void var1_1;
        HashMap<String, String> result = new HashMap<String, String>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            void var3_3;
            Object value = this.getValueAt(i);
            result.put(this.getKeyAt(i), value == null ? null : String.valueOf(var3_3));
        }
        return var1_1;
    }

    @Override
    public void freeze() {
        this.immutable = true;
    }

    @Override
    public boolean isFrozen() {
        return this.immutable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <V> V getValue(String key) {
        void var1_2;
        int index = this.indexOfKey(key);
        if (index < 0) {
            return null;
        }
        return (V)this.values[var1_2];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOfKey(String key) {
        void var1_1;
        void var2_2;
        if (this.keys == EMPTY) {
            return -1;
        }
        if (key == null) {
            return this.nullKeyIndex();
        }
        boolean start = this.size > 0 && this.keys[0] == null;
        return Arrays.binarySearch(this.keys, (int)var2_2, this.size, var1_1);
    }

    private int nullKeyIndex() {
        if (this.size > 0 && this.keys[0] == null) {
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putValue(String key, Object value) {
        void var2_2;
        void var1_1;
        void var3_3;
        int index;
        this.assertNotFrozen();
        this.assertNoConcurrentModification();
        if (this.keys == EMPTY) {
            SortedArrayStringMap sortedArrayStringMap = this;
            sortedArrayStringMap.inflateTable(sortedArrayStringMap.threshold);
        }
        if ((index = this.indexOfKey(key)) >= 0) {
            this.keys[index] = key;
            this.values[index] = value;
            return;
        }
        this.insertAt((int)(~var3_3), (String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void insertAt(int index, String key, Object value) {
        void var3_3;
        void var2_2;
        this.ensureCapacity();
        System.arraycopy(this.keys, index, this.keys, index + 1, this.size - index);
        System.arraycopy(this.values, index, this.values, index + 1, this.size - index);
        this.keys[index] = var2_2;
        this.values[var1_1] = var3_3;
        ++this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(ReadOnlyStringMap source) {
        if (source == this || source == null || source.isEmpty()) {
            return;
        }
        this.assertNotFrozen();
        this.assertNoConcurrentModification();
        if (source instanceof SortedArrayStringMap) {
            if (this.size == 0) {
                this.initFrom0((SortedArrayStringMap)source);
                return;
            }
            this.merge((SortedArrayStringMap)source);
            return;
        }
        if (source != null) {
            void var1_1;
            var1_1.forEach(PUT_ALL, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initFrom0(SortedArrayStringMap other) {
        void var1_1;
        if (this.keys.length < other.size) {
            this.keys = new String[other.threshold];
            this.values = new Object[other.threshold];
        }
        System.arraycopy(other.keys, 0, this.keys, 0, other.size);
        System.arraycopy(other.values, 0, this.values, 0, other.size);
        this.size = other.size;
        this.threshold = var1_1.threshold;
    }

    /*
     * WARNING - void declaration
     */
    private void merge(SortedArrayStringMap other) {
        String[] myKeys = this.keys;
        Object[] myVals = this.values;
        int newSize = other.size + this.size;
        this.threshold = SortedArrayStringMap.ceilingNextPowerOfTwo(newSize);
        if (this.keys.length < this.threshold) {
            this.keys = new String[this.threshold];
            this.values = new Object[this.threshold];
        }
        boolean overwrite = true;
        if (other.size() > this.size()) {
            System.arraycopy(myKeys, 0, this.keys, other.size, this.size);
            System.arraycopy(myVals, 0, this.values, other.size, this.size);
            System.arraycopy(other.keys, 0, this.keys, 0, other.size);
            System.arraycopy(other.values, 0, this.values, 0, other.size);
            this.size = other.size;
            overwrite = false;
        } else {
            void var3_5;
            System.arraycopy(myKeys, 0, this.keys, 0, this.size);
            System.arraycopy(var3_5, 0, this.values, 0, this.size);
            System.arraycopy(other.keys, 0, this.keys, this.size, other.size);
            System.arraycopy(other.values, 0, this.values, this.size, other.size);
        }
        for (int i = this.size; i < newSize; ++i) {
            SortedArrayStringMap sortedArrayStringMap = this;
            int index = sortedArrayStringMap.indexOfKey(sortedArrayStringMap.keys[i]);
            if (index < 0) {
                this.insertAt(~index, this.keys[i], this.values[i]);
                continue;
            }
            if (!overwrite) continue;
            this.keys[index] = this.keys[i];
            this.values[var2_4] = this.values[i];
        }
        Arrays.fill(this.keys, this.size, newSize, null);
        Arrays.fill(this.values, this.size, newSize, null);
    }

    private void ensureCapacity() {
        if (this.size >= this.threshold) {
            SortedArrayStringMap sortedArrayStringMap = this;
            sortedArrayStringMap.resize(sortedArrayStringMap.threshold << 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void resize(int newCapacity) {
        void var1_1;
        void var3_3;
        void var2_2;
        String[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        this.keys = new String[newCapacity];
        this.values = new Object[newCapacity];
        System.arraycopy(var2_2, 0, this.keys, 0, this.size);
        System.arraycopy(var3_3, 0, this.values, 0, this.size);
        this.threshold = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void inflateTable(int toSize) {
        void var1_1;
        this.threshold = toSize;
        this.keys = new String[toSize];
        this.values = new Object[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(String key) {
        if (this.keys == EMPTY) {
            return;
        }
        int index = this.indexOfKey(key);
        if (index >= 0) {
            void var1_2;
            this.assertNotFrozen();
            this.assertNoConcurrentModification();
            System.arraycopy(this.keys, index + 1, this.keys, index, this.size - 1 - index);
            System.arraycopy(this.values, index + 1, this.values, index, this.size - 1 - var1_2);
            this.keys[this.size - 1] = null;
            this.values[this.size - 1] = null;
            --this.size;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getKeyAt(int index) {
        void var1_1;
        if (index < 0 || index >= this.size) {
            return null;
        }
        return this.keys[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <V> V getValueAt(int index) {
        void var1_1;
        if (index < 0 || index >= this.size) {
            return null;
        }
        return (V)this.values[var1_1];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public <V> void forEach(BiConsumer<String, ? super V> action) {
        this.iterating = true;
        try {
            for (int i = 0; i < this.size; ++i) {
                action.accept(this.keys[i], this.values[i]);
            }
            return;
        }
        finally {
            this.iterating = false;
        }
    }

    public <V, T> void forEach(TriConsumer<String, ? super V, T> action, T state) {
        this.iterating = true;
        try {
            for (int i = 0; i < this.size; ++i) {
                action.accept(this.keys[i], this.values[i], state);
            }
            return;
        }
        finally {
            this.iterating = false;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SortedArrayStringMap)) {
            return false;
        }
        SortedArrayStringMap other = (SortedArrayStringMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!Objects.equals(this.keys[i], other.keys[i])) {
                return false;
            }
            if (Objects.equals(this.values[i], other.values[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 1147 + this.size;
        result = result * 31 + SortedArrayStringMap.hashCode(this.keys, this.size);
        var1_1 = var1_1 * 31 + SortedArrayStringMap.hashCode(this.values, this.size);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int hashCode(Object[] values, int length) {
        void var2_2;
        int result = 1;
        for (int i = 0; i < length; ++i) {
            result = result * 31 + (values[i] == null ? 0 : values[i].hashCode());
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder(256);
        sb.append('{');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.keys[i]).append('=');
            sb.append(this.values[i] == this ? "(this map)" : this.values[i]);
        }
        sb.append('}');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.keys == EMPTY) {
            s.writeInt(SortedArrayStringMap.ceilingNextPowerOfTwo(this.threshold));
        } else {
            s.writeInt(this.keys.length);
        }
        s.writeInt(this.size);
        if (this.size > 0) {
            for (int i = 0; i < this.size; ++i) {
                s.writeObject(this.keys[i]);
                try {
                    s.writeObject(SortedArrayStringMap.marshall(this.values[i]));
                    continue;
                }
                catch (Exception e) {
                    void var3_3;
                    this.handleSerializationException((Throwable)var3_3, i, this.keys[i]);
                    s.writeObject(null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] marshall(Object obj) throws IOException {
        Object object;
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bout);
        Throwable throwable = null;
        try {
            void var1_2;
            oos.writeObject(object);
            oos.flush();
            object = var1_2.toByteArray();
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    try {
                        oos.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    void var2_4;
                    var2_4.close();
                }
                throw throwable3;
            }
        }
        oos.close();
        return object;
    }

    private static Object unmarshall(byte[] data, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        Object object;
        Object ois;
        Collection<String> allowedClasses;
        Object bin = new ByteArrayInputStream(data);
        if (inputStream instanceof FilteredObjectInputStream) {
            allowedClasses = ((FilteredObjectInputStream)inputStream).getAllowedClasses();
            ois = new FilteredObjectInputStream((InputStream)bin, allowedClasses);
        } else {
            try {
                Object obj = getObjectInputFilter.invoke((Object)allowedClasses, new Object[0]);
                Object filter = newObjectInputFilter.invoke(null, obj);
                ois = new ObjectInputStream((InputStream)ois);
                setObjectInputFilter.invoke(ois, object);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new StreamCorruptedException("Unable to set ObjectInputFilter on stream");
            }
        }
        try {
            object = ((ObjectInputStream)ois).readObject();
        }
        catch (Throwable throwable) {
            Object object2;
            ((ObjectInputStream)object2).close();
            throw throwable;
        }
        ((ObjectInputStream)ois).close();
        return object;
    }

    private static int ceilingNextPowerOfTwo(int x) {
        int n;
        return 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        void var3_3;
        if (!(s instanceof FilteredObjectInputStream) && setObjectInputFilter == null) {
            throw new IllegalArgumentException("readObject requires a FilteredObjectInputStream or an ObjectInputStream that accepts an ObjectInputFilter");
        }
        s.defaultReadObject();
        this.keys = EMPTY;
        this.values = EMPTY;
        int capacity = s.readInt();
        if (capacity < 0) {
            throw new InvalidObjectException("Illegal capacity: " + capacity);
        }
        int mappings = s.readInt();
        if (mappings < 0) {
            throw new InvalidObjectException("Illegal mappings count: " + mappings);
        }
        if (mappings > 0) {
            this.inflateTable(capacity);
        } else {
            this.threshold = capacity;
        }
        for (int i = 0; i < mappings; ++i) {
            this.keys[i] = (String)s.readObject();
            try {
                byte[] marshalledObject = (byte[])s.readObject();
                this.values[i] = marshalledObject == null ? null : SortedArrayStringMap.unmarshall(marshalledObject, s);
                continue;
            }
            catch (Exception | LinkageError error) {
                this.handleSerializationException(error, i, this.keys[i]);
                this.values[i] = null;
            }
        }
        this.size = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private void handleSerializationException(Throwable t, int i, String key) {
        void var2_2;
        void var1_1;
        StatusLogger.getLogger().warn("Ignoring {} for key[{}] ('{}')", (Object)String.valueOf(var1_1), (Object)i, (Object)this.keys[var2_2]);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_5;
        void var1_4;
        void var3_6;
        block5: {
            void var0;
            PUT_ALL = (key, value, contextData) -> {
                void var1_1;
                String string;
                contextData.putValue(string, var1_1);
            };
            EMPTY = Strings.EMPTY_ARRAY;
            Method[] methods = ObjectInputStream.class.getMethods();
            Object setMethod = null;
            Object getMethod = null;
            var3_6 = var0;
            int n = ((void)var3_6).length;
            for (int i = 0; i < n; ++i) {
                void method = var3_6[i];
                if (method.getName().equals("setObjectInputFilter")) {
                    setMethod = method;
                    continue;
                }
                if (!method.getName().equals("getObjectInputFilter")) continue;
                getMethod = method;
            }
            Method newMethod = null;
            try {
                if (setMethod == null) break block5;
                Method[] methodArray = Class.forName("org.apache.logging.log4j.util.internal.DefaultObjectInputFilter");
                Method[] methodArray2 = methodArray = methodArray.getMethods();
                int n2 = methodArray.length;
                for (int i = 0; i < n2; ++i) {
                    Method method = methodArray2[i];
                    if (!method.getName().equals("newInstance") || !Modifier.isStatic(method.getModifiers())) continue;
                    newMethod = method;
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        newObjectInputFilter = var3_6;
        setObjectInputFilter = var1_4;
        getObjectInputFilter = var2_5;
    }
}

