/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.OsgiServiceLocator;

public final class ServiceLoaderUtil {
    private static final int MAX_BROKEN_SERVICES = 8;

    private ServiceLoaderUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup) {
        void var1_1;
        return ServiceLoaderUtil.loadServices(serviceType, (MethodHandles.Lookup)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup, boolean useTccl) {
        void var2_2;
        void var1_1;
        return ServiceLoaderUtil.loadServices(serviceType, (MethodHandles.Lookup)var1_1, (boolean)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup, boolean useTccl, boolean verbose) {
        void var2_4;
        ClassLoader contextClassLoader;
        ClassLoader classLoader = lookup.lookupClass().getClassLoader();
        Stream<Object> services = ServiceLoaderUtil.loadClassloaderServices(serviceType, lookup, classLoader, verbose);
        if (useTccl && (contextClassLoader = LoaderUtil.getThreadContextClassLoader()) != classLoader) {
            services = Stream.concat(services, ServiceLoaderUtil.loadClassloaderServices(serviceType, lookup, contextClassLoader, verbose));
        }
        if (OsgiServiceLocator.isAvailable()) {
            void var3_5;
            void var1_1;
            Class<T> clazz;
            services = Stream.concat(services, OsgiServiceLocator.loadServices(clazz, (MethodHandles.Lookup)var1_1, (boolean)var3_5));
        }
        HashSet classes = new HashSet();
        return services.filter(arg_0 -> ServiceLoaderUtil.lambda$loadServices$0((Set)var2_4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    static <T> Stream<T> loadClassloaderServices(Class<T> serviceType, MethodHandles.Lookup lookup, ClassLoader classLoader, boolean verbose) {
        void var3_3;
        void var2_2;
        void var1_1;
        Class<T> clazz;
        return StreamSupport.stream(new ServiceLoaderSpliterator<T>(clazz, (MethodHandles.Lookup)var1_1, (ClassLoader)var2_2, (boolean)var3_3), false);
    }

    /*
     * WARNING - void declaration
     */
    static <T> Iterable<T> callServiceLoader(MethodHandles.Lookup lookup, Class<T> serviceType, ClassLoader classLoader, boolean verbose) {
        try {
            Object object;
            Object serviceLoader;
            Object loadHandle = lookup.findStatic(ServiceLoader.class, "load", MethodType.methodType(ServiceLoader.class, Class.class, ClassLoader.class));
            loadHandle = LambdaMetafactory.metafactory(lookup, "run", MethodType.methodType(PrivilegedAction.class, Class.class, ClassLoader.class), MethodType.methodType(Object.class), (MethodHandle)loadHandle, MethodType.methodType(ServiceLoader.class));
            PrivilegedAction action = ((CallSite)loadHandle).getTarget().bindTo(serviceType).bindTo(classLoader).invoke();
            if (System.getSecurityManager() == null) {
                serviceLoader = (ServiceLoader)action.run();
            } else {
                void var2_2;
                serviceLoader = ((MethodHandles.Lookup)serviceLoader).findStatic(AccessController.class, "doPrivileged", MethodType.methodType(Object.class, PrivilegedAction.class));
                serviceLoader = serviceLoader.invoke((PrivilegedAction)var2_2);
            }
            return object;
        }
        catch (Throwable e) {
            void var3_3;
            if (var3_3 != false) {
                void var1_1;
                StatusLogger.getLogger().error("Unable to load services for service {}", (Object)var1_1, (Object)e);
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$loadServices$0(Set classes, Object service) {
        void var1_1;
        return classes.add(var1_1.getClass());
    }

    private static class ServiceLoaderSpliterator<S>
    implements Spliterator<S> {
        private final Iterator<S> serviceIterator;
        private final Logger logger;
        private final String serviceName;

        /*
         * WARNING - void declaration
         */
        public ServiceLoaderSpliterator(Class<S> serviceType, MethodHandles.Lookup lookup, ClassLoader classLoader, boolean verbose) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.serviceIterator = ServiceLoaderUtil.callServiceLoader((MethodHandles.Lookup)var2_2, serviceType, (ClassLoader)var3_3, verbose).iterator();
            this.logger = verbose ? StatusLogger.getLogger() : null;
            this.serviceName = var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean tryAdvance(Consumer<? super S> action) {
            int i = 8;
            while (i-- > 0) {
                try {
                    if (!this.serviceIterator.hasNext()) continue;
                    action.accept(this.serviceIterator.next());
                    return true;
                }
                catch (LinkageError | ServiceConfigurationError e) {
                    if (this.logger == null) continue;
                    this.logger.warn("Unable to load service class for service {}", (Object)this.serviceName, (Object)e);
                }
                catch (Throwable e) {
                    void var3_4;
                    if (this.logger != null) {
                        this.logger.warn("Unable to load service class for service {}", (Object)this.serviceName, (Object)e);
                    }
                    throw var3_4;
                }
            }
            return false;
        }

        @Override
        public Spliterator<S> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1280;
        }
    }
}

