/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.util.BiConsumer;

public interface PropertySource {
    public int getPriority();

    default public void forEach(BiConsumer<String, String> action) {
    }

    default public Collection<String> getPropertyNames() {
        return Collections.emptySet();
    }

    default public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        return null;
    }

    default public String getProperty(String key) {
        return null;
    }

    default public boolean containsProperty(String key) {
        return false;
    }

    public static final class Util {
        private static final Pattern PREFIX_PATTERN = Pattern.compile("(^log4j2?[-._/]?|^org\\.apache\\.logging\\.log4j\\.)|(?=AsyncLogger(Config)?\\.)", 2);
        private static final Pattern PROPERTY_TOKENIZER = Pattern.compile("([A-Z]*[a-z0-9]+|[A-Z0-9]+)[-._/]?");
        private static final Map<CharSequence, List<CharSequence>> CACHE = new ConcurrentHashMap<CharSequence, List<CharSequence>>();

        /*
         * WARNING - void declaration
         */
        public static List<CharSequence> tokenize(CharSequence value) {
            void var1_1;
            CharSequence charSequence;
            if (CACHE.containsKey(value)) {
                return CACHE.get(value);
            }
            ArrayList<String> tokens = new ArrayList<String>();
            Matcher prefixMatcher = PREFIX_PATTERN.matcher(value);
            if (prefixMatcher.find(0)) {
                int start = prefixMatcher.end();
                Matcher matcher = PROPERTY_TOKENIZER.matcher(value);
                while (matcher.find(start)) {
                    tokens.add(matcher.group(1).toLowerCase());
                    start = matcher.end();
                }
            }
            CACHE.put(charSequence, tokens);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static CharSequence joinAsCamelCase(Iterable<? extends CharSequence> tokens) {
            void var1_1;
            Iterator<? extends CharSequence> iterator;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                CharSequence token = (CharSequence)iterator.next();
                if (first) {
                    sb.append(token);
                } else {
                    sb.append(Character.toUpperCase(token.charAt(0)));
                    if (token.length() > 1) {
                        void var3_3;
                        sb.append(token.subSequence(1, var3_3.length()));
                    }
                }
                first = false;
            }
            return var1_1.toString();
        }

        private Util() {
        }

        static {
            CACHE.put("disableThreadContext", Arrays.asList("disable", "thread", "context"));
            CACHE.put("disableThreadContextStack", Arrays.asList("disable", "thread", "context", "stack"));
            CACHE.put("disableThreadContextMap", Arrays.asList("disable", "thread", "context", "map"));
            CACHE.put("isThreadContextMapInheritable", Arrays.asList("is", "thread", "context", "map", "inheritable"));
        }
    }

    public static class Comparator
    implements Serializable,
    java.util.Comparator<PropertySource> {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(PropertySource o1, PropertySource o2) {
            void var2_2;
            return Integer.compare(Objects.requireNonNull(o1).getPriority(), ((PropertySource)Objects.requireNonNull(var2_2)).getPriority());
        }
    }
}

