/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesPropertySource;
import org.apache.logging.log4j.util.PropertyFilePropertySource;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.ServiceLoaderUtil;
import org.apache.logging.log4j.util.Supplier;

public final class PropertiesUtil {
    private static final String LOG4J_PROPERTIES_FILE_NAME = "log4j2.component.properties";
    private static final String LOG4J_SYSTEM_PROPERTIES_FILE_NAME = "log4j2.system.properties";
    private static final PropertiesUtil LOG4J_PROPERTIES = new PropertiesUtil("log4j2.component.properties", false);
    private final Environment environment;

    /*
     * WARNING - void declaration
     */
    public PropertiesUtil(Properties props) {
        this(new PropertiesPropertySource((Properties)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PropertiesUtil(String propertiesFileName) {
        this((String)var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private PropertiesUtil(String propertiesFileName, boolean useTccl) {
        this(new PropertyFilePropertySource((String)var1_1, (boolean)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    PropertiesUtil(PropertySource source) {
        void var1_1;
        this.environment = new Environment((PropertySource)var1_1);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    static Properties loadClose(InputStream in, Object source) {
        void var2_3;
        block11: {
            Properties props2222222222 = new Properties();
            if (in != null) {
                props2222222222.load(in);
                try {
                    in.close();
                }
                catch (IOException e) {
                    LowLevelLogUtil.logException("Unable to close " + source, e);
                }
                break block11;
                catch (IOException e) {
                    try {
                        LowLevelLogUtil.logException("Unable to read " + source, e);
                    }
                    catch (Throwable props2222222222) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            void var0_1;
                            void var1_2;
                            LowLevelLogUtil.logException("Unable to close " + var1_2, (Throwable)var0_1);
                        }
                        throw props2222222222;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        void var3_7;
                        LowLevelLogUtil.logException("Unable to close " + source, (Throwable)var3_7);
                    }
                }
            }
        }
        return var2_3;
    }

    public static PropertiesUtil getProperties() {
        return LOG4J_PROPERTIES;
    }

    /*
     * WARNING - void declaration
     */
    public final void addPropertySource(PropertySource propertySource) {
        if (this.environment != null) {
            void var1_1;
            this.environment.addPropertySource((PropertySource)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasProperty(String name) {
        void var1_1;
        return Environment.access$100(this.environment, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getBooleanProperty(String name) {
        void var1_1;
        return this.getBooleanProperty((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getBooleanProperty(String name, boolean defaultValue) {
        void var1_1;
        String prop = this.getStringProperty(name);
        if (prop == null) {
            void var2_2;
            return (boolean)var2_2;
        }
        return "true".equalsIgnoreCase((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getBooleanProperty(String name, boolean defaultValueIfAbsent, boolean defaultValueIfPresent) {
        void var1_1;
        String prop = this.getStringProperty(name);
        if (prop == null) {
            void var2_2;
            return (boolean)var2_2;
        }
        if (prop.isEmpty()) {
            void var3_3;
            return (boolean)var3_3;
        }
        return "true".equalsIgnoreCase((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Boolean getBooleanProperty(String[] prefixes, String key, Supplier<Boolean> supplier) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        for (int i = 0; i < n; ++i) {
            String prefix = stringArray[i];
            if (!this.hasProperty(prefix + key)) continue;
            return this.getBooleanProperty(prefix + key);
        }
        if (supplier != null) {
            void var3_3;
            return (Boolean)var3_3.get();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final Charset getCharsetProperty(String name) {
        void var1_1;
        return this.getCharsetProperty((String)var1_1, Charset.defaultCharset());
    }

    /*
     * WARNING - void declaration
     */
    public final Charset getCharsetProperty(String name, Charset defaultValue) {
        void var2_2;
        void var1_1;
        void var3_3;
        String mapped;
        String charsetName = this.getStringProperty(name);
        if (charsetName == null) {
            return defaultValue;
        }
        if (Charset.isSupported(charsetName)) {
            return Charset.forName(charsetName);
        }
        ResourceBundle bundle = PropertiesUtil.getCharsetsResourceBundle();
        if (bundle.containsKey(name) && Charset.isSupported(mapped = bundle.getString(name))) {
            return Charset.forName(mapped);
        }
        LowLevelLogUtil.log("Unable to get Charset '" + (String)var3_3 + "' for property '" + (String)var1_1 + "', using default " + defaultValue + " and continuing.");
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final double getDoubleProperty(String name, double defaultValue) {
        void var2_2;
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                void var1_1;
                return Double.parseDouble((String)var1_1);
            }
            catch (Exception exception) {}
        }
        return (double)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int getIntegerProperty(String name, int defaultValue) {
        void var2_2;
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                void var1_1;
                return Integer.parseInt(var1_1.trim());
            }
            catch (Exception exception) {}
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Integer getIntegerProperty(String[] prefixes, String key, Supplier<Integer> supplier) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        for (int i = 0; i < n; ++i) {
            String prefix = stringArray[i];
            if (!this.hasProperty(prefix + key)) continue;
            return this.getIntegerProperty(prefix + key, 0);
        }
        if (supplier != null) {
            void var3_3;
            return (Integer)var3_3.get();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final long getLongProperty(String name, long defaultValue) {
        void var2_2;
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                void var1_1;
                return Long.parseLong((String)var1_1);
            }
            catch (Exception exception) {}
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Long getLongProperty(String[] prefixes, String key, Supplier<Long> supplier) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        for (int i = 0; i < n; ++i) {
            String prefix = stringArray[i];
            if (!this.hasProperty(prefix + key)) continue;
            return this.getLongProperty(prefix + key, 0L);
        }
        if (supplier != null) {
            void var3_3;
            return (Long)var3_3.get();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final Duration getDurationProperty(String name, Duration defaultValue) {
        void var2_2;
        String prop = this.getStringProperty(name);
        if (prop != null) {
            void var1_1;
            return TimeUnit.getDuration((String)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Duration getDurationProperty(String[] prefixes, String key, Supplier<Duration> supplier) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        for (int i = 0; i < n; ++i) {
            String prefix = stringArray[i];
            if (!this.hasProperty(prefix + key)) continue;
            return this.getDurationProperty(prefix + key, null);
        }
        if (supplier != null) {
            void var3_3;
            return (Duration)var3_3.get();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final String getStringProperty(String[] prefixes, String key, Supplier<String> supplier) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        for (int i = 0; i < n; ++i) {
            String prefix = stringArray[i];
            String result = this.getStringProperty(prefix + key);
            if (result == null) continue;
            return result;
        }
        if (supplier != null) {
            void var3_3;
            return (String)var3_3.get();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final String getStringProperty(String name) {
        void var1_1;
        return Environment.access$200(this.environment, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String getStringProperty(String name, String defaultValue) {
        void var1_1;
        String prop = this.getStringProperty(name);
        if (prop == null) {
            void var2_2;
            return var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Properties getSystemProperties() {
        try {
            return new Properties(System.getProperties());
        }
        catch (SecurityException ex) {
            void var0;
            LowLevelLogUtil.logException("Unable to access system properties.", (Throwable)var0);
            return new Properties();
        }
    }

    public final void reload() {
        this.environment.reload();
    }

    /*
     * WARNING - void declaration
     */
    public static Properties extractSubset(Properties properties, String prefix) {
        void var2_2;
        void var3_3;
        void prefixToMatch;
        Properties subset = new Properties();
        if (prefix == null || prefix.length() == 0) {
            return subset;
        }
        String string = prefix;
        prefixToMatch = string.charAt(string.length() - 1) != '.' ? prefix + '.' : prefixToMatch;
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith((String)prefixToMatch)) continue;
            subset.setProperty(key.substring(prefixToMatch.length()), properties.getProperty(key));
            keys.add(key);
        }
        for (String key : var3_3) {
            properties.remove(key);
        }
        return var2_2;
    }

    static ResourceBundle getCharsetsResourceBundle() {
        return ResourceBundle.getBundle("Log4j-charsets");
    }

    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties) {
        return PropertiesUtil.partitionOnCommonPrefixes(properties, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties, boolean includeBaseKey) {
        void var2_2;
        ConcurrentHashMap<String, Properties> parts = new ConcurrentHashMap<String, Properties>();
        for (String key : properties.stringPropertyNames()) {
            int idx = key.indexOf(46);
            if (idx < 0) {
                if (!includeBaseKey) continue;
                if (!parts.containsKey(key)) {
                    parts.put(key, new Properties());
                }
                ((Properties)parts.get(key)).setProperty("", properties.getProperty(key));
                continue;
            }
            String prefix = key.substring(0, idx);
            if (!parts.containsKey(prefix)) {
                parts.put(prefix, new Properties());
            }
            ((Properties)parts.get(prefix)).setProperty(key.substring(idx + 1), properties.getProperty(key));
        }
        return var2_2;
    }

    public final boolean isOsWindows() {
        return this.getStringProperty("os.name", "").startsWith("Windows");
    }

    private static enum TimeUnit {
        NANOS("ns,nano,nanos,nanosecond,nanoseconds", ChronoUnit.NANOS),
        MICROS("us,micro,micros,microsecond,microseconds", ChronoUnit.MICROS),
        MILLIS("ms,milli,millis,millsecond,milliseconds", ChronoUnit.MILLIS),
        SECONDS("s,second,seconds", ChronoUnit.SECONDS),
        MINUTES("m,minute,minutes", ChronoUnit.MINUTES),
        HOURS("h,hour,hours", ChronoUnit.HOURS),
        DAYS("d,day,days", ChronoUnit.DAYS);

        private final String[] descriptions;
        private final ChronoUnit timeUnit;

        /*
         * WARNING - void declaration
         */
        private TimeUnit(String descriptions, ChronoUnit timeUnit) {
            void var3_3;
            this.descriptions = var3_3.split(",");
            this.timeUnit = timeUnit;
        }

        final ChronoUnit getTimeUnit() {
            return this.timeUnit;
        }

        /*
         * WARNING - void declaration
         */
        static Duration getDuration(String time) {
            void var1_1;
            void var3_2;
            String value = time.trim();
            ChronoUnit temporalUnit = ChronoUnit.MILLIS;
            long timeVal = 0L;
            for (TimeUnit timeUnit : TimeUnit.values()) {
                String[] stringArray = timeUnit.descriptions;
                int n = timeUnit.descriptions.length;
                for (int i = 0; i < n; ++i) {
                    String suffix = stringArray[i];
                    if (!value.endsWith(suffix)) continue;
                    temporalUnit = timeUnit.timeUnit;
                    timeVal = Long.parseLong(value.substring(0, value.length() - suffix.length()));
                }
            }
            return Duration.of((long)var3_2, (TemporalUnit)var1_1);
        }
    }

    private static class Environment {
        private final Set<PropertySource> sources = new ConcurrentSkipListSet<PropertySource>(new PropertySource.Comparator());
        private final Map<String, String> literal = new ConcurrentHashMap<String, String>();
        private final Map<List<CharSequence>, String> tokenized = new ConcurrentHashMap<List<CharSequence>, String>();

        /*
         * WARNING - void declaration
         */
        private Environment(PropertySource propertySource) {
            void var1_1;
            PropertyFilePropertySource sysProps = new PropertyFilePropertySource(PropertiesUtil.LOG4J_SYSTEM_PROPERTIES_FILE_NAME, false);
            try {
                void var2_2;
                var2_2.forEach((key, value) -> {
                    if (System.getProperty(key) == null) {
                        void var1_1;
                        String string;
                        System.setProperty(string, (String)var1_1);
                    }
                });
            }
            catch (SecurityException securityException) {}
            this.sources.add((PropertySource)var1_1);
            ServiceLoaderUtil.loadServices(PropertySource.class, MethodHandles.lookup(), false, false).forEach(this.sources::add);
            this.reload();
        }

        /*
         * WARNING - void declaration
         */
        public void addPropertySource(PropertySource propertySource) {
            void var1_1;
            this.sources.add((PropertySource)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private synchronized void reload() {
            void var1_1;
            this.literal.clear();
            this.tokenized.clear();
            HashSet keys = new HashSet();
            this.sources.stream().map(PropertySource::getPropertyNames).reduce(keys, (left, right) -> {
                Collection collection;
                void var1_1;
                left.addAll(var1_1);
                return collection;
            });
            var1_1.stream().filter(Objects::nonNull).forEach(key -> {
                void var2_2;
                void var3_3;
                void var1_1;
                List<CharSequence> tokens = PropertySource.Util.tokenize(key);
                boolean hasTokens = !tokens.isEmpty();
                this.sources.forEach(arg_0 -> this.lambda$null$2((String)var1_1, (boolean)var3_3, (List)var2_2, arg_0));
            });
        }

        /*
         * WARNING - void declaration
         */
        private String get(String key) {
            void var2_2;
            if (this.literal.containsKey(key)) {
                return this.literal.get(key);
            }
            List<CharSequence> tokens = PropertySource.Util.tokenize(key);
            boolean hasTokens = !tokens.isEmpty();
            for (PropertySource source : this.sources) {
                String normalKey;
                if (hasTokens && (normalKey = Objects.toString(source.getNormalForm(tokens), null)) != null && source.containsProperty(normalKey)) {
                    return source.getProperty(normalKey);
                }
                if (!source.containsProperty(key)) continue;
                return source.getProperty(key);
            }
            return this.tokenized.get(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private boolean containsKey(String key) {
            void var1_1;
            void var2_2;
            List<CharSequence> tokens = PropertySource.Util.tokenize(key);
            return this.literal.containsKey(key) || this.tokenized.containsKey(tokens) || this.sources.stream().anyMatch(arg_0 -> Environment.lambda$containsKey$4((List)var2_2, (String)var1_1, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ boolean lambda$containsKey$4(List tokens, String key, PropertySource s) {
            CharSequence charSequence;
            void var2_2;
            void var1_1;
            CharSequence normalizedKey = s.getNormalForm(tokens);
            return s.containsProperty((String)var1_1) || normalizedKey != null && var2_2.containsProperty(charSequence.toString());
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$null$2(String key, boolean hasTokens, List tokens, PropertySource source) {
            void var2_2;
            if (source.containsProperty(key)) {
                String value = source.getProperty(key);
                if (hasTokens) {
                    this.tokenized.putIfAbsent(tokens, value);
                }
            }
            if (var2_2 != false) {
                void var3_3;
                String normalKey = Objects.toString(source.getNormalForm((Iterable<? extends CharSequence>)var3_3), null);
                if (normalKey != null && source.containsProperty(normalKey)) {
                    this.literal.putIfAbsent(key, source.getProperty(normalKey));
                    return;
                }
                if (source.containsProperty(key)) {
                    void var1_1;
                    this.literal.putIfAbsent(key, source.getProperty((String)var1_1));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$100(Environment x0, String x1) {
            void var1_1;
            return x0.containsKey((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$200(Environment x0, String x1) {
            void var1_1;
            return x0.get((String)var1_1);
        }
    }
}

