/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.MethodHandles;
import java.util.stream.Stream;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class OsgiServiceLocator {
    private static final boolean OSGI_AVAILABLE = OsgiServiceLocator.checkOsgiAvailable();

    /*
     * WARNING - void declaration
     */
    private static boolean checkOsgiAvailable() {
        try {
            Class<?> clazz = Class.forName("org.osgi.framework.FrameworkUtil");
            return clazz.getMethod("getBundle", Class.class).invoke(null, OsgiServiceLocator.class) != null;
        }
        catch (ClassNotFoundException | LinkageError | NoSuchMethodException throwable) {
            return false;
        }
        catch (Throwable e) {
            void var0_1;
            LowLevelLogUtil.logException("Unknown error checking OSGI environment.", (Throwable)var0_1);
            return false;
        }
    }

    public static boolean isAvailable() {
        return OSGI_AVAILABLE;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup) {
        void var1_1;
        return OsgiServiceLocator.loadServices(serviceType, (MethodHandles.Lookup)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup, boolean verbose) {
        block3: {
            Bundle bundle = FrameworkUtil.getBundle(lookup.lookupClass());
            if (bundle != null) {
                BundleContext ctx = bundle.getBundleContext();
                try {
                    return ctx.getServiceReferences(serviceType, null).stream().map(arg_0 -> ((BundleContext)ctx).getService(arg_0));
                }
                catch (Throwable e) {
                    void var1_2;
                    Class<T> clazz;
                    void var2_3;
                    if (var2_3 == false) break block3;
                    StatusLogger.getLogger().error("Unable to load OSGI services for service {}", (Object)clazz, (Object)var1_2);
                }
            }
        }
        return Stream.empty();
    }
}

