/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class LoaderUtil {
    private static final ClassLoader[] EMPTY_CLASS_LOADER_ARRAY = new ClassLoader[0];
    public static final String IGNORE_TCCL_PROPERTY = "log4j.ignoreTCL";
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    private static Boolean ignoreTCCL;
    private static final boolean GET_CLASS_LOADER_DISABLED;
    private static final PrivilegedAction<ClassLoader> TCCL_GETTER;

    private LoaderUtil() {
    }

    public static ClassLoader getThreadContextClassLoader() {
        if (GET_CLASS_LOADER_DISABLED) {
            return LoaderUtil.class.getClassLoader();
        }
        if (SECURITY_MANAGER == null) {
            return TCCL_GETTER.run();
        }
        return AccessController.doPrivileged(TCCL_GETTER);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isClassAvailable(String className) {
        try {
            Class<?> clazz = LoaderUtil.loadClass(className);
            return clazz != null;
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            return false;
        }
        catch (Throwable e) {
            void var1_2;
            String string;
            LowLevelLogUtil.logException("Unknown error checking for existence of class: " + string, (Throwable)var1_2);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        String string;
        if (LoaderUtil.isIgnoreTccl()) {
            return Class.forName(className);
        }
        try {
            ClassLoader tccl = LoaderUtil.getThreadContextClassLoader();
            if (tccl != null) {
                void var1_1;
                return var1_1.loadClass(className);
            }
        }
        catch (Throwable throwable) {}
        return Class.forName(string);
    }

    public static <T> T newInstanceOf(Class<T> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class<T> clazz2;
            return clazz2.newInstance();
        }
    }

    public static <T> T newInstanceOf(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        return (T)LoaderUtil.newInstanceOf(LoaderUtil.loadClass(className));
    }

    public static <T> T newCheckedInstanceOf(String className, Class<T> clazz) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        String string;
        return clazz.cast(LoaderUtil.newInstanceOf(string));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T newCheckedInstanceOfProperty(String propertyName, Class<T> clazz) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        void var1_1;
        String string;
        String className = PropertiesUtil.getProperties().getStringProperty(propertyName);
        if (className == null) {
            return null;
        }
        return LoaderUtil.newCheckedInstanceOf(string, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isIgnoreTccl() {
        if (ignoreTCCL == null) {
            void var0;
            String ignoreTccl = PropertiesUtil.getProperties().getStringProperty(IGNORE_TCCL_PROPERTY, null);
            ignoreTCCL = ignoreTccl != null && !"false".equalsIgnoreCase(var0.trim());
        }
        return ignoreTCCL;
    }

    public static Collection<URL> findResources(String resource) {
        return LoaderUtil.findResources(resource, true);
    }

    /*
     * WARNING - void declaration
     */
    static Collection<URL> findResources(String resource, boolean useTccl) {
        void var1_2;
        Iterator iterator;
        Iterator urlResources = LoaderUtil.findUrlResources(resource, useTccl);
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>(urlResources.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_3;
            UrlResource urlResource = (UrlResource)iterator.next();
            resources.add(var2_3.getUrl());
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    static Collection<UrlResource> findUrlResources(String resource, boolean useTccl) {
        void var2_3;
        void var1_2;
        ClassLoader[] candidates = new ClassLoader[]{useTccl ? LoaderUtil.getThreadContextClassLoader() : null, LoaderUtil.class.getClassLoader(), GET_CLASS_LOADER_DISABLED ? null : ClassLoader.getSystemClassLoader()};
        LinkedHashSet<UrlResource> resources = new LinkedHashSet<UrlResource>();
        int cfr_ignored_0 = ((void)var1_2).length;
        for (int i = 0; i < 3; ++i) {
            void cl = var1_2[i];
            if (cl == null) continue;
            try {
                Enumeration<URL> resourceEnum = cl.getResources(resource);
                while (resourceEnum.hasMoreElements()) {
                    resources.add(new UrlResource((ClassLoader)cl, resourceEnum.nextElement()));
                }
                continue;
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                LowLevelLogUtil.logException(iOException);
            }
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static {
        TCCL_GETTER = new ThreadContextClassLoaderGetter();
        if (SECURITY_MANAGER != null) {
            void var0;
            boolean getClassLoaderDisabled;
            try {
                SECURITY_MANAGER.checkPermission(new RuntimePermission("getClassLoader"));
                getClassLoaderDisabled = false;
            }
            catch (SecurityException securityException) {
                getClassLoaderDisabled = true;
            }
            GET_CLASS_LOADER_DISABLED = var0;
        } else {
            GET_CLASS_LOADER_DISABLED = false;
        }
    }

    static class UrlResource {
        private final ClassLoader classLoader;
        private final URL url;

        /*
         * WARNING - void declaration
         */
        UrlResource(ClassLoader classLoader, URL url) {
            void var2_2;
            void var1_1;
            this.classLoader = var1_1;
            this.url = var2_2;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public URL getUrl() {
            return this.url;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlResource that = (UrlResource)o;
            if (this.classLoader != null ? !this.classLoader.equals(that.classLoader) : that.classLoader != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(that.url) : var1_1.url != null);
        }

        public int hashCode() {
            return Objects.hashCode(this.classLoader) + Objects.hashCode(this.url);
        }
    }

    private static class ThreadContextClassLoaderGetter
    implements PrivilegedAction<ClassLoader> {
        private ThreadContextClassLoaderGetter() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ClassLoader run() {
            void var1_1;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl;
            }
            ClassLoader ccl = LoaderUtil.class.getClassLoader();
            if (ccl == null && !GET_CLASS_LOADER_DISABLED) {
                return ClassLoader.getSystemClassLoader();
            }
            return var1_1;
        }
    }
}

