/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FilteredObjectInputStream
extends ObjectInputStream {
    private static final Set<String> REQUIRED_JAVA_CLASSES = new HashSet<String>(Arrays.asList("java.math.BigDecimal", "java.math.BigInteger", "java.rmi.MarshalledObject", "[B"));
    private static final Set<String> REQUIRED_JAVA_PACKAGES = new HashSet<String>(Arrays.asList("java.lang.", "java.time.", "java.util.", "org.apache.logging.log4j.", "[Lorg.apache.logging.log4j."));
    private final Collection<String> allowedExtraClasses;

    public FilteredObjectInputStream() throws IOException, SecurityException {
        this.allowedExtraClasses = Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    public FilteredObjectInputStream(InputStream inputStream) throws IOException {
        super((InputStream)var1_1);
        void var1_1;
        this.allowedExtraClasses = Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    public FilteredObjectInputStream(Collection<String> allowedExtraClasses) throws IOException, SecurityException {
        void var1_1;
        this.allowedExtraClasses = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FilteredObjectInputStream(InputStream inputStream, Collection<String> allowedExtraClasses) throws IOException {
        super((InputStream)var1_1);
        void var2_2;
        void var1_1;
        this.allowedExtraClasses = var2_2;
    }

    public Collection<String> getAllowedClasses() {
        return this.allowedExtraClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        void var1_1;
        String name = desc.getName();
        if (!FilteredObjectInputStream.isAllowedByDefault(name) && !this.allowedExtraClasses.contains(name)) {
            void var2_2;
            throw new InvalidObjectException("Class is not allowed for deserialization: " + (String)var2_2);
        }
        return super.resolveClass((ObjectStreamClass)var1_1);
    }

    private static boolean isAllowedByDefault(String name) {
        String string;
        return FilteredObjectInputStream.isRequiredPackage(name) || REQUIRED_JAVA_CLASSES.contains(string);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isRequiredPackage(String name) {
        for (String packageName : REQUIRED_JAVA_PACKAGES) {
            void var2_2;
            if (!name.startsWith((String)var2_2)) continue;
            return true;
        }
        return false;
    }
}

