/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertySource;

public class EnvironmentPropertySource
implements PropertySource {
    private static final String PREFIX = "LOG4J_";
    private static final int DEFAULT_PRIORITY = 100;

    @Override
    public int getPriority() {
        return 100;
    }

    /*
     * WARNING - void declaration
     */
    private void logException(SecurityException e) {
        void var1_1;
        LowLevelLogUtil.logException("The system environment variables are not available to Log4j due to security restrictions: " + e, (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forEach(BiConsumer<String, String> action) {
        Iterator iterator;
        try {
            Map<String, String> getenv = System.getenv();
        }
        catch (SecurityException e) {
            this.logException(e);
            return;
        }
        for (Map.Entry entry : iterator.entrySet()) {
            void var3_4;
            String key = (String)entry.getKey();
            if (!key.startsWith(PREFIX)) continue;
            action.accept(key.substring(6), (String)var3_4.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        void var2_2;
        void var3_3;
        Iterator iterator;
        StringBuilder sb = new StringBuilder("LOG4J");
        boolean empty = true;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            CharSequence token = (CharSequence)iterator.next();
            empty = false;
            sb.append('_');
            for (int i = 0; i < token.length(); ++i) {
                sb.append(Character.toUpperCase(token.charAt(i)));
            }
        }
        if (var3_3 != false) {
            return null;
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<String> getPropertyNames() {
        try {
            return System.getenv().keySet();
        }
        catch (SecurityException e) {
            void var1_1;
            this.logException((SecurityException)var1_1);
            return PropertySource.super.getPropertyNames();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getProperty(String key) {
        try {
            return System.getenv(key);
        }
        catch (SecurityException e) {
            void var1_1;
            void var2_2;
            this.logException((SecurityException)var2_2);
            return PropertySource.super.getProperty((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsProperty(String key) {
        try {
            return System.getenv().containsKey(key);
        }
        catch (SecurityException e) {
            void var1_1;
            void var2_2;
            this.logException((SecurityException)var2_2);
            return PropertySource.super.containsProperty((String)var1_1);
        }
    }
}

