/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.net.URL;
import java.security.Permission;
import java.util.Iterator;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ProviderUtil;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private boolean lockingProviderUtil;

    private static void checkPermission(Permission permission) {
        if (SECURITY_MANAGER != null) {
            Permission permission2;
            SECURITY_MANAGER.checkPermission(permission2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadProvider(Bundle bundle) {
        if (bundle.getState() == 1) {
            return;
        }
        try {
            Activator.checkPermission((Permission)new AdminPermission(bundle, "resource"));
            Activator.checkPermission((Permission)new AdaptPermission(BundleWiring.class.getName(), bundle, "adapt"));
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext != null) {
                this.loadProvider(bundleContext, (BundleWiring)bundle.adapt(BundleWiring.class));
                return;
            }
            LOGGER.debug("Bundle {} has no context (state={}), skipping loading provider", (Object)bundle.getSymbolicName(), (Object)this.toStateString(bundle.getState()));
        }
        catch (SecurityException e) {
            LOGGER.debug("Cannot access bundle [{}] contents. Ignoring.", (Object)bundle.getSymbolicName(), (Object)e);
            return;
        }
        catch (Exception e) {
            void var2_4;
            void var1_1;
            LOGGER.warn("Problem checking bundle {} for Log4j 2 provider.", (Object)var1_1.getSymbolicName(), (Object)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String toStateString(int state) {
        void var1_1;
        switch (state) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return Integer.toString((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void loadProvider(BundleContext bundleContext, BundleWiring bundleWiring) {
        try {
            Object serviceReferences = bundleContext.getServiceReferences(Provider.class, "(APIVersion>=2.6.0)");
            Provider maxProvider = null;
            serviceReferences = serviceReferences.iterator();
            while (serviceReferences.hasNext()) {
                ServiceReference serviceReference = (ServiceReference)serviceReferences.next();
                Provider provider = (Provider)bundleContext.getService(serviceReference);
                if (maxProvider != null && provider.getPriority() <= maxProvider.getPriority()) continue;
                maxProvider = provider;
            }
            if (maxProvider != null) {
                ProviderUtil.addProvider(maxProvider);
            }
        }
        catch (InvalidSyntaxException ex) {
            void var3_4;
            LOGGER.error("Invalid service filter: (APIVersion>=2.6.0)", (Throwable)var3_4);
        }
        Object object = bundleWiring.findEntries("META-INF", "log4j-provider.properties", 0);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (URL)iterator.next();
            ProviderUtil.loadProvider((URL)object, bundleWiring.getClassLoader());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void start(BundleContext bundleContext) throws Exception {
        void var1_1;
        Bundle[] bundleArray;
        ProviderUtil.STARTUP_LOCK.lock();
        this.lockingProviderUtil = true;
        Object object = (BundleWiring)bundleContext.getBundle().adapt(BundleWiring.class);
        object = object.getRequiredWires(LoggerContextFactory.class.getName());
        object = object.iterator();
        while (object.hasNext()) {
            BundleWire wire = (BundleWire)object.next();
            this.loadProvider(bundleContext, bundleArray.getProviderWiring());
        }
        bundleContext.addBundleListener((BundleListener)this);
        object = var1_1.getBundles();
        bundleArray = object;
        int n = ((Bundle[])object).length;
        for (int i = 0; i < n; ++i) {
            Bundle bundle = bundleArray[i];
            this.loadProvider(bundle);
        }
        this.unlockIfReady();
    }

    private void unlockIfReady() {
        if (this.lockingProviderUtil && !ProviderUtil.PROVIDERS.isEmpty()) {
            ProviderUtil.STARTUP_LOCK.unlock();
            this.lockingProviderUtil = false;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        bundleContext.removeBundleListener((BundleListener)this);
        this.unlockIfReady();
    }

    /*
     * WARNING - void declaration
     */
    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                void var1_1;
                this.loadProvider(var1_1.getBundle());
                this.unlockIfReady();
            }
        }
    }
}

