/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.status;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedNoReferenceMessageFactory;
import org.apache.logging.log4j.simple.SimpleLogger;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.status.SimpleLoggerFactory;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class StatusLogger
extends AbstractLogger {
    public static final String MAX_STATUS_ENTRIES = "log4j2.status.entries";
    public static final String DEFAULT_STATUS_LISTENER_LEVEL = "log4j2.StatusLogger.level";
    public static final String STATUS_DATE_FORMAT = "log4j2.StatusLogger.DateFormat";
    private static final long serialVersionUID = 2L;
    private static final String NOT_AVAIL = "?";
    static final PropertiesUtil PROPS = new PropertiesUtil("log4j2.StatusLogger.properties");
    private static final int MAX_ENTRIES = PROPS.getIntegerProperty("log4j2.status.entries", 200);
    private static final String DEFAULT_STATUS_LEVEL = PROPS.getStringProperty("log4j2.StatusLogger.level");
    static final boolean DEBUG_ENABLED = PropertiesUtil.getProperties().getBooleanProperty("log4j2.debug", false, true);
    private static final StatusLogger STATUS_LOGGER = new StatusLogger(StatusLogger.class.getName(), ParameterizedNoReferenceMessageFactory.INSTANCE, SimpleLoggerFactory.getInstance());
    private final SimpleLogger logger;
    private final Collection<StatusListener> listeners = new CopyOnWriteArrayList<StatusListener>();
    private final ReadWriteLock listenersLock = new ReentrantReadWriteLock();
    private final Queue<StatusData> messages = new BoundedQueue<StatusData>(MAX_ENTRIES);
    private final Lock msgLock = new ReentrantLock();
    private int listenersLevel;

    /*
     * WARNING - void declaration
     */
    private StatusLogger(String name, MessageFactory messageFactory, SimpleLoggerFactory loggerFactory) {
        super(name, messageFactory);
        void var2_2;
        void var1_1;
        void var3_3;
        Level loggerLevel = DEBUG_ENABLED ? Level.TRACE : Level.ERROR;
        this.logger = var3_3.createSimpleLogger("StatusLogger", (Level)var1_1, (MessageFactory)var2_2, System.err);
        this.listenersLevel = Level.toLevel(DEFAULT_STATUS_LEVEL, Level.WARN).intLevel();
    }

    public static StatusLogger getLogger() {
        return STATUS_LOGGER;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLevel(Level level) {
        void var1_1;
        this.logger.setLevel((Level)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void registerListener(StatusListener listener) {
        this.listenersLock.writeLock().lock();
        try {
            this.listeners.add(listener);
            Level lvl = listener.getStatusLevel();
            if (this.listenersLevel < lvl.intLevel()) {
                void var1_1;
                this.listenersLevel = var1_1.intLevel();
            }
            return;
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeListener(StatusListener listener) {
        StatusLogger.closeSilently(listener);
        this.listenersLock.writeLock().lock();
        try {
            void var1_2;
            this.listeners.remove(listener);
            int lowest = Level.toLevel(DEFAULT_STATUS_LEVEL, Level.WARN).intLevel();
            for (StatusListener statusListener : this.listeners) {
                void var3_5;
                int level = statusListener.getStatusLevel().intLevel();
                if (lowest >= level) continue;
                lowest = var3_5;
            }
            this.listenersLevel = var1_2;
            return;
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateListenerLevel(Level status) {
        if (status.intLevel() > this.listenersLevel) {
            void var1_1;
            this.listenersLevel = var1_1.intLevel();
        }
    }

    public final Iterable<StatusListener> getListeners() {
        return this.listeners;
    }

    public final void reset() {
        this.listenersLock.writeLock().lock();
        try {
            for (StatusListener statusListener : this.listeners) {
                StatusLogger.closeSilently(statusListener);
            }
            return;
        }
        finally {
            this.listeners.clear();
            this.listenersLock.writeLock().unlock();
            this.clear();
        }
    }

    private static void closeSilently(Closeable resource) {
        try {
            resource.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final List<StatusData> getStatusData() {
        this.msgLock.lock();
        try {
            ArrayList<StatusData> arrayList = new ArrayList<StatusData>(this.messages);
            return arrayList;
        }
        finally {
            this.msgLock.unlock();
        }
    }

    public final void clear() {
        this.msgLock.lock();
        try {
            this.messages.clear();
            return;
        }
        finally {
            this.msgLock.unlock();
        }
    }

    @Override
    public final Level getLevel() {
        return this.logger.getLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void logMessage(String fqcn, Level level, Marker marker, Message msg, Throwable t) {
        StackTraceElement element = null;
        if (fqcn != null) {
            element = this.getStackTraceElement(fqcn, Thread.currentThread().getStackTrace());
        }
        StatusData data = new StatusData(element, level, msg, t, null);
        this.msgLock.lock();
        try {
            this.messages.add(data);
        }
        finally {
            this.msgLock.unlock();
        }
        if (DEBUG_ENABLED || this.listeners.size() <= 0) {
            void var3_4;
            Iterator<StatusListener> iterator;
            this.logger.logMessage((String)((Object)iterator), level, (Marker)var3_4, msg, t);
            return;
        }
        for (StatusListener listener : this.listeners) {
            void var2_3;
            if (!data.getLevel().isMoreSpecificThan(listener.getStatusLevel())) continue;
            var2_3.log(data);
        }
    }

    /*
     * WARNING - void declaration
     */
    private StackTraceElement getStackTraceElement(String fqcn, StackTraceElement[] stackTrace) {
        void var2_2;
        if (fqcn == null) {
            return null;
        }
        boolean next = false;
        for (void element : var2_2) {
            String className = element.getClassName();
            if (next && !fqcn.equals(className)) {
                return element;
            }
            if (fqcn.equals(className)) {
                next = true;
                continue;
            }
            if (NOT_AVAIL.equals(className)) break;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Object p0) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
        void var2_2;
        void var1_1;
        return ((AbstractLogger)this).isEnabled((Level)var1_1, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEnabled(Level level, Marker marker) {
        void var2_2;
        void var1_1;
        if (DEBUG_ENABLED) {
            return true;
        }
        if (this.listeners.size() > 0) {
            return this.listenersLevel >= level.intLevel();
        }
        return this.logger.isEnabled((Level)var1_1, (Marker)var2_2);
    }

    private class BoundedQueue<E>
    extends ConcurrentLinkedQueue<E> {
        private static final long serialVersionUID = -3945953719763255337L;
        private final int size;

        /*
         * WARNING - void declaration
         */
        BoundedQueue(int size) {
            void var2_2;
            this.size = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean add(E object) {
            void var1_1;
            super.add(var1_1);
            while (StatusLogger.this.messages.size() > this.size) {
                StatusLogger.this.messages.poll();
            }
            return this.size > 0;
        }
    }
}

