/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.status;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedNoReferenceMessageFactory;
import org.apache.logging.log4j.status.SimpleLoggerFactory;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;

public class StatusConsoleListener
implements StatusListener {
    private Level level;
    private String[] filters;
    private final PrintStream stream;
    private final Logger logger;

    /*
     * WARNING - void declaration
     */
    public StatusConsoleListener(Level level) {
        this((Level)var1_1, System.out);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StatusConsoleListener(Level level, PrintStream stream) {
        this((Level)var1_1, (PrintStream)var2_2, SimpleLoggerFactory.getInstance());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    StatusConsoleListener(Level level, PrintStream stream, SimpleLoggerFactory loggerFactory) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.level = Objects.requireNonNull(level, "level");
        this.stream = Objects.requireNonNull(stream, "stream");
        this.logger = ((SimpleLoggerFactory)Objects.requireNonNull(var3_3, "loggerFactory")).createSimpleLogger("StatusConsoleListener", (Level)var1_1, ParameterizedNoReferenceMessageFactory.INSTANCE, (PrintStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setLevel(Level level) {
        void var1_1;
        this.level = var1_1;
    }

    @Override
    public Level getStatusLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(StatusData data) {
        boolean bl = this.filtered(data);
        if (!bl) {
            void var1_1;
            this.logger.atLevel(data.getLevel()).withThrowable(data.getThrowable()).withLocation(data.getStackTraceElement()).log(var1_1.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFilters(String ... filters) {
        void var1_1;
        this.filters = var1_1;
    }

    private boolean filtered(StatusData data) {
        if (this.filters == null) {
            return false;
        }
        String caller = data.getStackTraceElement().getClassName();
        String[] stringArray = this.filters;
        int n = this.filters.length;
        for (int i = 0; i < n; ++i) {
            String filter = stringArray[i];
            if (!caller.startsWith(filter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != System.out && this.stream != System.err) {
            this.stream.close();
        }
    }
}

