/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.status.StatusLogger;

public class Provider {
    public static final String FACTORY_PRIORITY = "FactoryPriority";
    public static final String THREAD_CONTEXT_MAP = "ThreadContextMap";
    public static final String LOGGER_CONTEXT_FACTORY = "LoggerContextFactory";
    private static final Integer DEFAULT_PRIORITY = -1;
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Integer priority;
    private final String className;
    private final Class<? extends LoggerContextFactory> loggerContextFactoryClass;
    private final String threadContextMap;
    private final Class<? extends ThreadContextMap> threadContextMapClass;
    private final String versions;
    private final URL url;
    private final WeakReference<ClassLoader> classLoader;

    /*
     * WARNING - void declaration
     */
    public Provider(Properties props, URL url, ClassLoader classLoader) {
        void var1_1;
        void var2_2;
        void var3_3;
        this.url = url;
        this.classLoader = new WeakReference<void>(var3_3);
        String weight = props.getProperty(FACTORY_PRIORITY);
        this.priority = weight == null ? DEFAULT_PRIORITY : Integer.valueOf((String)var2_2);
        this.className = props.getProperty(LOGGER_CONTEXT_FACTORY);
        this.threadContextMap = var1_1.getProperty(THREAD_CONTEXT_MAP);
        this.loggerContextFactoryClass = null;
        this.threadContextMapClass = null;
        this.versions = null;
    }

    /*
     * WARNING - void declaration
     */
    public Provider(Integer priority, String versions, Class<? extends LoggerContextFactory> loggerContextFactoryClass) {
        this((Integer)var1_1, (String)var2_2, (Class<? extends LoggerContextFactory>)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Provider(Integer priority, String versions, Class<? extends LoggerContextFactory> loggerContextFactoryClass, Class<? extends ThreadContextMap> threadContextMapClass) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.url = null;
        this.classLoader = null;
        this.priority = var1_1;
        this.loggerContextFactoryClass = var3_3;
        this.threadContextMapClass = threadContextMapClass;
        this.className = null;
        this.threadContextMap = null;
        this.versions = var2_2;
    }

    public String getVersions() {
        return this.versions;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getClassName() {
        if (this.loggerContextFactoryClass != null) {
            return this.loggerContextFactoryClass.getName();
        }
        return this.className;
    }

    /*
     * WARNING - void declaration
     */
    public Class<? extends LoggerContextFactory> loadLoggerContextFactory() {
        if (this.loggerContextFactoryClass != null) {
            return this.loggerContextFactoryClass;
        }
        if (this.className == null) {
            return null;
        }
        ClassLoader loader = (ClassLoader)this.classLoader.get();
        if (loader == null) {
            return null;
        }
        try {
            Class<?> clazz = loader.loadClass(this.className);
            if (LoggerContextFactory.class.isAssignableFrom(clazz)) {
                return clazz.asSubclass(LoggerContextFactory.class);
            }
        }
        catch (Exception e) {
            void var1_2;
            LOGGER.error("Unable to create class {} specified in {}", (Object)this.className, (Object)this.url.toString(), (Object)var1_2);
        }
        return null;
    }

    public String getThreadContextMap() {
        if (this.threadContextMapClass != null) {
            return this.threadContextMapClass.getName();
        }
        return this.threadContextMap;
    }

    /*
     * WARNING - void declaration
     */
    public Class<? extends ThreadContextMap> loadThreadContextMap() {
        if (this.threadContextMapClass != null) {
            return this.threadContextMapClass;
        }
        if (this.threadContextMap == null) {
            return null;
        }
        ClassLoader loader = (ClassLoader)this.classLoader.get();
        if (loader == null) {
            return null;
        }
        try {
            Class<?> clazz = loader.loadClass(this.threadContextMap);
            if (ThreadContextMap.class.isAssignableFrom(clazz)) {
                return clazz.asSubclass(ThreadContextMap.class);
            }
        }
        catch (Exception e) {
            void var1_2;
            LOGGER.error("Unable to create class {} specified in {}", (Object)this.threadContextMap, (Object)this.url.toString(), (Object)var1_2);
        }
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        ClassLoader loader;
        StringBuilder result = new StringBuilder("Provider[");
        if (!DEFAULT_PRIORITY.equals(this.priority)) {
            result.append("priority=").append(this.priority).append(", ");
        }
        if (this.threadContextMap != null) {
            result.append("threadContextMap=").append(this.threadContextMap).append(", ");
        } else if (this.threadContextMapClass != null) {
            result.append("threadContextMapClass=").append(this.threadContextMapClass.getName());
        }
        if (this.className != null) {
            result.append("className=").append(this.className).append(", ");
        } else if (this.loggerContextFactoryClass != null) {
            result.append("class=").append(this.loggerContextFactoryClass.getName());
        }
        if (this.url != null) {
            result.append("url=").append(this.url);
        }
        if (this.classLoader == null || (loader = (ClassLoader)this.classLoader.get()) == null) {
            result.append(", classLoader=null(not reachable)");
        } else {
            void var2_2;
            result.append(", classLoader=").append(var2_2);
        }
        result.append("]");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Provider provider = (Provider)o;
        if (this.priority != null ? !this.priority.equals(provider.priority) : provider.priority != null) {
            return false;
        }
        if (this.className != null ? !this.className.equals(provider.className) : provider.className != null) {
            return false;
        }
        if (this.loggerContextFactoryClass != null ? !this.loggerContextFactoryClass.equals(provider.loggerContextFactoryClass) : provider.loggerContextFactoryClass != null) {
            return false;
        }
        if (this.versions != null) {
            return this.versions.equals(provider.versions);
        }
        return var1_1.versions == null;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.priority != null ? this.priority.hashCode() : 0;
        result = result * 31 + (this.className != null ? this.className.hashCode() : 0);
        result = result * 31 + (this.loggerContextFactoryClass != null ? this.loggerContextFactoryClass.hashCode() : 0);
        var1_1 = var1_1 * 31 + (this.versions != null ? this.versions.hashCode() : 0);
        return (int)var1_1;
    }
}

