/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public class MutableThreadContextStack
implements ThreadContextStack,
StringBuilderFormattable {
    private static final long serialVersionUID = 50505011L;
    private final List<String> list;
    private boolean frozen;

    public MutableThreadContextStack() {
        this(new ArrayList<String>());
    }

    /*
     * WARNING - void declaration
     */
    public MutableThreadContextStack(List<String> list) {
        void var1_1;
        this.list = new ArrayList<String>((Collection<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private MutableThreadContextStack(MutableThreadContextStack stack) {
        void var1_1;
        this.list = new ArrayList<String>(var1_1.list);
    }

    private void checkInvariants() {
        if (this.frozen) {
            throw new UnsupportedOperationException("context stack has been frozen");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String pop() {
        void var1_1;
        this.checkInvariants();
        if (this.list.isEmpty()) {
            return null;
        }
        int last = this.list.size() - 1;
        String string = this.list.remove((int)var1_1);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String peek() {
        void var1_1;
        if (this.list.isEmpty()) {
            return null;
        }
        int last = this.list.size() - 1;
        return this.list.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void push(String message) {
        void var1_1;
        this.checkInvariants();
        this.list.add((String)var1_1);
    }

    @Override
    public int getDepth() {
        return this.list.size();
    }

    @Override
    public List<String> asList() {
        return this.list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trim(int depth) {
        void var2_2;
        this.checkInvariants();
        if (depth < 0) {
            throw new IllegalArgumentException("Maximum stack depth cannot be negative");
        }
        if (this.list == null) {
            return;
        }
        ArrayList<String> copy = new ArrayList<String>(this.list.size());
        int count = Math.min(depth, this.list.size());
        for (int i = 0; i < count; ++i) {
            copy.add(this.list.get(i));
        }
        this.list.clear();
        this.list.addAll((Collection<String>)var2_2);
    }

    @Override
    public ThreadContextStack copy() {
        return new MutableThreadContextStack(this);
    }

    @Override
    public void clear() {
        this.checkInvariants();
        this.list.clear();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object o) {
        void var1_1;
        return this.list.contains(var1_1);
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T[] toArray(T[] ts) {
        void var1_1;
        return this.list.toArray((T[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(String s) {
        void var1_1;
        this.checkInvariants();
        return this.list.add((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object o) {
        void var1_1;
        this.checkInvariants();
        return this.list.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(Collection<?> objects) {
        void var1_1;
        return this.list.containsAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends String> strings) {
        void var1_1;
        this.checkInvariants();
        return this.list.addAll((Collection<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(Collection<?> objects) {
        void var1_1;
        this.checkInvariants();
        return this.list.removeAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(Collection<?> objects) {
        void var1_1;
        this.checkInvariants();
        return this.list.retainAll((Collection<?>)var1_1);
    }

    public String toString() {
        return String.valueOf(this.list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void formatTo(StringBuilder buffer) {
        void var1_1;
        buffer.append('[');
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0) {
                buffer.append(',').append(' ');
            }
            buffer.append(this.list.get(i));
        }
        var1_1.append(']');
    }

    @Override
    public int hashCode() {
        return 31 + Objects.hashCode(this.list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreadContextStack)) {
            return false;
        }
        obj = (ThreadContextStack)obj;
        List<String> otherAsList = obj.asList();
        return Objects.equals(this.list, var1_1);
    }

    @Override
    public ThreadContext.ContextStack getImmutableStackOrNull() {
        return this.copy();
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }
}

