/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class LoggerRegistry<T extends ExtendedLogger> {
    private static final String DEFAULT_FACTORY_KEY = AbstractLogger.DEFAULT_MESSAGE_FACTORY_CLASS.getName();
    private final MapFactory<T> factory;
    private final Map<String, Map<String, T>> map;

    public LoggerRegistry() {
        this(new ConcurrentMapFactory());
    }

    /*
     * WARNING - void declaration
     */
    public LoggerRegistry(MapFactory<T> factory) {
        void var1_1;
        this.factory = Objects.requireNonNull(factory, "factory");
        this.map = var1_1.createOuterMap();
    }

    private static String factoryClassKey(Class<? extends MessageFactory> messageFactoryClass) {
        Class<? extends MessageFactory> clazz;
        if (messageFactoryClass == null) {
            return DEFAULT_FACTORY_KEY;
        }
        return clazz.getName();
    }

    private static String factoryKey(MessageFactory messageFactory) {
        MessageFactory messageFactory2;
        if (messageFactory == null) {
            return DEFAULT_FACTORY_KEY;
        }
        return messageFactory2.getClass().getName();
    }

    /*
     * WARNING - void declaration
     */
    public T getLogger(String name) {
        void var1_1;
        return (T)((ExtendedLogger)this.getOrCreateInnerMap(DEFAULT_FACTORY_KEY).get(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public T getLogger(String name, MessageFactory messageFactory) {
        void var1_1;
        void var2_2;
        return (T)((ExtendedLogger)this.getOrCreateInnerMap(LoggerRegistry.factoryKey((MessageFactory)var2_2)).get(var1_1));
    }

    public Collection<T> getLoggers() {
        return this.getLoggers(new ArrayList());
    }

    /*
     * WARNING - void declaration
     */
    public Collection<T> getLoggers(Collection<T> destination) {
        void var1_1;
        for (Map<String, T> inner : this.map.values()) {
            void var3_3;
            destination.addAll(var3_3.values());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, T> getOrCreateInnerMap(String factoryName) {
        void var2_2;
        Map<String, T> inner = this.map.get(factoryName);
        if (inner == null) {
            void var1_1;
            inner = this.factory.createInnerMap();
            this.map.put((String)var1_1, inner);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasLogger(String name) {
        void var1_1;
        return this.getOrCreateInnerMap(DEFAULT_FACTORY_KEY).containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasLogger(String name, MessageFactory messageFactory) {
        void var1_1;
        void var2_2;
        return this.getOrCreateInnerMap(LoggerRegistry.factoryKey((MessageFactory)var2_2)).containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        void var1_1;
        void var2_2;
        return this.getOrCreateInnerMap(LoggerRegistry.factoryClassKey((Class<? extends MessageFactory>)var2_2)).containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void putIfAbsent(String name, MessageFactory messageFactory, T logger) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.factory.putIfAbsent(this.getOrCreateInnerMap(LoggerRegistry.factoryKey((MessageFactory)var2_2)), (String)var1_1, var3_3);
    }

    public static class WeakMapFactory<T extends ExtendedLogger>
    implements MapFactory<T> {
        @Override
        public Map<String, T> createInnerMap() {
            return new WeakHashMap();
        }

        @Override
        public Map<String, Map<String, T>> createOuterMap() {
            return new WeakHashMap<String, Map<String, T>>();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void putIfAbsent(Map<String, T> innerMap, String name, T logger) {
            void var3_3;
            void var2_2;
            innerMap.put((String)var2_2, var3_3);
        }
    }

    public static class ConcurrentMapFactory<T extends ExtendedLogger>
    implements MapFactory<T> {
        @Override
        public Map<String, T> createInnerMap() {
            return new ConcurrentHashMap();
        }

        @Override
        public Map<String, Map<String, T>> createOuterMap() {
            return new ConcurrentHashMap<String, Map<String, T>>();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void putIfAbsent(Map<String, T> innerMap, String name, T logger) {
            void var3_3;
            void var2_2;
            ((ConcurrentMap)innerMap).putIfAbsent(var2_2, var3_3);
        }
    }

    public static interface MapFactory<T extends ExtendedLogger> {
        public Map<String, T> createInnerMap();

        public Map<String, Map<String, T>> createOuterMap();

        public void putIfAbsent(Map<String, T> var1, String var2, T var3);
    }
}

