/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.Strings;

public class DefaultThreadContextStack
implements ThreadContextStack,
StringBuilderFormattable {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final long serialVersionUID = 5050501L;
    private static final ThreadLocal<MutableThreadContextStack> STACK = new ThreadLocal();
    private final boolean useStack;

    /*
     * WARNING - void declaration
     */
    public DefaultThreadContextStack(boolean useStack) {
        void var1_1;
        this.useStack = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private MutableThreadContextStack getNonNullStackCopy() {
        void var1_1;
        MutableThreadContextStack values = STACK.get();
        return values == null ? new MutableThreadContextStack() : var1_1.copy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(String s) {
        void var2_2;
        void var1_1;
        if (!this.useStack) {
            return false;
        }
        MutableThreadContextStack copy = this.getNonNullStackCopy();
        copy.add((String)var1_1);
        copy.freeze();
        STACK.set((MutableThreadContextStack)var2_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends String> strings) {
        void var2_2;
        void var1_1;
        if (!this.useStack || strings.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy = this.getNonNullStackCopy();
        copy.addAll((Collection<? extends String>)var1_1);
        copy.freeze();
        STACK.set((MutableThreadContextStack)var2_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> asList() {
        void var1_1;
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            return Collections.emptyList();
        }
        return var1_1.asList();
    }

    @Override
    public void clear() {
        STACK.remove();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object o) {
        void var1_1;
        void var2_2;
        MutableThreadContextStack values = STACK.get();
        return values != null && var2_2.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(Collection<?> objects) {
        void var1_1;
        void var2_2;
        if (objects.isEmpty()) {
            return true;
        }
        MutableThreadContextStack values = STACK.get();
        return values != null && var2_2.containsAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ThreadContextStack copy() {
        void var1_1;
        MutableThreadContextStack values;
        if (!this.useStack || (values = STACK.get()) == null) {
            return new MutableThreadContextStack();
        }
        return var1_1.copy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void var2_2;
        void var1_1;
        ThreadContextStack other;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DefaultThreadContextStack) {
            other = (DefaultThreadContextStack)obj;
            if (this.useStack != other.useStack) {
                return false;
            }
        }
        if (!(obj instanceof ThreadContextStack)) {
            return false;
        }
        other = (ThreadContextStack)obj;
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            return false;
        }
        return var1_1.equals(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getDepth() {
        void var1_1;
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            return 0;
        }
        return var1_1.getDepth();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        MutableThreadContextStack values = STACK.get();
        int n = 31 + (values == null ? 0 : var1_1.hashCode());
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEmpty() {
        void var1_1;
        MutableThreadContextStack values = STACK.get();
        return values == null || var1_1.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<String> iterator() {
        void var1_1;
        Collection<String> values = STACK.get();
        if (values == null) {
            values = Collections.emptyList();
            return values.iterator();
        }
        return var1_1.iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String peek() {
        void var1_1;
        MutableThreadContextStack values = STACK.get();
        if (values == null || values.isEmpty()) {
            return "";
        }
        return var1_1.peek();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String pop() {
        void var2_2;
        void var1_1;
        if (!this.useStack) {
            return "";
        }
        MutableThreadContextStack values = STACK.get();
        if (values == null || values.isEmpty()) {
            return "";
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        String result = copy.pop();
        copy.freeze();
        STACK.set((MutableThreadContextStack)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void push(String message) {
        void var1_1;
        if (!this.useStack) {
            return;
        }
        this.add((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object o) {
        void var1_2;
        void var2_3;
        if (!this.useStack) {
            return false;
        }
        MutableThreadContextStack values = STACK.get();
        if (values == null || values.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        boolean result = copy.remove(o);
        copy.freeze();
        STACK.set((MutableThreadContextStack)var2_3);
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(Collection<?> objects) {
        void var1_2;
        void var2_3;
        if (!this.useStack || objects.isEmpty()) {
            return false;
        }
        MutableThreadContextStack values = STACK.get();
        if (values == null || values.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        boolean result = copy.removeAll(objects);
        copy.freeze();
        STACK.set((MutableThreadContextStack)var2_3);
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(Collection<?> objects) {
        void var1_2;
        void var2_3;
        if (!this.useStack || objects.isEmpty()) {
            return false;
        }
        MutableThreadContextStack values = STACK.get();
        if (values == null || values.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        boolean result = copy.retainAll(objects);
        copy.freeze();
        STACK.set((MutableThreadContextStack)var2_3);
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int size() {
        void var1_1;
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            return 0;
        }
        return var1_1.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object[] toArray() {
        void var1_1;
        MutableThreadContextStack result = STACK.get();
        if (result == null) {
            return Strings.EMPTY_ARRAY;
        }
        return var1_1.toArray(EMPTY_OBJECT_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T[] toArray(T[] ts) {
        void var1_1;
        void var2_2;
        MutableThreadContextStack result = STACK.get();
        if (result == null) {
            if (ts.length > 0) {
                ts[0] = null;
            }
            return ts;
        }
        return var2_2.toArray((T[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            return "[]";
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void formatTo(StringBuilder buffer) {
        void var2_2;
        void var1_1;
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            buffer.append("[]");
            return;
        }
        StringBuilders.appendValue((StringBuilder)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trim(int depth) {
        void var2_2;
        void var1_1;
        if (depth < 0) {
            throw new IllegalArgumentException("Maximum stack depth cannot be negative");
        }
        MutableThreadContextStack values = STACK.get();
        if (values == null) {
            return;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        copy.trim((int)var1_1);
        copy.freeze();
        STACK.set((MutableThreadContextStack)var2_2);
    }

    @Override
    public ThreadContext.ContextStack getImmutableStackOrNull() {
        return STACK.get();
    }
}

