/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.TriConsumer;

public class DefaultThreadContextMap
implements ThreadContextMap,
ReadOnlyStringMap {
    private static final long serialVersionUID = 8218007901108944053L;
    public static final String INHERITABLE_MAP = "isThreadContextMapInheritable";
    private final boolean useMap;
    private final ThreadLocal<Map<String, String>> localMap;
    private static boolean inheritableMap;

    static ThreadLocal<Map<String, String>> createThreadLocalMap(boolean isMapEnabled) {
        if (inheritableMap) {
            boolean bl;
            return new InheritableThreadLocal<Map<String, String>>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected final Map<String, String> childValue(Map<String, String> parentValue) {
                    if (parentValue != null && bl) {
                        void var1_1;
                        return Collections.unmodifiableMap(new HashMap(var1_1));
                    }
                    return null;
                }
            };
        }
        return new ThreadLocal<Map<String, String>>();
    }

    static void init() {
        inheritableMap = PropertiesUtil.getProperties().getBooleanProperty(INHERITABLE_MAP);
    }

    public DefaultThreadContextMap() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultThreadContextMap(boolean useMap) {
        void var1_1;
        this.useMap = useMap;
        this.localMap = DefaultThreadContextMap.createThreadLocalMap((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(String key, String value) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.useMap) {
            return;
        }
        Map<String, String> map = this.localMap.get();
        map = map == null ? new HashMap<String, String>(1) : new HashMap<String, String>(map);
        map.put((String)var1_1, (String)var2_2);
        this.localMap.set(Collections.unmodifiableMap(var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void putAll(Map<String, String> m) {
        void var2_2;
        Iterator iterator;
        if (!this.useMap) {
            return;
        }
        Map<String, String> map = this.localMap.get();
        map = map == null ? new HashMap<String, String>(m.size()) : new HashMap<String, String>(map);
        for (Map.Entry e : iterator.entrySet()) {
            void var3_3;
            map.put((String)e.getKey(), (String)var3_3.getValue());
        }
        this.localMap.set(Collections.unmodifiableMap(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String get(String key) {
        void var1_1;
        void var2_2;
        Map<String, String> map = this.localMap.get();
        if (map == null) {
            return null;
        }
        return (String)var2_2.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(String key) {
        Map<String, String> map = this.localMap.get();
        if (map != null) {
            void var2_2;
            void var1_1;
            HashMap<String, String> copy = new HashMap<String, String>(map);
            copy.remove(var1_1);
            this.localMap.set(Collections.unmodifiableMap(var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeAll(Iterable<String> keys) {
        Map<String, String> map = this.localMap.get();
        if (map != null) {
            void var2_2;
            Iterator iterator;
            HashMap<String, String> copy = new HashMap<String, String>(map);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                String key = (String)iterator.next();
                copy.remove(var3_3);
            }
            this.localMap.set(Collections.unmodifiableMap(var2_2));
        }
    }

    @Override
    public void clear() {
        this.localMap.remove();
    }

    @Override
    public Map<String, String> toMap() {
        return this.getCopy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(String key) {
        void var1_1;
        void var2_2;
        Map<String, String> map = this.localMap.get();
        return map != null && var2_2.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <V> void forEach(BiConsumer<String, ? super V> action) {
        Iterator iterator;
        Map<String, String> map = this.localMap.get();
        if (map == null) {
            return;
        }
        for (Map.Entry entry : iterator.entrySet()) {
            void var3_3;
            Object value = entry.getValue();
            action.accept((String)var3_3.getKey(), value);
        }
    }

    @Override
    public <V, S> void forEach(TriConsumer<String, ? super V, S> action, S state) {
        Iterator iterator;
        Map<String, String> map = this.localMap.get();
        if (map == null) {
            return;
        }
        for (Map.Entry entry : iterator.entrySet()) {
            Object value = entry.getValue();
            action.accept((String)entry.getKey(), value, state);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <V> V getValue(String key) {
        void var1_1;
        void var2_2;
        Map<String, String> map = this.localMap.get();
        if (map == null) {
            return null;
        }
        return (V)((String)var2_2.get(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> getCopy() {
        void var1_1;
        Map<String, String> map = this.localMap.get();
        if (map == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>((Map<String, String>)var1_1);
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        return this.localMap.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEmpty() {
        void var1_1;
        Map<String, String> map = this.localMap.get();
        return map == null || var1_1.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int size() {
        void var1_1;
        Map<String, String> map = this.localMap.get();
        if (map == null) {
            return 0;
        }
        return var1_1.size();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        Map<String, String> map = this.localMap.get();
        if (map == null) {
            return "{}";
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_2;
        Map<String, String> map = this.localMap.get();
        int result = 31 + (map == null ? 0 : map.hashCode());
        var1_2 = var1_2 * 31 + Boolean.valueOf(this.useMap).hashCode();
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var2_2;
        void var1_1;
        ThreadContextMap other;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DefaultThreadContextMap) {
            other = (DefaultThreadContextMap)obj;
            if (this.useMap != ((DefaultThreadContextMap)other).useMap) {
                return false;
            }
        }
        if (!(obj instanceof ThreadContextMap)) {
            return false;
        }
        other = (ThreadContextMap)obj;
        Map<String, String> map = this.localMap.get();
        Map<String, String> otherMap = other.getImmutableMapOrNull();
        return Objects.equals(var1_1, var2_2);
    }

    static {
        DefaultThreadContextMap.init();
    }
}

