/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.spi.CopyOnWrite;
import org.apache.logging.log4j.spi.ObjectThreadContextMap;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;

class CopyOnWriteSortedArrayThreadContextMap
implements CopyOnWrite,
ObjectThreadContextMap,
ReadOnlyThreadContextMap {
    public static final String INHERITABLE_MAP = "isThreadContextMapInheritable";
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final String PROPERTY_NAME_INITIAL_CAPACITY = "log4j2.ThreadContext.initial.capacity";
    private static final StringMap EMPTY_CONTEXT_DATA = new SortedArrayStringMap(1);
    private static volatile int initialCapacity;
    private static volatile boolean inheritableMap;
    private final ThreadLocal<StringMap> localMap = this.createThreadLocalMap();

    /*
     * WARNING - void declaration
     */
    static void init() {
        void var0;
        PropertiesUtil properties = PropertiesUtil.getProperties();
        initialCapacity = properties.getIntegerProperty(PROPERTY_NAME_INITIAL_CAPACITY, 16);
        inheritableMap = var0.getBooleanProperty(INHERITABLE_MAP);
    }

    private ThreadLocal<StringMap> createThreadLocalMap() {
        if (inheritableMap) {
            return new InheritableThreadLocal<StringMap>(this){
                final /* synthetic */ CopyOnWriteSortedArrayThreadContextMap this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected StringMap childValue(StringMap parentValue) {
                    void var1_1;
                    if (parentValue == null) {
                        return null;
                    }
                    StringMap stringMap = this.this$0.createStringMap(parentValue);
                    stringMap.freeze();
                    return var1_1;
                }
            };
        }
        return new ThreadLocal<StringMap>();
    }

    protected StringMap createStringMap() {
        return new SortedArrayStringMap(initialCapacity);
    }

    /*
     * WARNING - void declaration
     */
    protected StringMap createStringMap(ReadOnlyStringMap original) {
        void var1_1;
        return new SortedArrayStringMap((ReadOnlyStringMap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(String key, String value) {
        void var2_2;
        void var1_1;
        this.putValue((String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putValue(String key, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        StringMap map = this.localMap.get();
        map = map == null ? this.createStringMap() : this.createStringMap(map);
        map.putValue((String)var1_1, var2_2);
        map.freeze();
        this.localMap.set((StringMap)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<String, String> values) {
        void var2_2;
        Iterator iterator;
        if (values == null || values.isEmpty()) {
            return;
        }
        StringMap map = this.localMap.get();
        map = map == null ? this.createStringMap() : this.createStringMap(map);
        for (Map.Entry entry : iterator.entrySet()) {
            void var3_3;
            map.putValue((String)entry.getKey(), var3_3.getValue());
        }
        map.freeze();
        this.localMap.set((StringMap)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <V> void putAllValues(Map<String, V> values) {
        void var2_2;
        Iterator iterator;
        if (values == null || values.isEmpty()) {
            return;
        }
        StringMap map = this.localMap.get();
        map = map == null ? this.createStringMap() : this.createStringMap(map);
        for (Map.Entry entry : iterator.entrySet()) {
            void var3_3;
            map.putValue((String)entry.getKey(), var3_3.getValue());
        }
        map.freeze();
        this.localMap.set((StringMap)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String get(String key) {
        void var1_1;
        return (String)this.getValue((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <V> V getValue(String key) {
        void var1_1;
        void var2_2;
        StringMap map = this.localMap.get();
        if (map == null) {
            return null;
        }
        return var2_2.getValue((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(String key) {
        StringMap map = this.localMap.get();
        if (map != null) {
            void var2_2;
            void var1_1;
            StringMap copy = this.createStringMap(map);
            copy.remove((String)var1_1);
            copy.freeze();
            this.localMap.set((StringMap)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeAll(Iterable<String> keys) {
        StringMap map = this.localMap.get();
        if (map != null) {
            void var2_2;
            Iterator iterator;
            StringMap copy = this.createStringMap(map);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                String key = (String)iterator.next();
                copy.remove((String)var3_3);
            }
            copy.freeze();
            this.localMap.set((StringMap)var2_2);
        }
    }

    @Override
    public void clear() {
        this.localMap.remove();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(String key) {
        void var1_1;
        void var2_2;
        StringMap map = this.localMap.get();
        return map != null && var2_2.containsKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> getCopy() {
        void var1_1;
        StringMap map = this.localMap.get();
        if (map == null) {
            return new HashMap<String, String>();
        }
        return var1_1.toMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StringMap getReadOnlyContextData() {
        void var1_1;
        StringMap map = this.localMap.get();
        if (map == null) {
            return EMPTY_CONTEXT_DATA;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> getImmutableMapOrNull() {
        void var1_1;
        StringMap map = this.localMap.get();
        if (map == null) {
            return null;
        }
        return Collections.unmodifiableMap(var1_1.toMap());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEmpty() {
        void var1_1;
        StringMap map = this.localMap.get();
        return map == null || var1_1.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringMap map = this.localMap.get();
        if (map == null) {
            return "{}";
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        StringMap map = this.localMap.get();
        int n = 31 + (map == null ? 0 : var1_1.hashCode());
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        void var2_2;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreadContextMap)) {
            return false;
        }
        ThreadContextMap other = (ThreadContextMap)obj;
        Map<String, String> map = this.getImmutableMapOrNull();
        Map<String, String> otherMap = other.getImmutableMapOrNull();
        return Objects.equals(var2_2, var1_1);
    }

    static {
        EMPTY_CONTEXT_DATA.freeze();
        CopyOnWriteSortedArrayThreadContextMap.init();
    }
}

