/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.internal.DefaultLogBuilder;
import org.apache.logging.log4j.message.DefaultFlowMessageFactory;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.FlowMessageFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.MessageFactory2;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.message.ReusableMessageFactory;
import org.apache.logging.log4j.message.StringFormattedMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LocationAwareLogger;
import org.apache.logging.log4j.spi.MessageFactory2Adapter;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.LambdaUtil;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.MessageSupplier;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.Supplier;

public abstract class AbstractLogger
implements Serializable,
ExtendedLogger,
LocationAwareLogger {
    public static final Marker FLOW_MARKER = MarkerManager.getMarker("FLOW");
    public static final Marker ENTRY_MARKER = MarkerManager.getMarker("ENTER").setParents(FLOW_MARKER);
    public static final Marker EXIT_MARKER = MarkerManager.getMarker("EXIT").setParents(FLOW_MARKER);
    public static final Marker EXCEPTION_MARKER = MarkerManager.getMarker("EXCEPTION");
    public static final Marker THROWING_MARKER = MarkerManager.getMarker("THROWING").setParents(EXCEPTION_MARKER);
    public static final Marker CATCHING_MARKER = MarkerManager.getMarker("CATCHING").setParents(EXCEPTION_MARKER);
    public static final Class<? extends MessageFactory> DEFAULT_MESSAGE_FACTORY_CLASS = AbstractLogger.createClassForProperty("log4j2.messageFactory", ReusableMessageFactory.class, ParameterizedMessageFactory.class);
    public static final Class<? extends FlowMessageFactory> DEFAULT_FLOW_MESSAGE_FACTORY_CLASS = AbstractLogger.createFlowClassForProperty("log4j2.flowMessageFactory", DefaultFlowMessageFactory.class);
    private static final long serialVersionUID = 2L;
    private static final String FQCN = AbstractLogger.class.getName();
    private static final String THROWING = "Throwing";
    private static final String CATCHING = "Catching";
    protected final String name;
    private final MessageFactory2 messageFactory;
    private final FlowMessageFactory flowMessageFactory;
    private static final ThreadLocal<int[]> recursionDepthHolder = new ThreadLocal();
    private static final ThreadLocal<DefaultLogBuilder> logBuilder = ThreadLocal.withInitial(DefaultLogBuilder::new);

    /*
     * WARNING - void declaration
     */
    public AbstractLogger() {
        void var1_1;
        String canonicalName = this.getClass().getCanonicalName();
        this.name = canonicalName != null ? var1_1 : this.getClass().getName();
        this.messageFactory = AbstractLogger.createDefaultMessageFactory();
        this.flowMessageFactory = AbstractLogger.createDefaultFlowMessageFactory();
    }

    /*
     * WARNING - void declaration
     */
    public AbstractLogger(String name) {
        this((String)var1_1, AbstractLogger.createDefaultMessageFactory());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AbstractLogger(String name, MessageFactory messageFactory) {
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.messageFactory = messageFactory == null ? AbstractLogger.createDefaultMessageFactory() : AbstractLogger.narrow((MessageFactory)var2_2);
        this.flowMessageFactory = AbstractLogger.createDefaultFlowMessageFactory();
    }

    /*
     * WARNING - void declaration
     */
    public static void checkMessageFactory(ExtendedLogger logger, MessageFactory messageFactory) {
        void var1_1;
        String name = logger.getName();
        ExtendedLogger loggerMessageFactory = logger.getMessageFactory();
        if (messageFactory != null && !loggerMessageFactory.equals(messageFactory)) {
            StatusLogger.getLogger().warn("The Logger {} was created with the message factory {} and is now requested with the message factory {}, which may create log events with unexpected formatting.", (Object)name, (Object)loggerMessageFactory, (Object)messageFactory);
            return;
        }
        if (var1_1 == null && !loggerMessageFactory.getClass().equals(DEFAULT_MESSAGE_FACTORY_CLASS)) {
            ExtendedLogger extendedLogger;
            void var2_2;
            StatusLogger.getLogger().warn("The Logger {} was created with the message factory {} and is now requested with a null message factory (defaults to {}), which may create log events with unexpected formatting.", (Object)var2_2, (Object)extendedLogger, (Object)DEFAULT_MESSAGE_FACTORY_CLASS.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void catching(Level level, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.catching(FQCN, (Level)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void catching(String fqcn, Level level, Throwable throwable) {
        if (this.isEnabled(level, CATCHING_MARKER, (Object)null, null)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessageSafely((String)var1_1, (Level)var2_2, CATCHING_MARKER, this.catchingMsg(throwable), (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void catching(Throwable throwable) {
        if (this.isEnabled(Level.ERROR, CATCHING_MARKER, (Object)null, null)) {
            void var1_1;
            this.logMessageSafely(FQCN, Level.ERROR, CATCHING_MARKER, this.catchingMsg(throwable), (Throwable)var1_1);
        }
    }

    protected Message catchingMsg(Throwable throwable) {
        return this.messageFactory.newMessage(CATCHING);
    }

    /*
     * WARNING - void declaration
     */
    private static Class<? extends MessageFactory> createClassForProperty(String property, Class<ReusableMessageFactory> reusableParameterizedMessageFactoryClass, Class<ParameterizedMessageFactory> parameterizedMessageFactoryClass) {
        try {
            void var1_1;
            String string;
            String fallback = Constants.ENABLE_THREADLOCALS ? reusableParameterizedMessageFactoryClass.getName() : parameterizedMessageFactoryClass.getName();
            string = PropertiesUtil.getProperties().getStringProperty(string, (String)var1_1);
            return LoaderUtil.loadClass(string).asSubclass(MessageFactory.class);
        }
        catch (Throwable throwable) {
            void var2_2;
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Class<? extends FlowMessageFactory> createFlowClassForProperty(String property, Class<DefaultFlowMessageFactory> defaultFlowMessageFactoryClass) {
        try {
            String string;
            string = PropertiesUtil.getProperties().getStringProperty(string, defaultFlowMessageFactoryClass.getName());
            return LoaderUtil.loadClass(string).asSubclass(FlowMessageFactory.class);
        }
        catch (Throwable throwable) {
            void var1_1;
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static MessageFactory2 createDefaultMessageFactory() {
        try {
            MessageFactory messageFactory = DEFAULT_MESSAGE_FACTORY_CLASS.newInstance();
            return AbstractLogger.narrow(messageFactory);
        }
        catch (IllegalAccessException | InstantiationException e) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    private static MessageFactory2 narrow(MessageFactory result) {
        MessageFactory messageFactory;
        if (result instanceof MessageFactory2) {
            return (MessageFactory2)result;
        }
        return new MessageFactory2Adapter(messageFactory);
    }

    /*
     * WARNING - void declaration
     */
    private static FlowMessageFactory createDefaultFlowMessageFactory() {
        try {
            return DEFAULT_FLOW_MESSAGE_FACTORY_CLASS.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            void var0;
            throw new IllegalStateException((Throwable)var0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, CharSequence message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (CharSequence)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, CharSequence message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (CharSequence)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, Message message) {
        void var2_2;
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, message2, message2 != null ? var2_2.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, Message message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (Message)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, Object message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, Object message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Message message) {
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.DEBUG, null, message2, message2 != null ? var1_1.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Message message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, null, (Message)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(CharSequence message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, null, (CharSequence)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(CharSequence message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, null, (CharSequence)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Object message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, null, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Object message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, null, var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Object ... params) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Supplier<?> messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, null, (Supplier<?>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Supplier<?> messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, null, (Supplier<?>)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, Supplier<?> messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (Supplier<?>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Supplier<?> ... paramSuppliers) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Supplier<?>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, Supplier<?> messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (Supplier<?>)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Supplier<?> ... paramSuppliers) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, null, (String)var1_1, (Supplier<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, MessageSupplier messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (MessageSupplier)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, MessageSupplier messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (MessageSupplier)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(MessageSupplier messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, null, (MessageSupplier)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(MessageSupplier messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, null, (MessageSupplier)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Object p0) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Object p0) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    /*
     * WARNING - void declaration
     */
    protected EntryMessage enter(String fqcn, String format, Supplier<?> ... paramSuppliers) {
        EntryMessage entryMsg = null;
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER, (Object)null, null)) {
            void var1_1;
            void var3_3;
            void var2_2;
            entryMsg = this.flowMessageFactory.newEntryMessage((String)var2_2, LambdaUtil.getAll(var3_3));
            this.logMessageSafely((String)var1_1, Level.TRACE, ENTRY_MARKER, entryMsg, null);
        }
        return entryMsg;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected EntryMessage enter(String fqcn, String format, MessageSupplier ... paramSuppliers) {
        EntryMessage entryMsg = null;
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER, (Object)null, null)) {
            void var1_1;
            void var3_3;
            void var2_2;
            entryMsg = this.entryMsg((String)var2_2, (MessageSupplier[])var3_3);
            this.logMessageSafely((String)var1_1, Level.TRACE, ENTRY_MARKER, entryMsg, null);
        }
        return entryMsg;
    }

    /*
     * WARNING - void declaration
     */
    protected EntryMessage enter(String fqcn, String format, Object ... params) {
        EntryMessage entryMsg = null;
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER, (Object)null, null)) {
            void var1_1;
            void var3_3;
            void var2_2;
            entryMsg = this.flowMessageFactory.newEntryMessage((String)var2_2, (Object[])var3_3);
            this.logMessageSafely((String)var1_1, Level.TRACE, ENTRY_MARKER, entryMsg, null);
        }
        return entryMsg;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected EntryMessage enter(String fqcn, MessageSupplier messageSupplier) {
        void var3_3;
        EntryMessage message = null;
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER, (Object)null, null)) {
            void var1_1;
            void var2_2;
            message = this.flowMessageFactory.newEntryMessage(var2_2.get());
            this.logMessageSafely((String)var1_1, Level.TRACE, ENTRY_MARKER, message, null);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected EntryMessage enter(String fqcn, Message message) {
        void var3_3;
        EntryMessage flowMessage = null;
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER, (Object)null, null)) {
            void var1_1;
            void var2_2;
            flowMessage = this.flowMessageFactory.newEntryMessage((Message)var2_2);
            this.logMessageSafely((String)var1_1, Level.TRACE, ENTRY_MARKER, flowMessage, null);
        }
        return var3_3;
    }

    @Override
    @Deprecated
    public void entry() {
        this.entry(FQCN, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void entry(Object ... params) {
        void var1_1;
        this.entry(FQCN, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void entry(String fqcn, Object ... params) {
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER, (Object)null, null)) {
            void var2_2;
            void var1_1;
            if (params == null) {
                this.logMessageSafely(fqcn, Level.TRACE, ENTRY_MARKER, this.entryMsg((String)null, (Supplier<?>[])null), null);
                return;
            }
            this.logMessageSafely((String)var1_1, Level.TRACE, ENTRY_MARKER, this.entryMsg(null, (Object[])var2_2), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected EntryMessage entryMsg(String format, Object ... params) {
        void var2_2;
        void var1_1;
        return this.flowMessageFactory.newEntryMessage((String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected EntryMessage entryMsg(String format, MessageSupplier ... paramSuppliers) {
        void var1_1;
        int count = paramSuppliers == null ? 0 : paramSuppliers.length;
        Object[] params = new Object[count];
        for (int i = 0; i < count; ++i) {
            params[i] = paramSuppliers[i].get();
        }
        return this.entryMsg((String)var1_1, params);
    }

    /*
     * WARNING - void declaration
     */
    protected EntryMessage entryMsg(String format, Supplier<?> ... paramSuppliers) {
        void var2_2;
        void var1_1;
        return this.entryMsg((String)var1_1, LambdaUtil.getAll(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, Message message) {
        void var2_2;
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, message2, message2 != null ? var2_2.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, Message message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (Message)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, CharSequence message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (CharSequence)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, CharSequence message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (CharSequence)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, Object message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, Object message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Message message) {
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.ERROR, null, message2, message2 != null ? var1_1.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Message message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, null, (Message)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(CharSequence message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, null, (CharSequence)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(CharSequence message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, null, (CharSequence)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Object message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, null, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Object message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, null, var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Object ... params) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Supplier<?> messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, null, (Supplier<?>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Supplier<?> messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, null, (Supplier<?>)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, Supplier<?> messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (Supplier<?>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Supplier<?> ... paramSuppliers) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Supplier<?>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, Supplier<?> messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (Supplier<?>)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Supplier<?> ... paramSuppliers) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, null, (String)var1_1, (Supplier<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, MessageSupplier messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (MessageSupplier)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, MessageSupplier messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (MessageSupplier)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(MessageSupplier messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, null, (MessageSupplier)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(MessageSupplier messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, null, (MessageSupplier)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Object p0) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Object p0) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Override
    @Deprecated
    public void exit() {
        this.exit(FQCN, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public <R> R exit(R result) {
        void var1_1;
        return this.exit(FQCN, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected <R> R exit(String fqcn, R result) {
        void var2_2;
        if (this.isEnabled(Level.TRACE, EXIT_MARKER, (CharSequence)null, (Throwable)null)) {
            void var1_1;
            this.logMessageSafely((String)var1_1, Level.TRACE, EXIT_MARKER, this.flowMessageFactory.newExitMessage(null, result), null);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected <R> R exit(String fqcn, String format, R result) {
        void var3_3;
        if (this.isEnabled(Level.TRACE, EXIT_MARKER, (CharSequence)null, (Throwable)null)) {
            void var2_2;
            void var1_1;
            this.logMessageSafely((String)var1_1, Level.TRACE, EXIT_MARKER, this.flowMessageFactory.newExitMessage((String)var2_2, result), null);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected Message exitMsg(String format, Object result) {
        void var2_2;
        void var1_1;
        return this.flowMessageFactory.newExitMessage((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, Message message) {
        void var2_2;
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, message2, message2 != null ? var2_2.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, Message message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (Message)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, CharSequence message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (CharSequence)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, CharSequence message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (CharSequence)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, Object message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, Object message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Message message) {
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.FATAL, null, message2, message2 != null ? var1_1.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Message message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, null, (Message)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(CharSequence message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, null, (CharSequence)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(CharSequence message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, null, (CharSequence)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Object message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, null, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Object message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, null, var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Object ... params) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Supplier<?> messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, null, (Supplier<?>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Supplier<?> messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, null, (Supplier<?>)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, Supplier<?> messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (Supplier<?>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Supplier<?> ... paramSuppliers) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Supplier<?>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, Supplier<?> messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (Supplier<?>)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Supplier<?> ... paramSuppliers) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, null, (String)var1_1, (Supplier<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, MessageSupplier messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (MessageSupplier)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, MessageSupplier messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (MessageSupplier)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(MessageSupplier messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, null, (MessageSupplier)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(MessageSupplier messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, null, (MessageSupplier)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Object p0) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Object p0) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Override
    public <MF extends MessageFactory> MF getMessageFactory() {
        return (MF)this.messageFactory;
    }

    @Override
    public FlowMessageFactory getFlowMessageFactory() {
        return this.flowMessageFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, Message message) {
        void var2_2;
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, message2, message2 != null ? var2_2.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, Message message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (Message)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, CharSequence message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (CharSequence)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, CharSequence message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (CharSequence)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, Object message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, Object message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Message message) {
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.INFO, null, message2, message2 != null ? var1_1.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Message message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, null, (Message)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(CharSequence message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, null, (CharSequence)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(CharSequence message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, null, (CharSequence)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Object message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, null, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Object message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, null, var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Object ... params) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Supplier<?> messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, null, (Supplier<?>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Supplier<?> messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, null, (Supplier<?>)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, Supplier<?> messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (Supplier<?>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Supplier<?> ... paramSuppliers) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Supplier<?>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, Supplier<?> messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (Supplier<?>)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Supplier<?> ... paramSuppliers) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, null, (String)var1_1, (Supplier<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, MessageSupplier messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (MessageSupplier)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, MessageSupplier messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (MessageSupplier)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(MessageSupplier messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, null, (MessageSupplier)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(MessageSupplier messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, null, (MessageSupplier)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Object p0) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Object p0) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isDebugEnabled(Marker marker) {
        void var1_1;
        return this.isEnabled(Level.DEBUG, (Marker)var1_1, (Object)null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level level) {
        void var1_1;
        return this.isEnabled((Level)var1_1, null, (Object)null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level level, Marker marker) {
        void var2_2;
        void var1_1;
        return this.isEnabled((Level)var1_1, (Marker)var2_2, (Object)null, null);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR, null, (Object)null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isErrorEnabled(Marker marker) {
        void var1_1;
        return this.isEnabled(Level.ERROR, (Marker)var1_1, (Object)null, null);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(Level.FATAL, null, (Object)null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isFatalEnabled(Marker marker) {
        void var1_1;
        return this.isEnabled(Level.FATAL, (Marker)var1_1, (Object)null, null);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO, null, (Object)null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isInfoEnabled(Marker marker) {
        void var1_1;
        return this.isEnabled(Level.INFO, (Marker)var1_1, (Object)null, null);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE, null, (Object)null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isTraceEnabled(Marker marker) {
        void var1_1;
        return this.isEnabled(Level.TRACE, (Marker)var1_1, (Object)null, null);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN, null, (Object)null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWarnEnabled(Marker marker) {
        void var1_1;
        return this.isEnabled(Level.WARN, (Marker)var1_1, (Object)null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, Message message) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, message2, message2 != null ? var3_3.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, Message message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (Message)var3_3, throwable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, CharSequence message) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (CharSequence)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, CharSequence message, Throwable throwable) {
        if (this.isEnabled(level, marker, message, throwable)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage(FQCN, (Level)var1_1, (Marker)var2_2, (CharSequence)var3_3, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, Object message) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, Object message, Throwable throwable) {
        if (this.isEnabled(level, marker, message, throwable)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage(FQCN, (Level)var1_1, (Marker)var2_2, var3_3, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, params);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, throwable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Message message) {
        void var2_2;
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, (Level)var1_1, null, message2, message2 != null ? var2_2.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Message message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, null, (Message)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, CharSequence message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, null, (CharSequence)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, CharSequence message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, null, (CharSequence)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Object message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, null, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Object message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, null, var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Supplier<?> messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, null, (Supplier<?>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Supplier<?> messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, null, (Supplier<?>)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, Supplier<?> messageSupplier) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (Supplier<?>)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Supplier<?> ... paramSuppliers) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, paramSuppliers);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, Supplier<?> messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (Supplier<?>)var3_3, throwable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Supplier<?> ... paramSuppliers) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, null, (String)var2_2, (Supplier<?>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, MessageSupplier messageSupplier) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (MessageSupplier)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, MessageSupplier messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (MessageSupplier)var3_3, throwable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, MessageSupplier messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, null, (MessageSupplier)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, MessageSupplier messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, null, (MessageSupplier)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Object p0) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, p0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Object p0) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Object)var3_3, p1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Object)var3_3, p1, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Object)var3_3, p1, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Object)var3_3, p1, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, (Level)var1_1, (Marker)null, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, Message message, Throwable throwable) {
        if (this.isEnabled(level, marker, message, throwable)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, MessageSupplier messageSupplier, Throwable throwable) {
        if (this.isEnabled(level, marker, messageSupplier, throwable)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, messageSupplier, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, Object message, Throwable throwable) {
        if (this.isEnabled(level, marker, message, throwable)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, CharSequence message, Throwable throwable) {
        if (this.isEnabled(level, marker, message, throwable)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, Supplier<?> messageSupplier, Throwable throwable) {
        if (this.isEnabled(level, marker, messageSupplier, throwable)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, messageSupplier, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message) {
        if (this.isEnabled(level, marker, message)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Supplier<?> ... paramSuppliers) {
        if (this.isEnabled(level, marker, message)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, paramSuppliers);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object ... params) {
        if (this.isEnabled(level, marker, message, params)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, params);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0) {
        if (this.isEnabled(level, marker, message, p0)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1) {
        if (this.isEnabled(level, marker, message, p0, p1)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, p0, p1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        if (this.isEnabled(level, marker, message, p0, p1, p2)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, p0, p1, p2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, p0, p1, p2, p3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, p0, p1, p2, p3, p4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, p0, p1, p2, p3, p4, p5);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, p0, p1, p2, p3, p4, p5, p6);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, p0, p1, p2, p3, p4, p5, p6, p7);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Throwable throwable) {
        if (this.isEnabled(level, marker, message, throwable)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logMessage((String)var1_1, (Level)var2_2, (Marker)var3_3, message, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, CharSequence message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, this.messageFactory.newMessage(message), throwable);
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, Object message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, this.messageFactory.newMessage(message), throwable);
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, MessageSupplier messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message message = LambdaUtil.get(messageSupplier);
        Throwable effectiveThrowable = throwable == null && message != null ? message.getThrowable() : throwable;
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message, effectiveThrowable);
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, Supplier<?> messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message message = LambdaUtil.getMessage(messageSupplier, this.messageFactory);
        Throwable effectiveThrowable = throwable == null && message != null ? message.getThrowable() : throwable;
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message, effectiveThrowable);
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, this.messageFactory.newMessage(message), throwable);
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, params);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, p0);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, p0, p1);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, p0, p1, p2);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, p0, p1, p2, p3);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, p0, p1, p2, p3, p4);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, p0, p1, p2, p3, p4, p5);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, p0, p1, p2, p3, p4, p5, p6);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    protected void logMessage(String fqcn, Level level, Marker marker, String message, Supplier<?> ... paramSuppliers) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message msg;
        Message message2 = msg = this.messageFactory.newMessage(message, LambdaUtil.getAll(paramSuppliers));
        this.logMessageSafely((String)var1_1, (Level)var2_2, (Marker)var3_3, message2, message2.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logMessage(Level level, Marker marker, String fqcn, StackTraceElement location, Message message, Throwable throwable) {
        try {
            void var2_4;
            AbstractLogger.incrementRecursionDepth();
            this.log(level, (Marker)var2_4, fqcn, location, message, throwable);
            return;
        }
        catch (Throwable ex) {
            void var3_5;
            void var1_2;
            this.handleLogMessageException((Throwable)var1_2, (String)var3_5, message);
            return;
        }
        finally {
            AbstractLogger.decrementRecursionDepth();
            ReusableMessageFactory.release(message);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void log(Level level, Marker marker, String fqcn, StackTraceElement location, Message message, Throwable throwable) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.logMessage((String)var3_3, (Level)var1_1, (Marker)var2_2, message, throwable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printf(Level level, Marker marker, String format, Object ... params) {
        if (this.isEnabled(level, marker, format, params)) {
            void var2_2;
            void var1_1;
            void var3_3;
            StringFormattedMessage message = new StringFormattedMessage(format, params);
            void v0 = var3_3;
            this.logMessageSafely(FQCN, (Level)var1_1, (Marker)var2_2, (Message)v0, v0.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printf(Level level, String format, Object ... params) {
        if (this.isEnabled(level, (Marker)null, format, params)) {
            void var1_1;
            void var2_2;
            void var3_3;
            StringFormattedMessage message = new StringFormattedMessage(format, (Object[])var3_3);
            void v0 = var2_2;
            this.logMessageSafely(FQCN, (Level)var1_1, null, (Message)v0, v0.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    private void logMessageSafely(String fqcn, Level level, Marker marker, Message message, Throwable throwable) {
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            this.logMessageTrackRecursion((String)var1_1, (Level)var2_3, (Marker)var3_4, message, throwable);
            return;
        }
        finally {
            ReusableMessageFactory.release(message);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    private void logMessageTrackRecursion(String fqcn, Level level, Marker marker, Message message, Throwable throwable) {
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            AbstractLogger.incrementRecursionDepth();
            this.tryLogMessage(fqcn, this.getLocation((String)var1_1), (Level)var2_3, (Marker)var3_4, message, throwable);
            return;
        }
        finally {
            AbstractLogger.decrementRecursionDepth();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int[] getRecursionDepthHolder() {
        void var0;
        int[] result = recursionDepthHolder.get();
        if (result == null) {
            result = new int[1];
            recursionDepthHolder.set(result);
        }
        return var0;
    }

    private static void incrementRecursionDepth() {
        int[] nArray = AbstractLogger.getRecursionDepthHolder();
        nArray[0] = nArray[0] + 1;
    }

    /*
     * WARNING - void declaration
     */
    private static void decrementRecursionDepth() {
        int[] nArray = AbstractLogger.getRecursionDepthHolder();
        int n = nArray[0] - 1;
        nArray[0] = n;
        int newDepth = n;
        if (n < 0) {
            void var0;
            throw new IllegalStateException("Recursion depth became negative: " + (int)var0);
        }
    }

    public static int getRecursionDepth() {
        return AbstractLogger.getRecursionDepthHolder()[0];
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    private void tryLogMessage(String fqcn, StackTraceElement location, Level level, Marker marker, Message message, Throwable throwable) {
        try {
            void var3_4;
            this.log((Level)var3_4, marker, fqcn, location, message, throwable);
            return;
        }
        catch (Throwable t) {
            void var1_1;
            void var2_3;
            this.handleLogMessageException((Throwable)var2_3, (String)var1_1, message);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @PerformanceSensitive
    private StackTraceElement getLocation(String fqcn) {
        if (this.requiresLocation()) {
            void var1_1;
            return StackLocatorUtil.calcLocation((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void handleLogMessageException(Throwable throwable, String fqcn, Message message) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (throwable instanceof LoggingException) {
            throw (LoggingException)throwable;
        }
        StatusLogger.getLogger().warn("{} caught {} logging {}: {}", (Object)var2_2, (Object)throwable.getClass().getName(), (Object)message.getClass().getSimpleName(), (Object)var3_3.getFormat(), (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Throwable> T throwing(T throwable) {
        void var1_1;
        return this.throwing(FQCN, Level.ERROR, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Throwable> T throwing(Level level, T throwable) {
        void var2_2;
        void var1_1;
        return this.throwing(FQCN, (Level)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected <T extends Throwable> T throwing(String fqcn, Level level, T throwable) {
        void var3_3;
        if (this.isEnabled(level, THROWING_MARKER, (Object)null, null)) {
            void var2_2;
            void var1_1;
            this.logMessageSafely((String)var1_1, (Level)var2_2, THROWING_MARKER, this.throwingMsg(throwable), throwable);
        }
        return var3_3;
    }

    protected Message throwingMsg(Throwable throwable) {
        return this.messageFactory.newMessage(THROWING);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, Message message) {
        void var2_2;
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, message2, message2 != null ? var2_2.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, Message message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (Message)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, CharSequence message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (CharSequence)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, CharSequence message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (CharSequence)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, Object message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, Object message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Message message) {
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.TRACE, null, message2, message2 != null ? var1_1.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Message message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, null, (Message)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(CharSequence message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, null, (CharSequence)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(CharSequence message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, null, (CharSequence)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Object message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, null, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Object message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, null, var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Object ... params) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Supplier<?> messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, null, (Supplier<?>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Supplier<?> messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, null, (Supplier<?>)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, Supplier<?> messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (Supplier<?>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Supplier<?> ... paramSuppliers) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Supplier<?>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, Supplier<?> messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (Supplier<?>)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Supplier<?> ... paramSuppliers) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, null, (String)var1_1, (Supplier<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, MessageSupplier messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (MessageSupplier)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, MessageSupplier messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (MessageSupplier)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(MessageSupplier messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, null, (MessageSupplier)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(MessageSupplier messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, null, (MessageSupplier)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Object p0) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Object p0) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Override
    public EntryMessage traceEntry() {
        return this.enter(FQCN, (String)null, (Object[])null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EntryMessage traceEntry(String format, Object ... params) {
        void var2_2;
        void var1_1;
        return this.enter(FQCN, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EntryMessage traceEntry(Supplier<?> ... paramSuppliers) {
        void var1_1;
        return this.enter(FQCN, null, (Supplier<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EntryMessage traceEntry(String format, Supplier<?> ... paramSuppliers) {
        void var2_2;
        void var1_1;
        return this.enter(FQCN, (String)var1_1, (Supplier<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EntryMessage traceEntry(Message message) {
        void var1_1;
        return this.enter(FQCN, (Message)var1_1);
    }

    @Override
    public void traceExit() {
        this.exit(FQCN, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <R> R traceExit(R result) {
        void var1_1;
        return this.exit(FQCN, null, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <R> R traceExit(String format, R result) {
        void var2_2;
        void var1_1;
        return this.exit(FQCN, (String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void traceExit(EntryMessage message) {
        if (message != null && this.isEnabled(Level.TRACE, EXIT_MARKER, message, null)) {
            void var1_1;
            this.logMessageSafely(FQCN, Level.TRACE, EXIT_MARKER, this.flowMessageFactory.newExitMessage((EntryMessage)var1_1), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <R> R traceExit(EntryMessage message, R result) {
        void var2_2;
        if (message != null && this.isEnabled(Level.TRACE, EXIT_MARKER, message, null)) {
            void var1_1;
            this.logMessageSafely(FQCN, Level.TRACE, EXIT_MARKER, this.flowMessageFactory.newExitMessage(result, (EntryMessage)var1_1), null);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <R> R traceExit(Message message, R result) {
        void var2_2;
        if (message != null && this.isEnabled(Level.TRACE, EXIT_MARKER, message, null)) {
            void var1_1;
            this.logMessageSafely(FQCN, Level.TRACE, EXIT_MARKER, this.flowMessageFactory.newExitMessage(result, (Message)var1_1), null);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, Message message) {
        void var2_2;
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, message2, message2 != null ? var2_2.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, Message message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (Message)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, CharSequence message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (CharSequence)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, CharSequence message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (CharSequence)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, Object message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, Object message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Message message) {
        void var1_1;
        Message message2 = message;
        this.logIfEnabled(FQCN, Level.WARN, null, message2, message2 != null ? var1_1.getThrowable() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Message message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, null, (Message)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(CharSequence message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, null, (CharSequence)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(CharSequence message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, null, (CharSequence)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Object message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, null, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Object message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, null, var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Throwable)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Object ... params) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Supplier<?> messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, null, (Supplier<?>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Supplier<?> messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, null, (Supplier<?>)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, Supplier<?> messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (Supplier<?>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Supplier<?> ... paramSuppliers) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Supplier<?>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, Supplier<?> messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (Supplier<?>)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Supplier<?> ... paramSuppliers) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, null, (String)var1_1, (Supplier<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, MessageSupplier messageSupplier) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (MessageSupplier)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, MessageSupplier messageSupplier, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (MessageSupplier)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(MessageSupplier messageSupplier) {
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, null, (MessageSupplier)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(MessageSupplier messageSupplier, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, null, (MessageSupplier)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Object p0) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)var1_1, (String)var2_2, (Object)var3_3, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Object p0) {
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    protected boolean requiresLocation() {
        return false;
    }

    @Override
    public LogBuilder atTrace() {
        return this.atLevel(Level.TRACE);
    }

    @Override
    public LogBuilder atDebug() {
        return this.atLevel(Level.DEBUG);
    }

    @Override
    public LogBuilder atInfo() {
        return this.atLevel(Level.INFO);
    }

    @Override
    public LogBuilder atWarn() {
        return this.atLevel(Level.WARN);
    }

    @Override
    public LogBuilder atError() {
        return this.atLevel(Level.ERROR);
    }

    @Override
    public LogBuilder atFatal() {
        return this.atLevel(Level.FATAL);
    }

    @Override
    public LogBuilder always() {
        return this.getLogBuilder(Level.OFF);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LogBuilder atLevel(Level level) {
        if (this.isEnabled(level)) {
            void var1_1;
            return this.getLogBuilder((Level)var1_1);
        }
        return LogBuilder.NOOP;
    }

    /*
     * WARNING - void declaration
     */
    protected LogBuilder getLogBuilder(Level level) {
        void var1_1;
        DefaultLogBuilder builder = logBuilder.get();
        if (Constants.ENABLE_THREADLOCALS && !builder.isInUse()) {
            void var2_2;
            return var2_2.reset(this, level);
        }
        return new DefaultLogBuilder(this, (Level)var1_1);
    }
}

