/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.simple;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

public class SimpleLogger
extends AbstractLogger {
    private static final long serialVersionUID = 1L;
    private static final char SPACE = ' ';
    private final DateFormat dateFormatter;
    private Level level;
    private final boolean showDateTime;
    private final boolean showContextMap;
    private PrintStream stream;
    private final String logName;

    /*
     * WARNING - void declaration
     */
    public SimpleLogger(String name, Level defaultLevel, boolean showLogName, boolean showShortLogName, boolean showDateTime, boolean showContextMap, String dateTimeFormat, MessageFactory messageFactory, PropertiesUtil props, PrintStream stream) {
        super(name, messageFactory);
        void var1_1;
        void var3_5;
        int index;
        String lvl = props.getStringProperty("org.apache.logging.log4j.simplelog." + name + ".level");
        this.level = Level.toLevel(lvl, defaultLevel);
        this.logName = showShortLogName ? ((index = name.lastIndexOf(".")) > 0 && index < name.length() ? name.substring(index + 1) : name) : (var3_5 != false ? var1_1 : null);
        this.showDateTime = showDateTime;
        this.showContextMap = showContextMap;
        this.stream = stream;
        if (showDateTime) {
            void var2_4;
            SimpleDateFormat format;
            try {
                format = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS zzz");
            }
            this.dateFormatter = var2_4;
            return;
        }
        this.dateFormatter = null;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, Message msg, Throwable t) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, CharSequence msg, Throwable t) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, Object msg, Throwable t) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String msg) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String msg, Object ... p1) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(Level testLevel, Marker marker, String msg, Throwable t) {
        void var1_1;
        return this.level.intLevel() >= var1_1.intLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logMessage(String fqcn, Level mgsLevel, Marker marker, Message msg, Throwable throwable) {
        void var1_1;
        Map<String, String> mdc;
        void var2_3;
        StringBuilder sb = new StringBuilder();
        if (this.showDateTime) {
            String dateText;
            Date now = new Date();
            DateFormat dateFormat = this.dateFormatter;
            synchronized (dateFormat) {
                dateText = this.dateFormatter.format(now);
            }
            sb.append(dateText);
            sb.append(' ');
        }
        sb.append(var2_3.toString());
        sb.append(' ');
        if (Strings.isNotEmpty(this.logName)) {
            sb.append(this.logName);
            sb.append(' ');
        }
        sb.append(msg.getFormattedMessage());
        if (this.showContextMap && (mdc = ThreadContext.getImmutableContext()).size() > 0) {
            sb.append(' ');
            sb.append(mdc.toString());
            sb.append(' ');
        }
        Object[] params = msg.getParameters();
        Throwable t = throwable == null && params != null && params.length > 0 && params[params.length - 1] instanceof Throwable ? (Throwable)params[params.length - 1] : throwable;
        this.stream.println(var1_1.toString());
        if (t != null) {
            void var3_4;
            this.stream.print(' ');
            var3_4.printStackTrace(this.stream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setLevel(Level level) {
        if (level != null) {
            void var1_1;
            this.level = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setStream(PrintStream stream) {
        void var1_1;
        this.stream = var1_1;
    }
}

