/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.BasicThreadInformation;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ThreadInformation;
import org.apache.logging.log4j.util.ServiceLoaderUtil;
import org.apache.logging.log4j.util.StringBuilderFormattable;

@AsynchronouslyFormattable
public class ThreadDumpMessage
implements Message,
StringBuilderFormattable {
    private static final long serialVersionUID = -1103400781608841088L;
    private static ThreadInfoFactory FACTORY;
    private volatile Map<ThreadInformation, StackTraceElement[]> threads;
    private final String title;
    private String formattedMessage;

    /*
     * WARNING - void declaration
     */
    public ThreadDumpMessage(String title) {
        void var1_1;
        this.title = title == null ? "" : var1_1;
        this.threads = ThreadDumpMessage.getFactory().createThreadInfo();
    }

    /*
     * WARNING - void declaration
     */
    private ThreadDumpMessage(String formattedMsg, String title) {
        void var2_2;
        void var1_1;
        this.formattedMessage = var1_1;
        this.title = title == null ? "" : var2_2;
    }

    private static ThreadInfoFactory getFactory() {
        if (FACTORY == null) {
            FACTORY = ThreadDumpMessage.initFactory();
        }
        return FACTORY;
    }

    private static ThreadInfoFactory initFactory() {
        return ServiceLoaderUtil.loadServices(ThreadInfoFactory.class, MethodHandles.lookup(), false).findFirst().orElseGet(() -> new BasicThreadInfoFactory());
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedMessage() {
        void var1_1;
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        StringBuilder sb = new StringBuilder(255);
        this.formatTo(sb);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void formatTo(StringBuilder sb) {
        sb.append(this.title);
        if (this.title.length() > 0) {
            sb.append('\n');
        }
        for (Map.Entry<ThreadInformation, StackTraceElement[]> entry : this.threads.entrySet()) {
            void var3_3;
            ThreadInformation info = entry.getKey();
            info.printThreadInfo(sb);
            info.printStack(sb, (StackTraceElement[])var3_3.getValue());
            sb.append('\n');
        }
    }

    @Override
    public String getFormat() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    protected Object writeReplace() {
        return new ThreadDumpMessageProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    private static class BasicThreadInfoFactory
    implements ThreadInfoFactory {
        private BasicThreadInfoFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<ThreadInformation, StackTraceElement[]> createThreadInfo() {
            void var2_2;
            Iterator iterator;
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            HashMap threads = new HashMap(map.size());
            for (Map.Entry entry : iterator.entrySet()) {
                void var3_3;
                threads.put(new BasicThreadInformation((Thread)entry.getKey()), var3_3.getValue());
            }
            return var2_2;
        }
    }

    public static interface ThreadInfoFactory {
        public Map<ThreadInformation, StackTraceElement[]> createThreadInfo();
    }

    private static class ThreadDumpMessageProxy
    implements Serializable {
        private static final long serialVersionUID = -3476620450287648269L;
        private final String formattedMsg;
        private final String title;

        /*
         * WARNING - void declaration
         */
        ThreadDumpMessageProxy(ThreadDumpMessage msg) {
            void var1_1;
            this.formattedMsg = msg.getFormattedMessage();
            this.title = ((ThreadDumpMessage)var1_1).title;
        }

        protected Object readResolve() {
            return new ThreadDumpMessage(this.formattedMsg, this.title);
        }
    }
}

