/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Map;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.StructuredDataId;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.StringBuilders;

@AsynchronouslyFormattable
public class StructuredDataMessage
extends MapMessage<StructuredDataMessage, String> {
    private static final long serialVersionUID = 1703221292892071920L;
    private static final int MAX_LENGTH = 32;
    private static final int HASHVAL = 31;
    private StructuredDataId id;
    private String message;
    private String type;
    private final int maxLength;

    /*
     * WARNING - void declaration
     */
    public StructuredDataMessage(String id, String msg, String type) {
        this((String)var1_1, (String)var2_2, (String)var3_3, 32);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataMessage(String id, String msg, String type, int maxLength) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.id = new StructuredDataId((String)var1_1, null, null, maxLength);
        this.message = var2_2;
        this.type = var3_3;
        this.maxLength = maxLength;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataMessage(String id, String msg, String type, Map<String, String> data) {
        this((String)var1_1, (String)var2_2, (String)var3_3, data, 32);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataMessage(String id, String msg, String type, Map<String, String> data, int maxLength) {
        super(data);
        void var3_3;
        void var2_2;
        void var1_1;
        this.id = new StructuredDataId((String)var1_1, null, null, maxLength);
        this.message = var2_2;
        this.type = var3_3;
        this.maxLength = maxLength;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataMessage(StructuredDataId id, String msg, String type) {
        this((StructuredDataId)var1_1, (String)var2_2, (String)var3_3, 32);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataMessage(StructuredDataId id, String msg, String type, int maxLength) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.id = var1_1;
        this.message = var2_2;
        this.type = var3_3;
        this.maxLength = maxLength;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataMessage(StructuredDataId id, String msg, String type, Map<String, String> data) {
        this((StructuredDataId)var1_1, (String)var2_2, (String)var3_3, data, 32);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataMessage(StructuredDataId id, String msg, String type, Map<String, String> data, int maxLength) {
        super(data);
        void var3_3;
        void var2_2;
        void var1_1;
        this.id = var1_1;
        this.message = var2_2;
        this.type = var3_3;
        this.maxLength = maxLength;
    }

    /*
     * WARNING - void declaration
     */
    private StructuredDataMessage(StructuredDataMessage msg, Map<String, String> map) {
        super(var2_2);
        void var1_1;
        void var2_2;
        this.id = msg.id;
        this.message = msg.message;
        this.type = var1_1.type;
        this.maxLength = 32;
    }

    protected StructuredDataMessage() {
        this.maxLength = 32;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] getFormats() {
        void var1_1;
        String[] formats = new String[Format.values().length];
        int i = 0;
        for (Format format : Format.values()) {
            formats[i++] = format.name();
        }
        return var1_1;
    }

    public StructuredDataId getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    protected void setId(String id) {
        void var1_1;
        this.id = new StructuredDataId((String)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void setId(StructuredDataId id) {
        void var1_1;
        this.id = var1_1;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    protected void setType(String type) {
        void var1_1;
        if (type.length() > 32) {
            throw new IllegalArgumentException("structured data type exceeds maximum length of 32 characters: " + type);
        }
        this.type = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void formatTo(StringBuilder buffer) {
        void var1_1;
        this.asString(Format.FULL, null, (StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void formatTo(String[] formats, StringBuilder buffer) {
        void var2_2;
        void var1_1;
        StructuredDataMessage structuredDataMessage = this;
        structuredDataMessage.asString(structuredDataMessage.getFormat((String[])var1_1), null, (StringBuilder)var2_2);
    }

    @Override
    public String getFormat() {
        return this.message;
    }

    /*
     * WARNING - void declaration
     */
    protected void setMessageFormat(String msg) {
        void var1_1;
        this.message = var1_1;
    }

    @Override
    public String asString() {
        return this.asString(Format.FULL, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String asString(String format) {
        try {
            void var1_1;
            return this.asString(EnglishEnums.valueOf(Format.class, (String)var1_1), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ((MapMessage)this).asString();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String asString(Format format, StructuredDataId structuredDataId) {
        void var3_3;
        void var2_2;
        void var1_1;
        StringBuilder sb = new StringBuilder();
        this.asString((Format)var1_1, (StructuredDataId)var2_2, sb);
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void asString(Format format, StructuredDataId structuredDataId, StringBuilder sb) {
        String msg;
        void var2_2;
        Object sdId;
        boolean full = Format.FULL.equals((Object)format);
        if (full) {
            String string = this.getType();
            if (string == null) {
                return;
            }
            sb.append(this.getType()).append(' ');
        }
        if ((sdId = (sdId = this.getId()) != null ? sdId.makeId(structuredDataId) : var2_2) == null || sdId.getName() == null) {
            return;
        }
        if (Format.XML.equals((Object)format)) {
            this.asXml((StructuredDataId)sdId, sb);
            return;
        }
        sb.append('[');
        StringBuilders.appendValue(sb, sdId);
        sb.append(' ');
        this.appendMap(sb);
        sb.append(']');
        if (full && (msg = ((MapMessage)this).getFormat()) != null) {
            void var1_1;
            void var3_3;
            var3_3.append(' ').append((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void asXml(StructuredDataId structuredDataId, StringBuilder sb) {
        void var2_2;
        void var1_1;
        sb.append("<StructuredData>\n");
        sb.append("<type>").append(this.type).append("</type>\n");
        sb.append("<id>").append(var1_1).append("</id>\n");
        super.asXml(sb);
        var2_2.append("\n</StructuredData>\n");
    }

    @Override
    public String getFormattedMessage() {
        return this.asString(Format.FULL, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedMessage(String[] formats) {
        void var1_1;
        StructuredDataMessage structuredDataMessage = this;
        return structuredDataMessage.asString(structuredDataMessage.getFormat((String[])var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    private Format getFormat(String[] formats) {
        if (formats != null && formats.length > 0) {
            for (int i = 0; i < formats.length; ++i) {
                void var3_3;
                String format = formats[i];
                if (Format.XML.name().equalsIgnoreCase(format)) {
                    return Format.XML;
                }
                if (!Format.FULL.name().equalsIgnoreCase((String)var3_3)) continue;
                return Format.FULL;
            }
            return null;
        }
        return Format.FULL;
    }

    @Override
    public String toString() {
        return this.asString(null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructuredDataMessage newInstance(Map<String, String> map) {
        void var1_1;
        return new StructuredDataMessage(this, (Map<String, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        void var2_2;
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructuredDataMessage that = (StructuredDataMessage)o;
        if (!super.equals(var1_1)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : var2_2.message != null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = super.hashCode();
        result = result * 31 + (this.type != null ? this.type.hashCode() : 0);
        result = result * 31 + (this.id != null ? this.id.hashCode() : 0);
        var1_1 = var1_1 * 31 + (this.message != null ? this.message.hashCode() : 0);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(String key, boolean value) {
        void var1_1;
        this.validateKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(String key, byte value) {
        void var1_1;
        this.validateKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(String key, char value) {
        void var1_1;
        this.validateKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(String key, double value) {
        void var1_1;
        this.validateKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(String key, float value) {
        void var1_1;
        this.validateKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(String key, int value) {
        void var1_1;
        this.validateKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(String key, long value) {
        void var1_1;
        this.validateKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(String key, Object value) {
        void var1_1;
        this.validateKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(String key, short value) {
        void var1_1;
        this.validateKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validate(String key, String value) {
        void var1_1;
        this.validateKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void validateKey(String key) {
        if (this.maxLength > 0 && key.length() > this.maxLength) {
            throw new IllegalArgumentException("Structured data keys are limited to " + this.maxLength + " characters. key: " + key);
        }
        for (int i = 0; i < key.length(); ++i) {
            void var3_3;
            char c = key.charAt(i);
            if (c >= '!' && c <= '~' && c != '=' && c != ']' && var3_3 != 34) continue;
            throw new IllegalArgumentException("Structured data keys must contain printable US ASCII charactersand may not contain a space, =, ], or \"");
        }
    }

    public static enum Format {
        XML,
        FULL;

    }
}

