/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.Strings;

public class StructuredDataId
implements Serializable,
StringBuilderFormattable {
    public static final StructuredDataId TIME_QUALITY = new StructuredDataId("timeQuality", null, new String[]{"tzKnown", "isSynced", "syncAccuracy"});
    public static final StructuredDataId ORIGIN = new StructuredDataId("origin", null, new String[]{"ip", "enterpriseId", "software", "swVersion"});
    public static final StructuredDataId META = new StructuredDataId("meta", null, new String[]{"sequenceId", "sysUpTime", "language"});
    public static final String RESERVED = "-1";
    private static final long serialVersionUID = -8252896346202183738L;
    private static final int MAX_LENGTH = 32;
    private static final String AT_SIGN = "@";
    private final String name;
    private final String enterpriseNumber;
    private final String[] required;
    private final String[] optional;

    /*
     * WARNING - void declaration
     */
    public StructuredDataId(String name) {
        this((String)var1_1, null, null, 32);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataId(String name, int maxLength) {
        this((String)var1_1, null, null, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataId(String name, String[] required, String[] optional) {
        this((String)var1_1, (String[])var2_2, (String[])var3_3, 32);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataId(String name, String[] required, String[] optional, int maxLength) {
        void var3_3;
        void var2_2;
        int index = -1;
        if (name != null) {
            if (maxLength <= 0) {
                maxLength = 32;
            }
            if (name.length() > maxLength) {
                throw new IllegalArgumentException(String.format("Length of id %s exceeds maximum of %d characters", name, maxLength));
            }
            index = name.indexOf(AT_SIGN);
        }
        if (index > 0) {
            this.name = name.substring(0, index);
            this.enterpriseNumber = name.substring(index + 1).trim();
        } else {
            void var1_1;
            this.name = var1_1;
            this.enterpriseNumber = RESERVED;
        }
        this.required = var2_2;
        this.optional = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataId(String name, String enterpriseNumber, String[] required, String[] optional) {
        this((String)var1_1, (String)var2_2, (String[])var3_3, optional, 32);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public StructuredDataId(String name, int enterpriseNumber, String[] required, String[] optional) {
        this((String)var1_1, String.valueOf((int)var2_2), (String[])var3_3, optional, 32);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataId(String name, String enterpriseNumber, String[] required, String[] optional, int maxLength) {
        void var3_3;
        void var2_2;
        if (name == null) {
            throw new IllegalArgumentException("No structured id name was supplied");
        }
        if (name.contains(AT_SIGN)) {
            throw new IllegalArgumentException("Structured id name cannot contain an " + Strings.quote(AT_SIGN));
        }
        if (RESERVED.equals(enterpriseNumber)) {
            throw new IllegalArgumentException("No enterprise number was supplied");
        }
        this.name = name;
        this.enterpriseNumber = enterpriseNumber;
        String id = name + AT_SIGN + (String)var2_2;
        if (maxLength > 0 && id.length() > maxLength) {
            void var1_1;
            throw new IllegalArgumentException("Length of id exceeds maximum of " + maxLength + " characters: " + (String)var1_1);
        }
        this.required = var3_3;
        this.optional = optional;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public StructuredDataId(String name, int enterpriseNumber, String[] required, String[] optional, int maxLength) {
        this((String)var1_1, String.valueOf((int)var2_2), (String[])var3_3, optional, maxLength);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataId makeId(StructuredDataId id) {
        void var1_1;
        if (id == null) {
            return this;
        }
        return this.makeId(id.getName(), var1_1.getEnterpriseNumber());
    }

    /*
     * WARNING - void declaration
     */
    public StructuredDataId makeId(String defaultId, String anEnterpriseNumber) {
        void var3_3;
        void var2_2;
        void var1_1;
        String[] opt;
        String[] req;
        if (RESERVED.equals(anEnterpriseNumber)) {
            return this;
        }
        if (this.name != null) {
            String id = this.name;
            req = this.required;
            opt = this.optional;
        } else {
            req = null;
            opt = null;
        }
        return new StructuredDataId((String)var1_1, (String)var2_2, (String[])var3_3, opt);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public StructuredDataId makeId(String defaultId, int anEnterpriseNumber) {
        void var2_2;
        void var1_1;
        return this.makeId((String)var1_1, String.valueOf((int)var2_2));
    }

    public String[] getRequired() {
        return this.required;
    }

    public String[] getOptional() {
        return this.optional;
    }

    public String getName() {
        return this.name;
    }

    public String getEnterpriseNumber() {
        return this.enterpriseNumber;
    }

    public boolean isReserved() {
        return RESERVED.equals(this.enterpriseNumber);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder(this.name.length() + 10);
        this.formatTo(sb);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void formatTo(StringBuilder buffer) {
        void var1_1;
        if (this.isReserved()) {
            buffer.append(this.name);
            return;
        }
        var1_1.append(this.name).append(AT_SIGN).append(this.enterpriseNumber);
    }
}

