/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Arrays;
import org.apache.logging.log4j.message.Clearable;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterConsumer;
import org.apache.logging.log4j.message.ParameterFormatter;
import org.apache.logging.log4j.message.ParameterVisitable;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StringBuilders;

@PerformanceSensitive(value={"allocation"})
public class ReusableParameterizedMessage
implements Clearable,
ParameterVisitable,
ReusableMessage {
    private static final int MIN_BUILDER_SIZE = 512;
    private static final int MAX_PARMS = 10;
    private static final long serialVersionUID = 7800075879295123856L;
    private transient ThreadLocal<StringBuilder> buffer;
    private String messagePattern;
    private int argCount;
    private int usedCount;
    private final int[] indices = new int[256];
    private transient Object[] varargs;
    private transient Object[] params = new Object[10];
    private transient Throwable throwable;
    transient boolean reserved = false;

    private Object[] getTrimmedParams() {
        if (this.varargs == null) {
            return Arrays.copyOf(this.params, this.argCount);
        }
        return this.varargs;
    }

    private Object[] getParams() {
        if (this.varargs == null) {
            return this.params;
        }
        return this.varargs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object[] swapParameters(Object[] emptyReplacement) {
        void var2_2;
        Object result;
        if (this.varargs == null) {
            result = this.params;
            if (emptyReplacement.length >= 10) {
                this.params = emptyReplacement;
            } else if (this.argCount <= emptyReplacement.length) {
                System.arraycopy(this.params, 0, emptyReplacement, 0, this.argCount);
                for (int i = 0; i < this.argCount; ++i) {
                    this.params[i] = null;
                }
                Object[] i = emptyReplacement;
            } else {
                this.params = new Object[10];
            }
        } else {
            void var1_1;
            result = this.argCount <= emptyReplacement.length ? var1_1 : new Object[this.argCount];
            System.arraycopy(this.varargs, 0, result, 0, this.argCount);
        }
        return var2_2;
    }

    @Override
    public short getParameterCount() {
        return (short)this.argCount;
    }

    @Override
    public <S> void forEachParameter(ParameterConsumer<S> action, S state) {
        Object[] parameters = this.getParams();
        for (int i = 0; i < this.argCount; i = (int)((short)(i + 1))) {
            action.accept(parameters[i], i, state);
        }
    }

    @Override
    public Message memento() {
        return new ParameterizedMessage(this.messagePattern, this.getTrimmedParams());
    }

    /*
     * WARNING - void declaration
     */
    private void init(String messagePattern, int argCount, Object[] paramArray) {
        void var2_3;
        void var1_2;
        void var3_4;
        this.varargs = null;
        this.messagePattern = messagePattern;
        this.argCount = argCount;
        int placeholderCount = ReusableParameterizedMessage.count(messagePattern, this.indices);
        this.initThrowable((Object[])var3_4, argCount, placeholderCount);
        this.usedCount = Math.min((int)var1_2, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private static int count(String messagePattern, int[] indices) {
        try {
            void var1_1;
            return ParameterFormatter.countArgumentPlaceholders2(messagePattern, (int[])var1_1);
        }
        catch (Exception exception) {
            String string;
            return ParameterFormatter.countArgumentPlaceholders(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initThrowable(Object[] params, int argCount, int usedParams) {
        if (usedParams < argCount && params[argCount - 1] instanceof Throwable) {
            void var2_2;
            void var1_1;
            this.throwable = (Throwable)var1_1[var2_2 - true];
            return;
        }
        this.throwable = null;
    }

    /*
     * WARNING - void declaration
     */
    ReusableParameterizedMessage set(String messagePattern, Object ... arguments) {
        void var2_2;
        void var1_1;
        this.init((String)var1_1, arguments == null ? 0 : arguments.length, arguments);
        this.varargs = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    ReusableParameterizedMessage set(String messagePattern, Object p0) {
        void var1_1;
        void var2_2;
        this.params[0] = var2_2;
        this.init((String)var1_1, 1, this.params);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.params[0] = var2_2;
        this.params[1] = var3_3;
        this.init((String)var1_1, 2, this.params);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1, Object p2) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.params[0] = var2_2;
        this.params[1] = var3_3;
        this.params[2] = p2;
        this.init((String)var1_1, 3, this.params);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1, Object p2, Object p3) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.params[0] = var2_2;
        this.params[1] = var3_3;
        this.params[2] = p2;
        this.params[3] = p3;
        this.init((String)var1_1, 4, this.params);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.params[0] = var2_2;
        this.params[1] = var3_3;
        this.params[2] = p2;
        this.params[3] = p3;
        this.params[4] = p4;
        this.init((String)var1_1, 5, this.params);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.params[0] = var2_2;
        this.params[1] = var3_3;
        this.params[2] = p2;
        this.params[3] = p3;
        this.params[4] = p4;
        this.params[5] = p5;
        this.init((String)var1_1, 6, this.params);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.params[0] = var2_2;
        this.params[1] = var3_3;
        this.params[2] = p2;
        this.params[3] = p3;
        this.params[4] = p4;
        this.params[5] = p5;
        this.params[6] = p6;
        this.init((String)var1_1, 7, this.params);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.params[0] = var2_2;
        this.params[1] = var3_3;
        this.params[2] = p2;
        this.params[3] = p3;
        this.params[4] = p4;
        this.params[5] = p5;
        this.params[6] = p6;
        this.params[7] = p7;
        this.init((String)var1_1, 8, this.params);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.params[0] = var2_2;
        this.params[1] = var3_3;
        this.params[2] = p2;
        this.params[3] = p3;
        this.params[4] = p4;
        this.params[5] = p5;
        this.params[6] = p6;
        this.params[7] = p7;
        this.params[8] = p8;
        this.init((String)var1_1, 9, this.params);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.params[0] = var2_2;
        this.params[1] = var3_3;
        this.params[2] = p2;
        this.params[3] = p3;
        this.params[4] = p4;
        this.params[5] = p5;
        this.params[6] = p6;
        this.params[7] = p7;
        this.params[8] = p8;
        this.params[9] = p9;
        this.init((String)var1_1, 10, this.params);
        return this;
    }

    @Override
    public String getFormat() {
        return this.messagePattern;
    }

    @Override
    public Object[] getParameters() {
        return this.getTrimmedParams();
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedMessage() {
        void var2_2;
        void var1_1;
        StringBuilder sb = this.getBuffer();
        this.formatTo(sb);
        String result = sb.toString();
        StringBuilders.trimToMaxSize((StringBuilder)var1_1, Constants.MAX_REUSABLE_MESSAGE_SIZE);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder getBuffer() {
        StringBuilder stringBuilder;
        StringBuilder result;
        if (this.buffer == null) {
            this.buffer = new ThreadLocal();
        }
        if ((result = this.buffer.get()) == null) {
            void var1_2;
            int currentPatternLength = this.messagePattern == null ? 0 : this.messagePattern.length();
            stringBuilder = new StringBuilder(Math.max(512, (int)(var1_2 << 1)));
            this.buffer.set(stringBuilder);
        }
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void formatTo(StringBuilder builder) {
        void var1_1;
        if (this.indices[0] < 0) {
            ParameterFormatter.formatMessage(builder, this.messagePattern, this.getParams(), this.argCount);
            return;
        }
        ParameterFormatter.formatMessage2((StringBuilder)var1_1, this.messagePattern, this.getParams(), this.usedCount, this.indices);
    }

    ReusableParameterizedMessage reserve() {
        this.reserved = true;
        return this;
    }

    public String toString() {
        return "ReusableParameterizedMessage[messagePattern=" + this.getFormat() + ", stringArgs=" + Arrays.toString(this.getParameters()) + ", throwable=" + this.getThrowable() + ']';
    }

    @Override
    public void clear() {
        this.reserved = false;
        this.varargs = null;
        this.messagePattern = null;
        this.throwable = null;
    }
}

