/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Arrays;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterFormatter;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;

public class ParameterizedMessage
implements Message,
StringBuilderFormattable {
    private static final int DEFAULT_STRING_BUILDER_SIZE = 255;
    public static final String RECURSION_PREFIX = "[...";
    public static final String RECURSION_SUFFIX = "...]";
    public static final String ERROR_PREFIX = "[!!!";
    public static final String ERROR_SEPARATOR = "=>";
    public static final String ERROR_MSG_SEPARATOR = ":";
    public static final String ERROR_SUFFIX = "!!!]";
    private static final long serialVersionUID = -665975803997290697L;
    private static final int HASHVAL = 31;
    private static ThreadLocal<StringBuilder> threadLocalStringBuilder = new ThreadLocal();
    private String messagePattern;
    private transient Object[] argArray;
    private String formattedMessage;
    private transient Throwable throwable;
    private int[] indices;
    private int usedCount;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ParameterizedMessage(String messagePattern, String[] arguments, Throwable throwable) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.argArray = var2_2;
        this.throwable = var3_3;
        this.init((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ParameterizedMessage(String messagePattern, Object[] arguments, Throwable throwable) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.argArray = var2_2;
        this.throwable = var3_3;
        this.init((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ParameterizedMessage(String messagePattern, Object ... arguments) {
        void var1_1;
        void var2_2;
        this.argArray = var2_2;
        this.init((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ParameterizedMessage(String messagePattern, Object arg) {
        this((String)var1_1, new Object[]{var2_2});
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ParameterizedMessage(String messagePattern, Object arg0, Object arg1) {
        this((String)var1_1, new Object[]{var2_2, var3_3});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void init(String messagePattern) {
        void var1_2;
        void var2_3;
        this.messagePattern = messagePattern;
        int len = Math.max(1, messagePattern == null ? 0 : messagePattern.length() >> 1);
        this.indices = new int[var2_3];
        int placeholders = ParameterFormatter.countArgumentPlaceholders2(messagePattern, this.indices);
        ParameterizedMessage parameterizedMessage = this;
        parameterizedMessage.initThrowable(parameterizedMessage.argArray, placeholders);
        this.usedCount = Math.min((int)var1_2, this.argArray == null ? 0 : this.argArray.length);
    }

    /*
     * WARNING - void declaration
     */
    private void initThrowable(Object[] params, int usedParams) {
        int argCount;
        void var2_2;
        if (params != null && var2_2 < (argCount = params.length) && this.throwable == null && params[argCount - 1] instanceof Throwable) {
            void var3_3;
            void var1_1;
            this.throwable = (Throwable)var1_1[var3_3 - true];
        }
    }

    @Override
    public String getFormat() {
        return this.messagePattern;
    }

    @Override
    public Object[] getParameters() {
        return this.argArray;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            void var1_1;
            StringBuilder buffer = ParameterizedMessage.getThreadLocalStringBuilder();
            this.formatTo(buffer);
            this.formattedMessage = buffer.toString();
            StringBuilders.trimToMaxSize((StringBuilder)var1_1, Constants.MAX_REUSABLE_MESSAGE_SIZE);
        }
        return this.formattedMessage;
    }

    /*
     * WARNING - void declaration
     */
    private static StringBuilder getThreadLocalStringBuilder() {
        void var0;
        StringBuilder buffer = threadLocalStringBuilder.get();
        if (buffer == null) {
            buffer = new StringBuilder(255);
            threadLocalStringBuilder.set(buffer);
        }
        buffer.setLength(0);
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void formatTo(StringBuilder buffer) {
        void var1_1;
        if (this.formattedMessage != null) {
            buffer.append(this.formattedMessage);
            return;
        }
        if (this.indices[0] < 0) {
            ParameterFormatter.formatMessage(buffer, this.messagePattern, this.argArray, this.usedCount);
            return;
        }
        ParameterFormatter.formatMessage2((StringBuilder)var1_1, this.messagePattern, this.argArray, this.usedCount, this.indices);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(String messagePattern, Object[] arguments) {
        void var1_1;
        return ParameterFormatter.format(messagePattern, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedMessage that = (ParameterizedMessage)o;
        if (this.messagePattern != null ? !this.messagePattern.equals(that.messagePattern) : that.messagePattern != null) {
            return false;
        }
        return Arrays.equals(this.argArray, var1_1.argArray);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.messagePattern != null ? this.messagePattern.hashCode() : 0;
        var1_1 = var1_1 * 31 + (this.argArray != null ? Arrays.hashCode(this.argArray) : 0);
        return (int)var1_1;
    }

    public static int countArgumentPlaceholders(String messagePattern) {
        return ParameterFormatter.countArgumentPlaceholders(messagePattern);
    }

    public static String deepToString(Object o) {
        return ParameterFormatter.deepToString(o);
    }

    public static String identityToString(Object obj) {
        return ParameterFormatter.identityToString(obj);
    }

    public String toString() {
        return "ParameterizedMessage[messagePattern=" + this.messagePattern + ", stringArgs=" + Arrays.toString(this.argArray) + ", throwable=" + this.throwable + ']';
    }
}

