/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.util.StringBuilders;

final class ParameterFormatter {
    static final String RECURSION_PREFIX = "[...";
    static final String RECURSION_SUFFIX = "...]";
    static final String ERROR_PREFIX = "[!!!";
    static final String ERROR_SEPARATOR = "=>";
    static final String ERROR_MSG_SEPARATOR = ":";
    static final String ERROR_SUFFIX = "!!!]";
    private static final char DELIM_START = '{';
    private static final char DELIM_STOP = '}';
    private static final char ESCAPE_CHAR = '\\';
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZone(ZoneId.systemDefault());

    private ParameterFormatter() {
    }

    /*
     * WARNING - void declaration
     */
    static int countArgumentPlaceholders(String messagePattern) {
        void var2_2;
        if (messagePattern == null) {
            return 0;
        }
        int length = messagePattern.length();
        int result = 0;
        boolean isEscaped = false;
        for (int i = 0; i < length - 1; ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                isEscaped = !isEscaped;
                continue;
            }
            if (curChar == '{') {
                if (!isEscaped && messagePattern.charAt(i + 1) == '}') {
                    ++result;
                    ++i;
                }
                isEscaped = false;
                continue;
            }
            isEscaped = false;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int countArgumentPlaceholders2(String messagePattern, int[] indices) {
        void var3_3;
        if (messagePattern == null) {
            return 0;
        }
        int length = messagePattern.length();
        int result = 0;
        boolean isEscaped = false;
        for (int i = 0; i < length - 1; ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                isEscaped = !isEscaped;
                indices[0] = -1;
                ++result;
                continue;
            }
            if (curChar == '{') {
                if (!isEscaped && messagePattern.charAt(i + 1) == '}') {
                    indices[result] = i++;
                    ++result;
                }
                isEscaped = false;
                continue;
            }
            isEscaped = false;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static int countArgumentPlaceholders3(char[] messagePattern, int length, int[] indices) {
        void var3_3;
        int result = 0;
        boolean isEscaped = false;
        for (int i = 0; i < length - 1; ++i) {
            char curChar = messagePattern[i];
            if (curChar == '\\') {
                isEscaped = !isEscaped;
                continue;
            }
            if (curChar == '{') {
                if (!isEscaped && messagePattern[i + 1] == '}') {
                    indices[result] = i++;
                    ++result;
                }
                isEscaped = false;
                continue;
            }
            isEscaped = false;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static String format(String messagePattern, Object[] arguments) {
        void var2_2;
        void var3_3;
        void var1_1;
        String string;
        StringBuilder result = new StringBuilder();
        int argCount = arguments == null ? 0 : arguments.length;
        ParameterFormatter.formatMessage(result, string, (Object[])var1_1, (int)var3_3);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    static void formatMessage2(StringBuilder buffer, String messagePattern, Object[] arguments, int argCount, int[] indices) {
        void var1_1;
        StringBuilder stringBuilder;
        if (messagePattern == null || arguments == null || argCount == 0) {
            buffer.append(messagePattern);
            return;
        }
        int previous = 0;
        for (int i = 0; i < argCount; ++i) {
            buffer.append(messagePattern, previous, indices[i]);
            previous = indices[i] + 2;
            ParameterFormatter.recursiveDeepToString(arguments[i], buffer);
        }
        stringBuilder.append(messagePattern, previous, var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    static void formatMessage3(StringBuilder buffer, char[] messagePattern, int patternLength, Object[] arguments, int argCount, int[] indices) {
        void var2_2;
        void var1_1;
        StringBuilder stringBuilder;
        if (messagePattern == null) {
            return;
        }
        if (arguments == null || argCount == 0) {
            buffer.append(messagePattern);
            return;
        }
        int previous = 0;
        for (int i = 0; i < argCount; ++i) {
            buffer.append(messagePattern, previous, indices[i]);
            previous = indices[i] + 2;
            ParameterFormatter.recursiveDeepToString(arguments[i], buffer);
        }
        stringBuilder.append((char[])var1_1, previous, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static void formatMessage(StringBuilder buffer, String messagePattern, Object[] arguments, int argCount) {
        StringBuilder stringBuilder;
        void var1_1;
        int i;
        if (messagePattern == null || arguments == null || argCount == 0) {
            buffer.append(messagePattern);
            return;
        }
        int escapeCounter = 0;
        int currentArgument = 0;
        int len = messagePattern.length();
        for (i = 0; i < len - 1; ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                ++escapeCounter;
                continue;
            }
            if (ParameterFormatter.isDelimPair(curChar, messagePattern, i)) {
                ++i;
                ParameterFormatter.writeEscapedEscapeChars(escapeCounter, buffer);
                if (ParameterFormatter.isOdd(escapeCounter)) {
                    ParameterFormatter.writeDelimPair(buffer);
                } else {
                    ParameterFormatter.writeArgOrDelimPair(arguments, argCount, currentArgument, buffer);
                    ++currentArgument;
                }
            } else {
                ParameterFormatter.handleLiteralChar(buffer, escapeCounter, curChar);
            }
            escapeCounter = 0;
        }
        ParameterFormatter.handleRemainingCharIfAny((String)var1_1, len, stringBuilder, escapeCounter, i);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isDelimPair(char curChar, String messagePattern, int curCharIndex) {
        void var2_2;
        void var1_1;
        return curChar == '{' && var1_1.charAt((int)(var2_2 + true)) == '}';
    }

    /*
     * WARNING - void declaration
     */
    private static void handleRemainingCharIfAny(String messagePattern, int len, StringBuilder buffer, int escapeCounter, int i) {
        void var1_2;
        if (i == var1_2 - true) {
            void var0_1;
            void var3_4;
            void var2_3;
            char curChar = messagePattern.charAt(i);
            ParameterFormatter.handleLastChar((StringBuilder)var2_3, (int)var3_4, (char)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void handleLastChar(StringBuilder buffer, int escapeCounter, char curChar) {
        void var2_2;
        void var1_1;
        StringBuilder stringBuilder;
        if (curChar == '\\') {
            ParameterFormatter.writeUnescapedEscapeChars(escapeCounter + 1, buffer);
            return;
        }
        ParameterFormatter.handleLiteralChar(stringBuilder, (int)var1_1, (char)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void handleLiteralChar(StringBuilder buffer, int escapeCounter, char curChar) {
        void var2_2;
        StringBuilder stringBuilder;
        ParameterFormatter.writeUnescapedEscapeChars(escapeCounter, buffer);
        stringBuilder.append((char)var2_2);
    }

    private static void writeDelimPair(StringBuilder buffer) {
        StringBuilder stringBuilder;
        buffer.append('{');
        stringBuilder.append('}');
    }

    private static boolean isOdd(int number) {
        return (number & 1) == 1;
    }

    /*
     * WARNING - void declaration
     */
    private static void writeEscapedEscapeChars(int escapeCounter, StringBuilder buffer) {
        void var1_1;
        int n = escapeCounter >> 1;
        ParameterFormatter.writeUnescapedEscapeChars(n, (StringBuilder)var1_1);
    }

    private static void writeUnescapedEscapeChars(int escapeCounter, StringBuilder buffer) {
        while (escapeCounter > 0) {
            buffer.append('\\');
            --escapeCounter;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writeArgOrDelimPair(Object[] arguments, int argCount, int currentArgument, StringBuilder buffer) {
        void var3_3;
        void var1_1;
        if (currentArgument < var1_1) {
            void var2_2;
            Object[] objectArray;
            ParameterFormatter.recursiveDeepToString(objectArray[var2_2], buffer);
            return;
        }
        ParameterFormatter.writeDelimPair((StringBuilder)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static String deepToString(Object o) {
        void var1_1;
        Object object;
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Integer) {
            return Integer.toString((Integer)o);
        }
        if (o instanceof Long) {
            return Long.toString((Long)o);
        }
        if (o instanceof Double) {
            return Double.toString((Double)o);
        }
        if (o instanceof Boolean) {
            return Boolean.toString((Boolean)o);
        }
        if (o instanceof Character) {
            return Character.toString(((Character)o).charValue());
        }
        if (o instanceof Short) {
            return Short.toString((Short)o);
        }
        if (o instanceof Float) {
            return Float.toString(((Float)o).floatValue());
        }
        if (o instanceof Byte) {
            return Byte.toString((Byte)o);
        }
        StringBuilder str = new StringBuilder();
        ParameterFormatter.recursiveDeepToString(object, str);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    static void recursiveDeepToString(Object o, StringBuilder str) {
        void var1_1;
        ParameterFormatter.recursiveDeepToString(o, (StringBuilder)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void recursiveDeepToString(Object o, StringBuilder str, Set<Object> dejaVu) {
        void var1_1;
        Object object;
        if (ParameterFormatter.appendSpecialTypes(o, str)) {
            return;
        }
        if (ParameterFormatter.isMaybeRecursive(o)) {
            void var2_2;
            ParameterFormatter.appendPotentiallyRecursiveValue(o, str, (Set<Object>)var2_2);
            return;
        }
        ParameterFormatter.tryObjectToString(object, (StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean appendSpecialTypes(Object o, StringBuilder str) {
        void var1_1;
        Object object;
        return StringBuilders.appendSpecificTypes(str, o) || ParameterFormatter.appendDate(object, (StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean appendDate(Object o, StringBuilder str) {
        Object object;
        void var1_1;
        if (!(o instanceof Date)) {
            return false;
        }
        var1_1.append(DATE_FORMATTER.format(((Date)object).toInstant()));
        return true;
    }

    private static boolean isMaybeRecursive(Object o) {
        Object object;
        return o.getClass().isArray() || o instanceof Map || object instanceof Collection;
    }

    /*
     * WARNING - void declaration
     */
    private static void appendPotentiallyRecursiveValue(Object o, StringBuilder str, Set<Object> dejaVu) {
        void var3_3;
        Class<?> oClass = o.getClass();
        if (oClass.isArray()) {
            ParameterFormatter.appendArray(o, str, dejaVu, oClass);
            return;
        }
        if (o instanceof Map) {
            ParameterFormatter.appendMap(o, str, dejaVu);
            return;
        }
        if (o instanceof Collection) {
            void var2_2;
            void var1_1;
            Object object;
            ParameterFormatter.appendCollection(object, (StringBuilder)var1_1, (Set<Object>)var2_2);
            return;
        }
        throw new IllegalArgumentException("was expecting a container, found " + var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void appendArray(Object o, StringBuilder str, Set<Object> dejaVu, Class<?> oClass2) {
        void var1_1;
        Object[] objectArray;
        Object[] id;
        if (oClass2 == byte[].class) {
            str.append(Arrays.toString((byte[])o));
            return;
        }
        if (oClass2 == short[].class) {
            str.append(Arrays.toString((short[])o));
            return;
        }
        if (oClass2 == int[].class) {
            str.append(Arrays.toString((int[])o));
            return;
        }
        if (oClass2 == long[].class) {
            str.append(Arrays.toString((long[])o));
            return;
        }
        if (oClass2 == float[].class) {
            str.append(Arrays.toString((float[])o));
            return;
        }
        if (oClass2 == double[].class) {
            str.append(Arrays.toString((double[])o));
            return;
        }
        if (oClass2 == boolean[].class) {
            str.append(Arrays.toString((boolean[])o));
            return;
        }
        if (oClass2 == char[].class) {
            str.append(Arrays.toString((char[])o));
            return;
        }
        Set<Object> effectiveDejaVu = ParameterFormatter.getOrCreateDejaVu(dejaVu);
        boolean oClass2 = !effectiveDejaVu.add(o);
        if (oClass2) {
            id = ParameterFormatter.identityToString(o);
            str.append(RECURSION_PREFIX).append((String)id).append(RECURSION_SUFFIX);
            return;
        }
        Object[] oArray = id;
        str.append('[');
        boolean first = true;
        for (Object current : objectArray) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            ParameterFormatter.recursiveDeepToString(current, str, ParameterFormatter.cloneDejaVu(effectiveDejaVu));
        }
        var1_1.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void appendMap(Object o, StringBuilder str, Set<Object> dejaVu) {
        void var1_1;
        Iterator iterator;
        Iterator id;
        Set<Object> effectiveDejaVu = ParameterFormatter.getOrCreateDejaVu(dejaVu);
        boolean bl = !effectiveDejaVu.add(o);
        if (bl) {
            id = ParameterFormatter.identityToString(o);
            str.append(RECURSION_PREFIX).append((String)((Object)id)).append(RECURSION_SUFFIX);
            return;
        }
        Iterator oMap = (Map)((Object)id);
        str.append('{');
        boolean isFirst = true;
        iterator = iterator.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry current = entry = iterator.next();
            if (isFirst) {
                isFirst = false;
            } else {
                str.append(", ");
            }
            Object key = current.getKey();
            Object value = current.getValue();
            ParameterFormatter.recursiveDeepToString(key, str, ParameterFormatter.cloneDejaVu(effectiveDejaVu));
            str.append('=');
            ParameterFormatter.recursiveDeepToString(value, str, ParameterFormatter.cloneDejaVu(effectiveDejaVu));
        }
        var1_1.append('}');
    }

    /*
     * WARNING - void declaration
     */
    private static void appendCollection(Object o, StringBuilder str, Set<Object> dejaVu) {
        void var1_1;
        Iterator iterator;
        Iterator id;
        Set<Object> effectiveDejaVu = ParameterFormatter.getOrCreateDejaVu(dejaVu);
        boolean bl = !effectiveDejaVu.add(o);
        if (bl) {
            id = ParameterFormatter.identityToString(o);
            str.append(RECURSION_PREFIX).append((String)((Object)id)).append(RECURSION_SUFFIX);
            return;
        }
        Iterator oCol = (Collection)((Object)id);
        str.append('[');
        boolean isFirst = true;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object anOCol = iterator.next();
            if (isFirst) {
                isFirst = false;
            } else {
                str.append(", ");
            }
            ParameterFormatter.recursiveDeepToString(anOCol, str, ParameterFormatter.cloneDejaVu(effectiveDejaVu));
        }
        var1_1.append(']');
    }

    private static Set<Object> getOrCreateDejaVu(Set<Object> dejaVu) {
        Set<Object> set;
        if (dejaVu == null) {
            return ParameterFormatter.createDejaVu();
        }
        return set;
    }

    private static Set<Object> createDejaVu() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    /*
     * WARNING - void declaration
     */
    private static Set<Object> cloneDejaVu(Set<Object> dejaVu) {
        void var1_1;
        Set<Object> set;
        Set<Object> clonedDejaVu = ParameterFormatter.createDejaVu();
        clonedDejaVu.addAll(set);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static void tryObjectToString(Object o, StringBuilder str) {
        try {
            str.append(o.toString());
            return;
        }
        catch (Throwable t) {
            void var2_2;
            void var1_1;
            Object object;
            ParameterFormatter.handleErrorInObjectToString(object, (StringBuilder)var1_1, (Throwable)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void handleErrorInObjectToString(Object o, StringBuilder str, Throwable t) {
        void var1_1;
        void var2_2;
        str.append(ERROR_PREFIX);
        str.append(ParameterFormatter.identityToString(o));
        str.append(ERROR_SEPARATOR);
        Object msg = t.getMessage();
        String className = t.getClass().getName();
        str.append(className);
        if (!var2_2.equals(msg)) {
            Object object;
            str.append(ERROR_MSG_SEPARATOR);
            str.append((String)object);
        }
        var1_1.append(ERROR_SUFFIX);
    }

    static String identityToString(Object obj) {
        Object object;
        if (obj == null) {
            return null;
        }
        return obj.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }
}

