/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;

public class MessageFormatMessage
implements Message {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final long serialVersionUID = 1L;
    private static final int HASHVAL = 31;
    private String messagePattern;
    private transient Object[] parameters;
    private String[] serializedParameters;
    private transient String formattedMessage;
    private transient Throwable throwable;
    private final Locale locale;

    /*
     * WARNING - void declaration
     */
    public MessageFormatMessage(Locale locale, String messagePattern, Object ... parameters) {
        void var2_3;
        this.locale = locale;
        this.messagePattern = var2_3;
        this.parameters = parameters;
        int length = parameters == null ? 0 : parameters.length;
        if (length > 0 && parameters[length - 1] instanceof Throwable) {
            void var1_2;
            void var3_4;
            this.throwable = (Throwable)var3_4[var1_2 - true];
        }
    }

    /*
     * WARNING - void declaration
     */
    public MessageFormatMessage(String messagePattern, Object ... parameters) {
        this(Locale.getDefault(Locale.Category.FORMAT), (String)var1_1, (Object[])var2_2);
        void var2_2;
        void var1_1;
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            this.formattedMessage = this.formatMessage(this.messagePattern, this.parameters);
        }
        return this.formattedMessage;
    }

    @Override
    public String getFormat() {
        return this.messagePattern;
    }

    @Override
    public Object[] getParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        return this.serializedParameters;
    }

    /*
     * WARNING - void declaration
     */
    protected String formatMessage(String msgPattern, Object ... args) {
        try {
            void var2_2;
            MessageFormat messageFormat = new MessageFormat(msgPattern, this.locale);
            return messageFormat.format(var2_2);
        }
        catch (IllegalFormatException ife) {
            void var1_1;
            void var3_4;
            LOGGER.error("Unable to format msg: " + msgPattern, (Throwable)var3_4);
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageFormatMessage that = (MessageFormatMessage)o;
        if (this.messagePattern != null ? !this.messagePattern.equals(that.messagePattern) : that.messagePattern != null) {
            return false;
        }
        return Arrays.equals(this.serializedParameters, var1_1.serializedParameters);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.messagePattern != null ? this.messagePattern.hashCode() : 0;
        var1_1 = var1_1 * 31 + (this.serializedParameters != null ? Arrays.hashCode(this.serializedParameters) : 0);
        return (int)var1_1;
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getFormattedMessage();
        out.writeUTF(this.formattedMessage);
        out.writeUTF(this.messagePattern);
        int length = this.parameters == null ? 0 : this.parameters.length;
        out.writeInt(length);
        this.serializedParameters = new String[length];
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                this.serializedParameters[i] = String.valueOf(this.parameters[i]);
                out.writeUTF(this.serializedParameters[i]);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.parameters = null;
        this.throwable = null;
        this.formattedMessage = in.readUTF();
        this.messagePattern = in.readUTF();
        int length = in.readInt();
        this.serializedParameters = new String[length];
        for (int i = 0; i < length; ++i) {
            this.serializedParameters[i] = in.readUTF();
        }
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }
}

