/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.util.IndexedStringMap;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;

enum MapMessageJsonFormatter {

    public static final int MAX_DEPTH = MapMessageJsonFormatter.readMaxDepth();
    private static final char DQUOTE = '\"';
    private static final char RBRACE = ']';
    private static final char LBRACE = '[';
    private static final char COMMA = ',';
    private static final char RCURLY = '}';
    private static final char LCURLY = '{';
    private static final char COLON = ':';

    /*
     * WARNING - void declaration
     */
    private static int readMaxDepth() {
        void var0;
        int maxDepth = PropertiesUtil.getProperties().getIntegerProperty("log4j2.mapMessage.jsonFormatter.maxDepth", 8);
        if (maxDepth < 0) {
            throw new IllegalArgumentException("was expecting a positive maxDepth, found: " + maxDepth);
        }
        return (int)var0;
    }

    /*
     * WARNING - void declaration
     */
    static void format(StringBuilder sb, Object object) {
        void var1_1;
        MapMessageJsonFormatter.format(sb, var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static void format(StringBuilder sb, Object object, int depth) {
        StringBuilder stringBuilder;
        void var1_1;
        double[] doubleValues;
        float[] floatValues;
        long[] longValues;
        int[] intValues;
        short[] shortValues;
        byte[] byteValues;
        boolean[] booleanValues;
        char[] charValues;
        StringBuilderFormattable formattable;
        void booleanValue2;
        Number number;
        Collection collection;
        List list;
        Object map;
        if (depth >= MAX_DEPTH) {
            throw new IllegalArgumentException("maxDepth has been exceeded");
        }
        if (object == null) {
            sb.append("null");
            return;
        }
        if (object instanceof IndexedStringMap) {
            map = (IndexedStringMap)object;
            MapMessageJsonFormatter.formatIndexedStringMap(sb, (IndexedStringMap)map, depth);
            return;
        }
        if (map instanceof Map) {
            map = (Map)map;
            MapMessageJsonFormatter.formatMap(sb, (Map<Object, Object>)map, depth);
            return;
        }
        if (map instanceof List) {
            list = (List)map;
            MapMessageJsonFormatter.formatList(sb, list, depth);
            return;
        }
        if (list instanceof Collection) {
            collection = list;
            MapMessageJsonFormatter.formatCollection(sb, collection, depth);
            return;
        }
        if (collection instanceof Number) {
            number = (Number)((Object)collection);
            MapMessageJsonFormatter.formatNumber(sb, number);
            return;
        }
        if (number instanceof Boolean) {
            boolean booleanValue2 = (Boolean)((Object)number);
            MapMessageJsonFormatter.formatBoolean(sb, booleanValue2);
            return;
        }
        if (booleanValue2 instanceof StringBuilderFormattable) {
            formattable = (StringBuilderFormattable)booleanValue2;
            MapMessageJsonFormatter.formatFormattable(sb, formattable);
            return;
        }
        if (formattable instanceof char[]) {
            charValues = (char[])formattable;
            MapMessageJsonFormatter.formatCharArray(sb, charValues);
            return;
        }
        if (charValues instanceof boolean[]) {
            booleanValues = (boolean[])charValues;
            MapMessageJsonFormatter.formatBooleanArray(sb, booleanValues);
            return;
        }
        if (booleanValues instanceof byte[]) {
            byteValues = (byte[])booleanValues;
            MapMessageJsonFormatter.formatByteArray(sb, byteValues);
            return;
        }
        if (byteValues instanceof short[]) {
            shortValues = byteValues;
            MapMessageJsonFormatter.formatShortArray(sb, shortValues);
            return;
        }
        if (shortValues instanceof int[]) {
            intValues = shortValues;
            MapMessageJsonFormatter.formatIntArray(sb, intValues);
            return;
        }
        if (intValues instanceof long[]) {
            longValues = intValues;
            MapMessageJsonFormatter.formatLongArray(sb, longValues);
            return;
        }
        if (longValues instanceof float[]) {
            floatValues = longValues;
            MapMessageJsonFormatter.formatFloatArray(sb, floatValues);
            return;
        }
        if (floatValues instanceof double[]) {
            doubleValues = floatValues;
            MapMessageJsonFormatter.formatDoubleArray(sb, doubleValues);
            return;
        }
        if (doubleValues instanceof Object[]) {
            void var2_3;
            Object[] objectValues = doubleValues;
            MapMessageJsonFormatter.formatObjectArray(sb, (Object[])var1_1, (int)var2_3);
            return;
        }
        MapMessageJsonFormatter.formatString(stringBuilder, var1_1);
    }

    private static void formatIndexedStringMap(StringBuilder sb, IndexedStringMap map, int depth) {
        StringBuilder stringBuilder;
        sb.append('{');
        int nextDepth = depth + 1;
        for (int entryIndex = 0; entryIndex < map.size(); ++entryIndex) {
            String key = map.getKeyAt(entryIndex);
            Object value = map.getValueAt(entryIndex);
            if (entryIndex > 0) {
                sb.append(',');
            }
            sb.append('\"');
            int keyStartIndex = sb.length();
            sb.append(key);
            StringBuilders.escapeJson(sb, keyStartIndex);
            sb.append('\"').append(':');
            MapMessageJsonFormatter.format(sb, value, nextDepth);
        }
        stringBuilder.append('}');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatMap(StringBuilder sb, Map<Object, Object> map, int depth) {
        StringBuilder stringBuilder;
        void var2_2;
        void var3_3;
        void var1_1;
        sb.append('{');
        int nextDepth = depth + 1;
        boolean[] firstEntry = new boolean[]{true};
        var1_1.forEach((arg_0, arg_1) -> MapMessageJsonFormatter.lambda$formatMap$0((boolean[])var3_3, sb, (int)var2_2, arg_0, arg_1));
        stringBuilder.append('}');
    }

    private static void formatList(StringBuilder sb, List<Object> items, int depth) {
        StringBuilder stringBuilder;
        sb.append('[');
        int nextDepth = depth + 1;
        for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
            if (itemIndex > 0) {
                sb.append(',');
            }
            Object item = items.get(itemIndex);
            MapMessageJsonFormatter.format(sb, item, nextDepth);
        }
        stringBuilder.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatCollection(StringBuilder sb, Collection<Object> items, int depth) {
        StringBuilder stringBuilder;
        void var2_2;
        void var3_3;
        void var1_1;
        sb.append('[');
        int nextDepth = depth + 1;
        boolean[] firstItem = new boolean[]{true};
        var1_1.forEach(arg_0 -> MapMessageJsonFormatter.lambda$formatCollection$1((boolean[])var3_3, sb, (int)var2_2, arg_0));
        stringBuilder.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatNumber(StringBuilder sb, Number number) {
        StringBuilder stringBuilder;
        void var1_1;
        double doubleValue;
        if (number instanceof BigDecimal) {
            BigDecimal decimalNumber = (BigDecimal)number;
            sb.append(decimalNumber.toString());
            return;
        }
        if (number instanceof Double) {
            double doubleNumber = (Double)number;
            sb.append(doubleNumber);
            return;
        }
        if (number instanceof Float) {
            float floatNumber = ((Float)number).floatValue();
            sb.append(floatNumber);
            return;
        }
        if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            long longNumber = number.longValue();
            sb.append(longNumber);
            return;
        }
        long longNumber = number.longValue();
        if (Double.compare(longNumber, doubleValue = var1_1.doubleValue()) == 0) {
            void var2_6;
            sb.append((long)var2_6);
            return;
        }
        stringBuilder.append(doubleValue);
    }

    /*
     * WARNING - void declaration
     */
    private static void formatBoolean(StringBuilder sb, boolean booleanValue) {
        void var1_1;
        sb.append((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void formatFormattable(StringBuilder sb, StringBuilderFormattable formattable) {
        StringBuilder stringBuilder;
        void var2_2;
        void var1_1;
        sb.append('\"');
        int startIndex = sb.length();
        var1_1.formatTo(sb);
        StringBuilders.escapeJson(sb, (int)var2_2);
        stringBuilder.append('\"');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatCharArray(StringBuilder sb, char[] items) {
        StringBuilder stringBuilder;
        sb.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            void var3_3;
            if (itemIndex > 0) {
                sb.append(',');
            }
            char item = items[itemIndex];
            sb.append('\"');
            int startIndex = sb.length();
            sb.append((char)var3_3);
            StringBuilders.escapeJson(sb, startIndex);
            sb.append('\"');
        }
        stringBuilder.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatBooleanArray(StringBuilder sb, boolean[] items) {
        StringBuilder stringBuilder;
        sb.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            void var3_3;
            if (itemIndex > 0) {
                sb.append(',');
            }
            boolean item = items[itemIndex];
            sb.append((boolean)var3_3);
        }
        stringBuilder.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatByteArray(StringBuilder sb, byte[] items) {
        StringBuilder stringBuilder;
        sb.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            void var3_3;
            if (itemIndex > 0) {
                sb.append(',');
            }
            byte item = items[itemIndex];
            sb.append((int)var3_3);
        }
        stringBuilder.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatShortArray(StringBuilder sb, short[] items) {
        StringBuilder stringBuilder;
        sb.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            void var3_3;
            if (itemIndex > 0) {
                sb.append(',');
            }
            short item = items[itemIndex];
            sb.append((int)var3_3);
        }
        stringBuilder.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatIntArray(StringBuilder sb, int[] items) {
        StringBuilder stringBuilder;
        sb.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            void var3_3;
            if (itemIndex > 0) {
                sb.append(',');
            }
            int item = items[itemIndex];
            sb.append((int)var3_3);
        }
        stringBuilder.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatLongArray(StringBuilder sb, long[] items) {
        StringBuilder stringBuilder;
        sb.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            void var3_3;
            if (itemIndex > 0) {
                sb.append(',');
            }
            long item = items[itemIndex];
            sb.append((long)var3_3);
        }
        stringBuilder.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatFloatArray(StringBuilder sb, float[] items) {
        StringBuilder stringBuilder;
        sb.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            void var3_3;
            if (itemIndex > 0) {
                sb.append(',');
            }
            float item = items[itemIndex];
            sb.append((float)var3_3);
        }
        stringBuilder.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatDoubleArray(StringBuilder sb, double[] items) {
        StringBuilder stringBuilder;
        sb.append('[');
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            void var3_3;
            if (itemIndex > 0) {
                sb.append(',');
            }
            double item = items[itemIndex];
            sb.append((double)var3_3);
        }
        stringBuilder.append(']');
    }

    private static void formatObjectArray(StringBuilder sb, Object[] items, int depth) {
        StringBuilder stringBuilder;
        sb.append('[');
        int nextDepth = depth + 1;
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            if (itemIndex > 0) {
                sb.append(',');
            }
            Object item = items[itemIndex];
            MapMessageJsonFormatter.format(sb, item, nextDepth);
        }
        stringBuilder.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void formatString(StringBuilder sb, Object value) {
        StringBuilder stringBuilder;
        void var2_2;
        void var1_1;
        sb.append('\"');
        int startIndex = sb.length();
        String valueString = String.valueOf(value);
        sb.append((String)var1_1);
        StringBuilders.escapeJson(sb, (int)var2_2);
        stringBuilder.append('\"');
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$formatCollection$1(boolean[] firstItem, StringBuilder sb, int nextDepth, Object item) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (firstItem[0]) {
            var0[0] = false;
        } else {
            sb.append(',');
        }
        MapMessageJsonFormatter.format((StringBuilder)var1_1, var3_3, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$formatMap$0(boolean[] firstEntry, StringBuilder sb, int nextDepth, Object key, Object value) {
        void var2_2;
        void var1_1;
        void var3_4;
        Object object;
        if (key == null) {
            throw new IllegalArgumentException("null keys are not allowed");
        }
        if (firstEntry[0]) {
            firstEntry[0] = false;
        } else {
            sb.append(',');
        }
        sb.append('\"');
        Object keyString = String.valueOf(key);
        int keyStartIndex = sb.length();
        sb.append((String)object);
        StringBuilders.escapeJson(sb, (int)var3_4);
        sb.append('\"').append(':');
        MapMessageJsonFormatter.format((StringBuilder)var1_1, value, (int)var2_2);
    }
}

