/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.MapMessageJsonFormatter;
import org.apache.logging.log4j.message.ParameterFormatter;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.IndexedStringMap;
import org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.TriConsumer;

@AsynchronouslyFormattable
@PerformanceSensitive(value={"allocation"})
public class MapMessage<M extends MapMessage<M, V>, V>
implements MultiFormatStringBuilderFormattable {
    private static final long serialVersionUID = -5031471831131487120L;
    private final IndexedStringMap data;

    public MapMessage() {
        this.data = new SortedArrayStringMap();
    }

    /*
     * WARNING - void declaration
     */
    public MapMessage(int initialCapacity) {
        void var1_1;
        this.data = new SortedArrayStringMap((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MapMessage(Map<String, V> map) {
        void var1_1;
        this.data = new SortedArrayStringMap((Map<String, ?>)var1_1);
    }

    @Override
    public String[] getFormats() {
        return MapFormat.names();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object[] getParameters() {
        void var1_1;
        Object[] result = new Object[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            result[i] = this.data.getValueAt(i);
        }
        return var1_1;
    }

    @Override
    public String getFormat() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, V> getData() {
        void var1_1;
        TreeMap result = new TreeMap();
        for (int i = 0; i < this.data.size(); ++i) {
            result.put(this.data.getKeyAt(i), this.data.getValueAt(i));
        }
        return Collections.unmodifiableMap(var1_1);
    }

    public IndexedReadOnlyStringMap getIndexedReadOnlyStringMap() {
        return this.data;
    }

    public void clear() {
        this.data.clear();
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(String key) {
        void var1_1;
        return this.data.containsKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void put(String candidateKey, String value) {
        void var2_2;
        void var1_1;
        if (value == null) {
            throw new IllegalArgumentException("No value provided for key " + candidateKey);
        }
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putAll(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            void var2_2;
            this.data.putValue(entry.getKey(), var2_2.getValue());
        }
    }

    public String get(String key) {
        Object v;
        v = this.data.getValue((String)v);
        return ParameterFormatter.deepToString(v);
    }

    /*
     * WARNING - void declaration
     */
    public String remove(String key) {
        void var2_2;
        void var1_1;
        String result = this.get(key);
        this.data.remove((String)var1_1);
        return var2_2;
    }

    public String asString() {
        return this.format(null, new StringBuilder()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public String asString(String format) {
        try {
            void var1_1;
            return this.format(EnglishEnums.valueOf(MapFormat.class, (String)var1_1), new StringBuilder()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.asString();
        }
    }

    /*
     * WARNING - void declaration
     */
    public <CV> void forEach(BiConsumer<String, ? super CV> action) {
        void var1_1;
        this.data.forEach(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <CV, S> void forEach(TriConsumer<String, ? super CV, S> action, S state) {
        void var2_2;
        void var1_1;
        this.data.forEach(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private StringBuilder format(MapFormat format, StringBuilder sb) {
        void var2_2;
        if (format != null) {
            void var1_1;
            switch (1.$SwitchMap$org$apache$logging$log4j$message$MapMessage$MapFormat[var1_1.ordinal()]) {
                case 1: {
                    this.asXml(sb);
                    return var2_2;
                }
                case 2: {
                    this.asJson(sb);
                    return var2_2;
                }
                case 3: {
                    this.asJava(sb);
                    return var2_2;
                }
                case 4: {
                    this.asJavaUnquoted(sb);
                    return var2_2;
                }
            }
        }
        this.appendMap(sb);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void asXml(StringBuilder sb) {
        void var1_1;
        sb.append("<Map>\n");
        for (int i = 0; i < this.data.size(); ++i) {
            void var3_3;
            sb.append("  <Entry key=\"").append(this.data.getKeyAt(i)).append("\">");
            int size = sb.length();
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), sb);
            StringBuilders.escapeXml(sb, (int)var3_3);
            sb.append("</Entry>\n");
        }
        var1_1.append("</Map>");
    }

    @Override
    public String getFormattedMessage() {
        return this.asString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedMessage(String[] formats) {
        void var1_1;
        MapMessage mapMessage = this;
        return mapMessage.format(mapMessage.getFormat((String[])var1_1), new StringBuilder()).toString();
    }

    /*
     * WARNING - void declaration
     */
    private MapFormat getFormat(String[] formats) {
        if (formats == null || formats.length == 0) {
            return null;
        }
        for (int i = 0; i < formats.length; ++i) {
            void var3_3;
            MapFormat mapFormat = MapFormat.lookupIgnoreCase(formats[i]);
            if (mapFormat == null) continue;
            return var3_3;
        }
        return null;
    }

    protected void appendMap(StringBuilder sb) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(this.data.getKeyAt(i)).append('=').append('\"');
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), sb);
            sb.append('\"');
        }
    }

    protected void asJson(StringBuilder sb) {
        MapMessageJsonFormatter.format(sb, this.data);
    }

    /*
     * WARNING - void declaration
     */
    protected void asJavaUnquoted(StringBuilder sb) {
        void var1_1;
        this.asJava((StringBuilder)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    protected void asJava(StringBuilder sb) {
        void var1_1;
        this.asJava((StringBuilder)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private void asJava(StringBuilder sb, boolean quoted) {
        void var1_1;
        sb.append('{');
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.data.getKeyAt(i)).append('=');
            if (quoted) {
                sb.append('\"');
            }
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), sb);
            if (!quoted) continue;
            sb.append('\"');
        }
        var1_1.append('}');
    }

    /*
     * WARNING - void declaration
     */
    public M newInstance(Map<String, V> map) {
        void var1_1;
        return (M)new MapMessage<M, V>(var1_1);
    }

    public String toString() {
        return this.asString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void formatTo(StringBuilder buffer) {
        void var1_1;
        this.format(null, (StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void formatTo(String[] formats, StringBuilder buffer) {
        void var2_2;
        void var1_1;
        MapMessage mapMessage = this;
        mapMessage.format(mapMessage.getFormat((String[])var1_1), (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapMessage that = (MapMessage)o;
        return this.data.equals(var1_1.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    protected void validate(String key, boolean value) {
    }

    protected void validate(String key, byte value) {
    }

    protected void validate(String key, char value) {
    }

    protected void validate(String key, double value) {
    }

    protected void validate(String key, float value) {
    }

    protected void validate(String key, int value) {
    }

    protected void validate(String key, long value) {
    }

    protected void validate(String key, Object value) {
    }

    protected void validate(String key, short value) {
    }

    protected void validate(String key, String value) {
    }

    protected String toKey(String candidateKey) {
        return candidateKey;
    }

    /*
     * WARNING - void declaration
     */
    public M with(String candidateKey, boolean value) {
        void var2_2;
        void var1_1;
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue((String)var1_1, (boolean)var2_2);
        return (M)this;
    }

    /*
     * WARNING - void declaration
     */
    public M with(String candidateKey, byte value) {
        void var2_2;
        void var1_1;
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue((String)var1_1, (byte)var2_2);
        return (M)this;
    }

    /*
     * WARNING - void declaration
     */
    public M with(String candidateKey, char value) {
        void var2_2;
        void var1_1;
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue((String)var1_1, Character.valueOf((char)var2_2));
        return (M)this;
    }

    /*
     * WARNING - void declaration
     */
    public M with(String candidateKey, double value) {
        void var2_2;
        void var1_1;
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue((String)var1_1, (double)var2_2);
        return (M)this;
    }

    /*
     * WARNING - void declaration
     */
    public M with(String candidateKey, float value) {
        void var2_2;
        void var1_1;
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue((String)var1_1, Float.valueOf((float)var2_2));
        return (M)this;
    }

    /*
     * WARNING - void declaration
     */
    public M with(String candidateKey, int value) {
        void var2_2;
        void var1_1;
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue((String)var1_1, (int)var2_2);
        return (M)this;
    }

    /*
     * WARNING - void declaration
     */
    public M with(String candidateKey, long value) {
        void var2_2;
        void var1_1;
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue((String)var1_1, (long)var2_2);
        return (M)this;
    }

    /*
     * WARNING - void declaration
     */
    public M with(String candidateKey, Object value) {
        void var2_2;
        void var1_1;
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue((String)var1_1, var2_2);
        return (M)this;
    }

    /*
     * WARNING - void declaration
     */
    public M with(String candidateKey, short value) {
        void var2_2;
        void var1_1;
        String key = this.toKey(candidateKey);
        this.validate(key, value);
        this.data.putValue((String)var1_1, (short)var2_2);
        return (M)this;
    }

    /*
     * WARNING - void declaration
     */
    public M with(String candidateKey, String value) {
        void var2_2;
        void var1_1;
        String key = this.toKey(candidateKey);
        this.put((String)var1_1, (String)var2_2);
        return (M)this;
    }

    public static enum MapFormat {
        XML,
        JSON,
        JAVA,
        JAVA_UNQUOTED;


        public static MapFormat lookupIgnoreCase(String format) {
            String string;
            if (XML.name().equalsIgnoreCase(format)) {
                return XML;
            }
            if (JSON.name().equalsIgnoreCase(format)) {
                return JSON;
            }
            if (JAVA.name().equalsIgnoreCase(format)) {
                return JAVA;
            }
            if (JAVA_UNQUOTED.name().equalsIgnoreCase(string)) {
                return JAVA_UNQUOTED;
            }
            return null;
        }

        public static String[] names() {
            return new String[]{XML.name(), JSON.name(), JAVA.name(), JAVA_UNQUOTED.name()};
        }
    }
}

