/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.LoggerNameAwareMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;

public class LocalizedMessage
implements LoggerNameAwareMessage,
Message {
    private static final long serialVersionUID = 3893703791567290742L;
    private String baseName;
    private transient ResourceBundle resourceBundle;
    private final Locale locale;
    private transient StatusLogger logger = StatusLogger.getLogger();
    private String loggerName;
    private String key;
    private String[] stringArgs;
    private transient Object[] argArray;
    private String formattedMessage;
    private transient Throwable throwable;

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(String messagePattern, Object[] arguments) {
        this((ResourceBundle)null, (Locale)null, (String)var1_1, (Object[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(String baseName, String key, Object[] arguments) {
        this((String)var1_1, (Locale)null, (String)var2_2, (Object[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(ResourceBundle bundle, String key, Object[] arguments) {
        this((ResourceBundle)var1_1, (Locale)null, (String)var2_2, (Object[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(String baseName, Locale locale, String key, Object[] arguments) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.key = var3_3;
        this.argArray = arguments;
        this.throwable = null;
        this.baseName = var1_1;
        this.resourceBundle = null;
        this.locale = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(ResourceBundle bundle, Locale locale, String key, Object[] arguments) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.key = var3_3;
        this.argArray = arguments;
        this.throwable = null;
        this.baseName = null;
        this.resourceBundle = var1_1;
        this.locale = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(Locale locale, String key, Object[] arguments) {
        this((ResourceBundle)null, (Locale)var1_1, (String)var2_2, (Object[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(String messagePattern, Object arg) {
        this((ResourceBundle)null, (Locale)null, (String)var1_1, new Object[]{var2_2});
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(String baseName, String key, Object arg) {
        this((String)var1_1, (Locale)null, (String)var2_2, new Object[]{var3_3});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(ResourceBundle bundle, String key) {
        this((ResourceBundle)var1_1, (Locale)null, (String)var2_2, new Object[0]);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(ResourceBundle bundle, String key, Object arg) {
        this((ResourceBundle)var1_1, (Locale)null, (String)var2_2, new Object[]{var3_3});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(String baseName, Locale locale, String key, Object arg) {
        this((String)var1_1, (Locale)var2_2, (String)var3_3, new Object[]{arg});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(ResourceBundle bundle, Locale locale, String key, Object arg) {
        this((ResourceBundle)var1_1, (Locale)var2_2, (String)var3_3, new Object[]{arg});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(Locale locale, String key, Object arg) {
        this((ResourceBundle)null, (Locale)var1_1, (String)var2_2, new Object[]{var3_3});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(String messagePattern, Object arg1, Object arg2) {
        this((ResourceBundle)null, (Locale)null, (String)var1_1, new Object[]{var2_2, var3_3});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(String baseName, String key, Object arg1, Object arg2) {
        this((String)var1_1, (Locale)null, (String)var2_2, new Object[]{var3_3, arg2});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(ResourceBundle bundle, String key, Object arg1, Object arg2) {
        this((ResourceBundle)var1_1, (Locale)null, (String)var2_2, new Object[]{var3_3, arg2});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(String baseName, Locale locale, String key, Object arg1, Object arg2) {
        this((String)var1_1, (Locale)var2_2, (String)var3_3, new Object[]{arg1, arg2});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(ResourceBundle bundle, Locale locale, String key, Object arg1, Object arg2) {
        this((ResourceBundle)var1_1, (Locale)var2_2, (String)var3_3, new Object[]{arg1, arg2});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocalizedMessage(Locale locale, String key, Object arg1, Object arg2) {
        this((ResourceBundle)null, (Locale)var1_1, (String)var2_2, new Object[]{var3_3, arg2});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLoggerName(String name) {
        void var1_1;
        this.loggerName = var1_1;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedMessage() {
        void var1_1;
        void var2_2;
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        ResourceBundle bundle = this.resourceBundle;
        if (bundle == null) {
            if (this.baseName != null) {
                LocalizedMessage localizedMessage = this;
                bundle = localizedMessage.getResourceBundle(localizedMessage.baseName, this.locale, false);
            } else {
                LocalizedMessage localizedMessage = this;
                bundle = localizedMessage.getResourceBundle(localizedMessage.loggerName, this.locale, true);
            }
        }
        String myKey = this.getFormat();
        String msgPattern = bundle == null || !bundle.containsKey(myKey) ? myKey : bundle.getString(myKey);
        Object[] array = this.argArray == null ? this.stringArgs : this.argArray;
        FormattedMessage msg = new FormattedMessage(msgPattern, (Object[])var2_2);
        this.formattedMessage = msg.getFormattedMessage();
        this.throwable = var1_1.getThrowable();
        return this.formattedMessage;
    }

    @Override
    public String getFormat() {
        return this.key;
    }

    @Override
    public Object[] getParameters() {
        if (this.argArray != null) {
            return this.argArray;
        }
        return this.stringArgs;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    /*
     * WARNING - void declaration
     */
    protected ResourceBundle getResourceBundle(String rbBaseName, Locale resourceBundleLocale, boolean loop) {
        String substr;
        int i;
        ResourceBundle rb;
        block7: {
            rb = null;
            if (rbBaseName == null) {
                return null;
            }
            try {
                rb = resourceBundleLocale != null ? ResourceBundle.getBundle(rbBaseName, resourceBundleLocale) : ResourceBundle.getBundle(rbBaseName);
            }
            catch (MissingResourceException missingResourceException) {
                if (loop) break block7;
                this.logger.debug("Unable to locate ResourceBundle " + rbBaseName);
                return null;
            }
        }
        while (rb == null && (i = substr.lastIndexOf(46)) > 0) {
            void var3_3;
            substr = substr.substring(0, (int)var3_3);
            try {
                if (resourceBundleLocale != null) {
                    rb = ResourceBundle.getBundle(substr, resourceBundleLocale);
                    continue;
                }
                rb = ResourceBundle.getBundle(substr);
            }
            catch (MissingResourceException missingResourceException) {
                this.logger.debug("Unable to locate ResourceBundle " + substr);
            }
        }
        return rb;
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        void var1_1;
        out.defaultWriteObject();
        this.getFormattedMessage();
        out.writeUTF(this.formattedMessage);
        out.writeUTF(this.key);
        out.writeUTF(this.baseName);
        out.writeInt(this.argArray.length);
        this.stringArgs = new String[this.argArray.length];
        int i = 0;
        Object[] objectArray = this.argArray;
        int n = this.argArray.length;
        for (int j = 0; j < n; ++j) {
            Object obj = objectArray[j];
            this.stringArgs[i] = obj.toString();
            ++i;
        }
        var1_1.writeObject(this.stringArgs);
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        void var1_1;
        in.defaultReadObject();
        this.formattedMessage = in.readUTF();
        this.key = in.readUTF();
        this.baseName = in.readUTF();
        in.readInt();
        this.stringArgs = (String[])var1_1.readObject();
        this.logger = StatusLogger.getLogger();
        this.resourceBundle = null;
        this.argArray = null;
    }
}

