/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFormatMessage;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.StringFormattedMessage;

public class FormattedMessage
implements Message {
    private static final long serialVersionUID = -665975803997290697L;
    private static final int HASHVAL = 31;
    private static final String FORMAT_SPECIFIER = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern MSG_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private String messagePattern;
    private transient Object[] argArray;
    private String[] stringArgs;
    private transient String formattedMessage;
    private final Throwable throwable;
    private Message message;
    private final Locale locale;

    /*
     * WARNING - void declaration
     */
    public FormattedMessage(Locale locale, String messagePattern, Object arg) {
        this((Locale)var1_1, (String)var2_2, new Object[]{var3_3}, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FormattedMessage(Locale locale, String messagePattern, Object arg1, Object arg2) {
        this((Locale)var1_1, (String)var2_2, new Object[]{var3_3, arg2});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FormattedMessage(Locale locale, String messagePattern, Object ... arguments) {
        this((Locale)var1_1, (String)var2_2, (Object[])var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FormattedMessage(Locale locale, String messagePattern, Object[] arguments, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.locale = var1_1;
        this.messagePattern = var2_2;
        this.argArray = var3_3;
        this.throwable = throwable;
    }

    /*
     * WARNING - void declaration
     */
    public FormattedMessage(String messagePattern, Object arg) {
        this((String)var1_1, new Object[]{var2_2}, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FormattedMessage(String messagePattern, Object arg1, Object arg2) {
        this((String)var1_1, new Object[]{var2_2, var3_3});
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FormattedMessage(String messagePattern, Object ... arguments) {
        this((String)var1_1, (Object[])var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FormattedMessage(String messagePattern, Object[] arguments, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.locale = Locale.getDefault(Locale.Category.FORMAT);
        this.messagePattern = var1_1;
        this.argArray = var2_2;
        this.throwable = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormattedMessage that = (FormattedMessage)o;
        if (this.messagePattern != null ? !this.messagePattern.equals(that.messagePattern) : that.messagePattern != null) {
            return false;
        }
        return Arrays.equals(this.stringArgs, var1_1.stringArgs);
    }

    @Override
    public String getFormat() {
        return this.messagePattern;
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            if (this.message == null) {
                this.message = this.getMessage(this.messagePattern, this.argArray, this.throwable);
            }
            this.formattedMessage = this.message.getFormattedMessage();
        }
        return this.formattedMessage;
    }

    /*
     * WARNING - void declaration
     */
    protected Message getMessage(String msgPattern, Object[] args, Throwable aThrowable) {
        void var3_3;
        void var2_2;
        void var1_1;
        try {
            MessageFormat messageFormat = new MessageFormat(msgPattern);
            Format[] formats = messageFormat.getFormats();
            if (formats != null && formats.length > 0) {
                return new MessageFormatMessage(this.locale, msgPattern, args);
            }
        }
        catch (Exception exception) {}
        try {
            if (MSG_PATTERN.matcher(msgPattern).find()) {
                return new StringFormattedMessage(this.locale, msgPattern, args);
            }
        }
        catch (Exception exception) {}
        return new ParameterizedMessage((String)var1_1, (Object[])var2_2, (Throwable)var3_3);
    }

    @Override
    public Object[] getParameters() {
        if (this.argArray != null) {
            return this.argArray;
        }
        return this.stringArgs;
    }

    @Override
    public Throwable getThrowable() {
        if (this.throwable != null) {
            return this.throwable;
        }
        if (this.message == null) {
            this.message = this.getMessage(this.messagePattern, this.argArray, null);
        }
        return this.message.getThrowable();
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.messagePattern != null ? this.messagePattern.hashCode() : 0;
        var1_1 = var1_1 * 31 + (this.stringArgs != null ? Arrays.hashCode(this.stringArgs) : 0);
        return (int)var1_1;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.formattedMessage = in.readUTF();
        this.messagePattern = in.readUTF();
        int length = in.readInt();
        this.stringArgs = new String[length];
        for (int i = 0; i < length; ++i) {
            this.stringArgs[i] = in.readUTF();
        }
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.getFormattedMessage();
        out.writeUTF(this.formattedMessage);
        out.writeUTF(this.messagePattern);
        out.writeInt(this.argArray.length);
        this.stringArgs = new String[this.argArray.length];
        int i = 0;
        Object[] objectArray = this.argArray;
        int n = this.argArray.length;
        for (int j = 0; j < n; ++j) {
            String string;
            Object object = objectArray[j];
            this.stringArgs[i] = string = String.valueOf(object);
            out.writeUTF(string);
            ++i;
        }
    }
}

