/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.ExitMessage;
import org.apache.logging.log4j.message.FlowMessage;
import org.apache.logging.log4j.message.FlowMessageFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.Strings;

public class DefaultFlowMessageFactory
implements Serializable,
FlowMessageFactory {
    private static final String EXIT_DEFAULT_PREFIX = "Exit";
    private static final String ENTRY_DEFAULT_PREFIX = "Enter";
    private static final long serialVersionUID = 8578655591131397576L;
    private final String entryText;
    private final String exitText;
    private final MessageFactory messageFactory;

    public DefaultFlowMessageFactory() {
        this(ENTRY_DEFAULT_PREFIX, EXIT_DEFAULT_PREFIX);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultFlowMessageFactory(String entryText, String exitText) {
        void var2_2;
        void var1_1;
        this.entryText = var1_1;
        this.exitText = var2_2;
        this.messageFactory = DefaultFlowMessageFactory.createDefaultMessageFactory();
    }

    /*
     * WARNING - void declaration
     */
    private static MessageFactory createDefaultMessageFactory() {
        try {
            return AbstractLogger.DEFAULT_MESSAGE_FACTORY_CLASS.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            void var0;
            throw new IllegalStateException((Throwable)var0);
        }
    }

    public String getEntryText() {
        return this.entryText;
    }

    public String getExitText() {
        return this.exitText;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EntryMessage newEntryMessage(String format, Object ... params) {
        void var1_1;
        Message message;
        boolean hasFormat = Strings.isNotEmpty(format);
        if (params == null || params.length == 0) {
            message = hasFormat ? this.messageFactory.newMessage(format) : null;
        } else if (hasFormat) {
            message = this.messageFactory.newMessage((String)((Object)message), params);
        } else {
            void var2_2;
            StringBuilder sb = new StringBuilder("params(");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("{}");
            }
            sb.append(")");
            message = this.messageFactory.newMessage(sb.toString(), (Object[])var2_2);
        }
        return this.newEntryMessage((Message)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EntryMessage newEntryMessage(Message message) {
        void var1_1;
        return new SimpleEntryMessage(this.entryText, this.makeImmutable((Message)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private Message makeImmutable(Message message) {
        void var1_1;
        if (message instanceof ReusableMessage) {
            return ((ReusableMessage)message).memento();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExitMessage newExitMessage(String format, Object result) {
        void var1_1;
        void var2_2;
        Object message;
        void var3_3;
        boolean hasFormat = Strings.isNotEmpty(format);
        message = result == null ? (hasFormat ? this.messageFactory.newMessage(format) : null) : this.messageFactory.newMessage((String)(var3_3 != false ? message : "with({})"), var2_2);
        return this.newExitMessage((Message)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExitMessage newExitMessage(Message message) {
        void var1_1;
        return new SimpleExitMessage(this.exitText, (Message)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExitMessage newExitMessage(EntryMessage message) {
        void var1_1;
        return new SimpleExitMessage(this.exitText, (EntryMessage)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExitMessage newExitMessage(Object result, EntryMessage message) {
        void var2_2;
        void var1_1;
        return new SimpleExitMessage(this.exitText, (Object)var1_1, (EntryMessage)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExitMessage newExitMessage(Object result, Message message) {
        void var2_2;
        void var1_1;
        return new SimpleExitMessage(this.exitText, (Object)var1_1, (Message)var2_2);
    }

    private static final class SimpleExitMessage
    extends AbstractFlowMessage
    implements ExitMessage {
        private static final long serialVersionUID = 1L;
        private final Object result;
        private final boolean isVoid;

        /*
         * WARNING - void declaration
         */
        SimpleExitMessage(String exitText, EntryMessage message) {
            this((String)var1_1, var2_2.getMessage());
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        SimpleExitMessage(String exitText, Message message) {
            super((String)var1_1, (Message)var2_2);
            void var2_2;
            void var1_1;
            this.result = null;
            this.isVoid = true;
        }

        /*
         * WARNING - void declaration
         */
        SimpleExitMessage(String exitText, Object result, EntryMessage message) {
            this((String)var1_1, (Object)var2_2, var3_3.getMessage());
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        SimpleExitMessage(String exitText, Object result, Message message) {
            super((String)var1_1, (Message)var3_3);
            void var2_2;
            void var3_3;
            void var1_1;
            this.result = var2_2;
            this.isVoid = false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String getFormattedMessage() {
            void var1_1;
            String formattedMessage = super.getFormattedMessage();
            if (this.isVoid) {
                return formattedMessage;
            }
            return (String)var1_1 + ": " + this.result;
        }
    }

    private static final class SimpleEntryMessage
    extends AbstractFlowMessage
    implements EntryMessage {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - void declaration
         */
        SimpleEntryMessage(String entryText, Message message) {
            super((String)var1_1, (Message)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    private static class AbstractFlowMessage
    implements FlowMessage,
    StringBuilderFormattable {
        private static final long serialVersionUID = 1L;
        private final Message message;
        private final String text;

        /*
         * WARNING - void declaration
         */
        AbstractFlowMessage(String text, Message message) {
            void var1_1;
            void var2_2;
            this.message = var2_2;
            this.text = var1_1;
        }

        @Override
        public String getFormattedMessage() {
            if (this.message != null) {
                return this.text + " " + this.message.getFormattedMessage();
            }
            return this.text;
        }

        @Override
        public String getFormat() {
            if (this.message != null) {
                return this.text + " " + this.message.getFormat();
            }
            return this.text;
        }

        @Override
        public Object[] getParameters() {
            if (this.message != null) {
                return this.message.getParameters();
            }
            return null;
        }

        @Override
        public Throwable getThrowable() {
            if (this.message != null) {
                return this.message.getThrowable();
            }
            return null;
        }

        @Override
        public Message getMessage() {
            return this.message;
        }

        @Override
        public String getText() {
            return this.text;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void formatTo(StringBuilder buffer) {
            buffer.append(this.text);
            if (this.message != null) {
                void var1_1;
                buffer.append(" ");
                StringBuilders.appendValue((StringBuilder)var1_1, this.message);
            }
        }
    }
}

