/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.ThreadInformation;
import org.apache.logging.log4j.util.StringBuilders;

class BasicThreadInformation
implements ThreadInformation {
    private static final int HASH_SHIFT = 32;
    private static final int HASH_MULTIPLIER = 31;
    private final long id;
    private final String name;
    private final String longName;
    private final Thread.State state;
    private final int priority;
    private final boolean isAlive;
    private final boolean isDaemon;
    private final String threadGroupName;

    /*
     * WARNING - void declaration
     */
    BasicThreadInformation(Thread thread) {
        void var1_1;
        this.id = thread.getId();
        this.name = thread.getName();
        this.longName = thread.toString();
        this.state = thread.getState();
        this.priority = thread.getPriority();
        this.isAlive = thread.isAlive();
        this.isDaemon = thread.isDaemon();
        ThreadGroup group = thread.getThreadGroup();
        this.threadGroupName = group == null ? null : var1_1.getName();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicThreadInformation that = (BasicThreadInformation)o;
        if (this.id != that.id) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : var1_1.name != null);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = (int)(this.id ^ this.id >>> 32);
        var1_1 = var1_1 * 31 + (this.name != null ? this.name.hashCode() : 0);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printThreadInfo(StringBuilder sb) {
        void var1_1;
        StringBuilders.appendDqValue(sb, this.name).append(' ');
        if (this.isDaemon) {
            sb.append("daemon ");
        }
        sb.append("prio=").append(this.priority).append(" tid=").append(this.id).append(' ');
        if (this.threadGroupName != null) {
            StringBuilders.appendKeyDqValue(sb, "group", this.threadGroupName);
        }
        sb.append('\n');
        var1_1.append("\tThread state: ").append(this.state.name()).append('\n');
    }

    @Override
    public void printStack(StringBuilder sb, StackTraceElement[] trace) {
        StackTraceElement[] stackTraceElementArray = trace;
        int n = trace.length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement element = stackTraceElementArray[i];
            sb.append("\tat ").append(element).append('\n');
        }
    }
}

