/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.internal;

import java.util.Arrays;
import org.apache.logging.log4j.BridgeAware;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LambdaUtil;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.Supplier;

public class DefaultLogBuilder
implements BridgeAware,
LogBuilder {
    private static Message EMPTY_MESSAGE = new SimpleMessage("");
    private static final String FQCN = DefaultLogBuilder.class.getName();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ExtendedLogger logger;
    private Level level;
    private Marker marker;
    private Throwable throwable;
    private StackTraceElement location;
    private volatile boolean inUse;
    private long threadId;
    private String fqcn = FQCN;

    /*
     * WARNING - void declaration
     */
    public DefaultLogBuilder(ExtendedLogger logger, Level level) {
        void var2_2;
        void var1_1;
        this.logger = var1_1;
        this.level = level;
        this.threadId = Thread.currentThread().getId();
        this.inUse = var2_2 != null;
    }

    public DefaultLogBuilder() {
        this(null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setEntryPoint(String fqcn) {
        void var1_1;
        this.fqcn = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LogBuilder reset(ExtendedLogger logger, Level level) {
        void var2_2;
        void var1_1;
        this.logger = var1_1;
        this.level = var2_2;
        this.marker = null;
        this.throwable = null;
        this.location = null;
        this.inUse = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LogBuilder withMarker(Marker marker) {
        void var1_1;
        this.marker = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LogBuilder withThrowable(Throwable throwable) {
        void var1_1;
        this.throwable = var1_1;
        return this;
    }

    @Override
    public LogBuilder withLocation() {
        this.location = StackLocatorUtil.getStackTraceElement(2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LogBuilder withLocation(StackTraceElement location) {
        void var1_1;
        this.location = var1_1;
        return this;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Message message) {
        if (this.isValid() && this.isEnabled(message)) {
            void var1_1;
            this.logMessage((Message)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Message logAndGet(Supplier<Message> messageSupplier) {
        void var2_2;
        void var1_1;
        Message message = null;
        if (this.isValid() && this.isEnabled(message = (Message)var1_1.get())) {
            this.logMessage(message);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(CharSequence message) {
        if (this.isValid() && this.isEnabled(message)) {
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage(var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message) {
        if (this.isValid() && this.isEnabled(message)) {
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object ... params) {
        if (this.isValid() && this.isEnabled(message, params)) {
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, (Object[])var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Supplier<?> ... params) {
        Object[] objs;
        if (this.isValid() && this.isEnabled(message, objs = LambdaUtil.getAll(params))) {
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, (Object[])var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Supplier<Message> messageSupplier) {
        void var1_1;
        this.logAndGet((Supplier<Message>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(Object message) {
        if (this.isValid() && this.isEnabled(message)) {
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage(var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object p0) {
        if (this.isValid() && this.isEnabled(message, p0)) {
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object p0, Object p1) {
        if (this.isValid() && this.isEnabled(message, p0, p1)) {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, var2_2, var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object p0, Object p1, Object p2) {
        if (this.isValid() && this.isEnabled(message, p0, p1, p2)) {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, var2_2, var3_3, p2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object p0, Object p1, Object p2, Object p3) {
        if (this.isValid() && this.isEnabled(message, p0, p1, p2, p3)) {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, var2_2, var3_3, p2, p3));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        if (this.isValid() && this.isEnabled(message, p0, p1, p2, p3, p4)) {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, var2_2, var3_3, p2, p3, p4));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        if (this.isValid() && this.isEnabled(message, p0, p1, p2, p3, p4, p5)) {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, var2_2, var3_3, p2, p3, p4, p5));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        if (this.isValid() && this.isEnabled(message, p0, p1, p2, p3, p4, p5, p6)) {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, var2_2, var3_3, p2, p3, p4, p5, p6));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        if (this.isValid() && this.isEnabled(message, p0, p1, p2, p3, p4, p5, p6, p7)) {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, var2_2, var3_3, p2, p3, p4, p5, p6, p7));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        if (this.isValid() && this.isEnabled(message, p0, p1, p2, p3, p4, p5, p6, p7, p8)) {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, var2_2, var3_3, p2, p3, p4, p5, p6, p7, p8));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        if (this.isValid() && this.isEnabled(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9)) {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultLogBuilder defaultLogBuilder = this;
            defaultLogBuilder.logMessage(defaultLogBuilder.logger.getMessageFactory().newMessage((String)var1_1, var2_2, var3_3, p2, p3, p4, p5, p6, p7, p8, p9));
        }
    }

    @Override
    public void log() {
        if (this.isValid() && this.isEnabled(EMPTY_MESSAGE)) {
            this.logMessage(EMPTY_MESSAGE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logMessage(Message message) {
        try {
            void var1_1;
            this.logger.logMessage(this.level, this.marker, this.fqcn, this.location, (Message)var1_1, this.throwable);
            return;
        }
        finally {
            this.inUse = false;
        }
    }

    private boolean isValid() {
        if (!this.inUse) {
            LOGGER.warn("Attempt to reuse LogBuilder was ignored. {}", (Object)StackLocatorUtil.getCallerClass(2));
            return false;
        }
        if (this.threadId != Thread.currentThread().getId()) {
            LOGGER.warn("LogBuilder can only be used on the owning thread. {}", (Object)StackLocatorUtil.getCallerClass(2));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(Message message) {
        void var1_1;
        return this.logger.isEnabled(this.level, this.marker, (Message)var1_1, this.throwable);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(CharSequence message) {
        void var1_1;
        return this.logger.isEnabled(this.level, this.marker, (CharSequence)var1_1, this.throwable);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message) {
        void var1_1;
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, this.throwable);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message, Object ... params) {
        void var3_3;
        void var1_1;
        Object[] newParams;
        if (this.throwable != null) {
            Object[] objectArray = Arrays.copyOf(params, params.length + 1);
            newParams = objectArray;
            objectArray[params.length] = this.throwable;
        } else {
            void var2_2;
            newParams = var2_2;
        }
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(Object message) {
        void var1_1;
        return this.logger.isEnabled(this.level, this.marker, var1_1, this.throwable);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message, Object p0) {
        void var2_2;
        void var1_1;
        if (this.throwable != null) {
            return this.logger.isEnabled(this.level, this.marker, message, p0, (Object)this.throwable);
        }
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.throwable != null) {
            return this.logger.isEnabled(this.level, this.marker, message, p0, p1, (Object)this.throwable);
        }
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.throwable != null) {
            return this.logger.isEnabled(this.level, this.marker, message, p0, p1, p2, (Object)this.throwable);
        }
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, (Object)var2_2, (Object)var3_3, p2);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.throwable != null) {
            return this.logger.isEnabled(this.level, this.marker, message, p0, p1, p2, p3, (Object)this.throwable);
        }
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.throwable != null) {
            return this.logger.isEnabled(this.level, this.marker, message, p0, p1, p2, p3, p4, (Object)this.throwable);
        }
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.throwable != null) {
            return this.logger.isEnabled(this.level, this.marker, message, p0, p1, p2, p3, p4, p5, (Object)this.throwable);
        }
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.throwable != null) {
            return this.logger.isEnabled(this.level, this.marker, message, p0, p1, p2, p3, p4, p5, p6, (Object)this.throwable);
        }
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.throwable != null) {
            return this.logger.isEnabled(this.level, this.marker, message, p0, p1, p2, p3, p4, p5, p6, p7, (Object)this.throwable);
        }
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.throwable != null) {
            return this.logger.isEnabled(this.level, this.marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, (Object)this.throwable);
        }
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEnabled(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.throwable != null) {
            return this.logger.isEnabled(this.level, this.marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, this.throwable);
        }
        return this.logger.isEnabled(this.level, this.marker, (String)var1_1, (Object)var2_2, (Object)var3_3, p2, p3, p4, p5, p6, p7, p8, p9);
    }
}

