/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.spi.CleanableThreadContextMap;
import org.apache.logging.log4j.spi.DefaultThreadContextMap;
import org.apache.logging.log4j.spi.DefaultThreadContextStack;
import org.apache.logging.log4j.spi.NoOpThreadContextMap;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextMap2;
import org.apache.logging.log4j.spi.ThreadContextMapFactory;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class ThreadContext {
    public static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    public static final ThreadContextStack EMPTY_STACK = new EmptyThreadContextStack();
    private static final String DISABLE_MAP = "disableThreadContextMap";
    private static final String DISABLE_STACK = "disableThreadContextStack";
    private static final String DISABLE_ALL = "disableThreadContext";
    private static boolean useStack;
    private static ThreadContextMap contextMap;
    private static ThreadContextStack contextStack;
    private static ReadOnlyThreadContextMap readOnlyContextMap;

    private ThreadContext() {
    }

    /*
     * WARNING - void declaration
     */
    public static void init() {
        void var0_1;
        void var1_2;
        ThreadContextMapFactory.init();
        contextMap = null;
        PropertiesUtil managerProps = PropertiesUtil.getProperties();
        boolean disableAll = managerProps.getBooleanProperty(DISABLE_ALL);
        useStack = !managerProps.getBooleanProperty(DISABLE_STACK) && !disableAll;
        boolean useMap = !managerProps.getBooleanProperty(DISABLE_MAP) && var1_2 == false;
        contextStack = new DefaultThreadContextStack(useStack);
        contextMap = var0_1 == false ? new NoOpThreadContextMap() : ThreadContextMapFactory.createThreadContextMap();
        if (contextMap instanceof ReadOnlyThreadContextMap) {
            readOnlyContextMap = (ReadOnlyThreadContextMap)((Object)contextMap);
            return;
        }
        readOnlyContextMap = null;
    }

    /*
     * WARNING - void declaration
     */
    public static void put(String key, String value) {
        void var1_1;
        String string;
        contextMap.put(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void putIfNull(String key, String value) {
        if (!contextMap.containsKey(key)) {
            void var1_1;
            String string;
            contextMap.put(string, (String)var1_1);
        }
    }

    public static void putAll(Map<String, String> m) {
        Object object;
        if (contextMap instanceof ThreadContextMap2) {
            ((ThreadContextMap2)contextMap).putAll(m);
            return;
        }
        if (contextMap instanceof DefaultThreadContextMap) {
            ((DefaultThreadContextMap)contextMap).putAll(m);
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            contextMap.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static String get(String key) {
        String string;
        return contextMap.get(string);
    }

    public static void remove(String key) {
        String string;
        contextMap.remove(string);
    }

    /*
     * WARNING - void declaration
     */
    public static void removeAll(Iterable<String> keys) {
        Iterator<String> iterator;
        if (contextMap instanceof CleanableThreadContextMap) {
            ((CleanableThreadContextMap)contextMap).removeAll(keys);
            return;
        }
        if (contextMap instanceof DefaultThreadContextMap) {
            ((DefaultThreadContextMap)contextMap).removeAll(keys);
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var1_1;
            String key = (String)iterator.next();
            contextMap.remove((String)var1_1);
        }
    }

    public static void clearMap() {
        contextMap.clear();
    }

    public static void clearAll() {
        ThreadContext.clearMap();
        ThreadContext.clearStack();
    }

    public static boolean containsKey(String key) {
        String string;
        return contextMap.containsKey(string);
    }

    public static Map<String, String> getContext() {
        return contextMap.getCopy();
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> getImmutableContext() {
        void var0;
        Map<String, String> map = contextMap.getImmutableMapOrNull();
        if (map == null) {
            return EMPTY_MAP;
        }
        return var0;
    }

    public static ReadOnlyThreadContextMap getThreadContextMap() {
        return readOnlyContextMap;
    }

    public static boolean isEmpty() {
        return contextMap.isEmpty();
    }

    public static void clearStack() {
        contextStack.clear();
    }

    public static ContextStack cloneStack() {
        return contextStack.copy();
    }

    /*
     * WARNING - void declaration
     */
    public static ContextStack getImmutableStack() {
        void var0;
        ContextStack result = contextStack.getImmutableStackOrNull();
        if (result == null) {
            return EMPTY_STACK;
        }
        return var0;
    }

    public static void setStack(Collection<String> stack) {
        Collection<String> collection;
        if (stack.isEmpty() || !useStack) {
            return;
        }
        contextStack.clear();
        contextStack.addAll(collection);
    }

    public static int getDepth() {
        return contextStack.getDepth();
    }

    public static String pop() {
        return contextStack.pop();
    }

    public static String peek() {
        return contextStack.peek();
    }

    public static void push(String message) {
        String string;
        contextStack.push(string);
    }

    /*
     * WARNING - void declaration
     */
    public static void push(String message, Object ... args) {
        void var1_1;
        String string;
        contextStack.push(ParameterizedMessage.format(string, (Object[])var1_1));
    }

    public static void removeStack() {
        contextStack.clear();
    }

    public static void trim(int depth) {
        int n;
        contextStack.trim(n);
    }

    static {
        ThreadContext.init();
    }

    public static interface ContextStack
    extends Serializable,
    Collection<String> {
        public String pop();

        public String peek();

        public void push(String var1);

        public int getDepth();

        public List<String> asList();

        public void trim(int var1);

        public ContextStack copy();

        public ContextStack getImmutableStackOrNull();
    }

    private static class EmptyIterator<E>
    implements Iterator<E> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException("This is an empty iterator!");
        }

        @Override
        public void remove() {
        }
    }

    private static class EmptyThreadContextStack
    extends AbstractCollection<String>
    implements ThreadContextStack {
        private static final long serialVersionUID = 1L;
        private static final Iterator<String> EMPTY_ITERATOR = new EmptyIterator<String>();

        private EmptyThreadContextStack() {
        }

        @Override
        public String pop() {
            return null;
        }

        @Override
        public String peek() {
            return null;
        }

        @Override
        public void push(String message) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDepth() {
            return 0;
        }

        @Override
        public List<String> asList() {
            return Collections.emptyList();
        }

        @Override
        public void trim(int depth) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            void var1_1;
            return o instanceof Collection && ((Collection)var1_1).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public ContextStack copy() {
            return this;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(String e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ContextStack getImmutableStackOrNull() {
            return this;
        }
    }
}

