/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public final class MarkerManager {
    private static final ConcurrentMap<String, Marker> MARKERS = new ConcurrentHashMap<String, Marker>();

    private MarkerManager() {
    }

    public static void clear() {
        MARKERS.clear();
    }

    public static boolean exists(String key) {
        String string;
        return MARKERS.containsKey(string);
    }

    /*
     * WARNING - void declaration
     */
    public static Marker getMarker(String name) {
        void var1_1;
        Marker result = (Marker)MARKERS.get(name);
        if (result == null) {
            String string;
            MARKERS.putIfAbsent(name, new Log4jMarker(name));
            result = (Marker)MARKERS.get(string);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Marker getMarker(String name, String parent) {
        void var2_2;
        String string;
        Marker parentMarker = (Marker)MARKERS.get(parent);
        if (parentMarker == null) {
            void var1_1;
            throw new IllegalArgumentException("Parent Marker " + (String)var1_1 + " has not been defined");
        }
        return MarkerManager.getMarker(string, (Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Marker getMarker(String name, Marker parent) {
        void var1_1;
        return MarkerManager.getMarker(name).addParents(new Marker[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    private static void requireNonNull(Object obj, String message) {
        if (obj == null) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Object x0, String x1) {
        void var1_1;
        MarkerManager.requireNonNull(x0, (String)var1_1);
    }

    public static class Log4jMarker
    implements Marker,
    StringBuilderFormattable {
        private static final long serialVersionUID = 100L;
        private final String name;
        private volatile Marker[] parents;

        private Log4jMarker() {
            this.name = null;
            this.parents = null;
        }

        /*
         * WARNING - void declaration
         */
        public Log4jMarker(String name) {
            void var1_1;
            MarkerManager.access$000(name, "Marker name cannot be null.");
            this.name = var1_1;
            this.parents = null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public synchronized Marker addParents(Marker ... parentMarkers) {
            void var1_1;
            MarkerManager.access$000(parentMarkers, "A parent marker must be specified");
            Marker[] localParents = this.parents;
            int count = 0;
            int size22 = parentMarkers.length;
            if (localParents != null) {
                Marker[] size22 = parentMarkers;
                int n = parentMarkers.length;
                for (int i = 0; i < n; ++i) {
                    Marker parent = size22[i];
                    if (Log4jMarker.contains(parent, localParents) || parent.isInstanceOf(this)) continue;
                    ++count;
                }
                if (count == 0) {
                    return this;
                }
                size22 = localParents.length + count;
            }
            Marker[] markers = new Marker[size22];
            if (localParents != null) {
                System.arraycopy(localParents, 0, markers, 0, localParents.length);
            }
            int index = localParents == null ? 0 : localParents.length;
            for (void parent : var1_1) {
                void var3_5;
                if (localParents != null && (Log4jMarker.contains((Marker)parent, localParents) || parent.isInstanceOf(this))) continue;
                markers[index++] = var3_5;
            }
            this.parents = markers;
            return this;
        }

        @Override
        public synchronized boolean remove(Marker parent) {
            MarkerManager.access$000(parent, "A parent marker must be specified");
            Marker[] localParents = this.parents;
            if (this.parents == null) {
                return false;
            }
            int localParentsLength = localParents.length;
            if (localParentsLength == 1) {
                if (localParents[0].equals(parent)) {
                    this.parents = null;
                    return true;
                }
                return false;
            }
            int index = 0;
            Marker[] markers = new Marker[localParentsLength - 1];
            for (int i = 0; i < localParentsLength; ++i) {
                Marker marker = localParents[i];
                if (marker.equals(parent)) continue;
                if (index == localParentsLength - 1) {
                    return false;
                }
                markers[index++] = marker;
            }
            this.parents = markers;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Marker setParents(Marker ... markers) {
            if (markers == null || markers.length == 0) {
                this.parents = null;
            } else {
                void var2_2;
                void var1_1;
                Marker[] array = new Marker[markers.length];
                System.arraycopy(markers, 0, array, 0, ((void)var1_1).length);
                this.parents = var2_2;
            }
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Marker[] getParents() {
            void var1_1;
            Marker[] parentsSnapshot = this.parents;
            if (this.parents == null) {
                return null;
            }
            void v0 = var1_1;
            return (Marker[])Arrays.copyOf(v0, ((void)v0).length);
        }

        @Override
        public boolean hasParents() {
            return this.parents != null;
        }

        @Override
        @PerformanceSensitive(value={"allocation", "unrolled"})
        public boolean isInstanceOf(Marker marker) {
            MarkerManager.access$000(marker, "A marker parameter is required");
            if (this == marker) {
                return true;
            }
            Marker[] localParents = this.parents;
            if (this.parents != null) {
                int localParentsLength = localParents.length;
                if (localParentsLength == 1) {
                    return Log4jMarker.checkParent(localParents[0], marker);
                }
                if (localParentsLength == 2) {
                    return Log4jMarker.checkParent(localParents[0], marker) || Log4jMarker.checkParent(localParents[1], marker);
                }
                for (int i = 0; i < localParentsLength; ++i) {
                    Marker marker2 = localParents[i];
                    if (!Log4jMarker.checkParent(marker2, marker)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        @PerformanceSensitive(value={"allocation", "unrolled"})
        public boolean isInstanceOf(String markerName) {
            MarkerManager.access$000(markerName, "A marker name is required");
            if (markerName.equals(this.getName())) {
                return true;
            }
            Marker marker = (Marker)MARKERS.get(markerName);
            if (marker == null) {
                return false;
            }
            Marker[] localParents = this.parents;
            if (this.parents != null) {
                int localParentsLength = localParents.length;
                if (localParentsLength == 1) {
                    return Log4jMarker.checkParent(localParents[0], marker);
                }
                if (localParentsLength == 2) {
                    return Log4jMarker.checkParent(localParents[0], marker) || Log4jMarker.checkParent(localParents[1], marker);
                }
                for (int i = 0; i < localParentsLength; ++i) {
                    Marker marker2 = localParents[i];
                    if (!Log4jMarker.checkParent(marker2, marker)) continue;
                    return true;
                }
            }
            return false;
        }

        @PerformanceSensitive(value={"allocation", "unrolled"})
        private static boolean checkParent(Marker parent, Marker marker) {
            block4: {
                int localParentsLength;
                Object localParents;
                while (true) {
                    if (parent == marker) {
                        return true;
                    }
                    localParents = parent instanceof Log4jMarker ? ((Log4jMarker)parent).parents : parent.getParents();
                    if (localParents == null) break block4;
                    localParentsLength = ((Marker[])localParents).length;
                    if (localParentsLength != 1) break;
                    localParents = localParents[0];
                }
                if (localParentsLength == 2) {
                    return Log4jMarker.checkParent(localParents[0], marker) || Log4jMarker.checkParent(localParents[1], marker);
                }
                for (int i = 0; i < localParentsLength; ++i) {
                    Marker marker2 = localParents[i];
                    if (!Log4jMarker.checkParent(marker2, marker)) continue;
                    return true;
                }
            }
            return false;
        }

        @PerformanceSensitive(value={"allocation"})
        private static boolean contains(Marker parent, Marker ... localParents) {
            for (Marker marker : localParents) {
                if (marker != parent) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Marker)) {
                return false;
            }
            Marker marker = (Marker)o;
            return this.name.equals(var1_1.getName());
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            this.formatTo(sb);
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void formatTo(StringBuilder sb) {
            sb.append(this.name);
            Marker[] localParents = this.parents;
            if (this.parents != null) {
                void var2_2;
                void var1_1;
                Log4jMarker.addParentInfo((StringBuilder)var1_1, (Marker[])var2_2);
            }
        }

        @PerformanceSensitive(value={"allocation"})
        private static void addParentInfo(StringBuilder sb, Marker ... parents) {
            StringBuilder stringBuilder;
            sb.append("[ ");
            boolean first = true;
            for (Marker marker : parents) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(marker.getName());
                Marker[] p = marker instanceof Log4jMarker ? ((Log4jMarker)marker).parents : marker.getParents();
                if (p == null) continue;
                Log4jMarker.addParentInfo(sb, p);
            }
            stringBuilder.append(" ]");
        }
    }
}

