/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.net.URI;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.internal.LogManagerStatus;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.StringFormatterMessageFactory;
import org.apache.logging.log4j.simple.SimpleLoggerContextFactory;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.spi.Terminable;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.ProviderUtil;
import org.apache.logging.log4j.util.StackLocatorUtil;

public class LogManager {
    public static final String FACTORY_PROPERTY_NAME = "log4j2.loggerContextFactory";
    public static final String ROOT_LOGGER_NAME = "";
    private static final Logger LOGGER;
    private static final String FQCN;
    private static volatile LoggerContextFactory factory;

    protected LogManager() {
    }

    public static boolean exists(String name) {
        String string;
        return LogManager.getContext().hasLogger(string);
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext getContext() {
        try {
            return factory.getContext(FQCN, null, null, true);
        }
        catch (IllegalStateException ex) {
            void var0;
            LOGGER.warn(var0.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, null, null, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext getContext(boolean currentContext) {
        try {
            return factory.getContext(FQCN, null, null, currentContext, null, null);
        }
        catch (IllegalStateException ex) {
            boolean bl;
            void var1_1;
            LOGGER.warn(var1_1.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, null, null, bl, null, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext getContext(ClassLoader loader, boolean currentContext) {
        try {
            return factory.getContext(FQCN, loader, null, currentContext);
        }
        catch (IllegalStateException ex) {
            void var1_1;
            ClassLoader classLoader;
            void var2_2;
            LOGGER.warn(var2_2.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, classLoader, null, (boolean)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, Object externalContext) {
        try {
            return factory.getContext(FQCN, loader, externalContext, currentContext);
        }
        catch (IllegalStateException ex) {
            void var1_1;
            void var2_2;
            ClassLoader classLoader;
            void var3_3;
            LOGGER.warn(var3_3.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, classLoader, var2_2, (boolean)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, URI configLocation) {
        try {
            return factory.getContext(FQCN, loader, null, currentContext, configLocation, null);
        }
        catch (IllegalStateException ex) {
            void var2_2;
            void var1_1;
            ClassLoader classLoader;
            void var3_3;
            LOGGER.warn(var3_3.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, classLoader, null, (boolean)var1_1, (URI)var2_2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, Object externalContext, URI configLocation) {
        try {
            return factory.getContext(FQCN, loader, externalContext, currentContext, configLocation, null);
        }
        catch (IllegalStateException ex) {
            void var3_3;
            void var1_1;
            void var2_2;
            ClassLoader classLoader;
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, classLoader, var2_2, (boolean)var1_1, (URI)var3_3, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, Object externalContext, URI configLocation, String name) {
        try {
            return factory.getContext(FQCN, loader, externalContext, currentContext, configLocation, name);
        }
        catch (IllegalStateException ex) {
            void var3_3;
            void var1_1;
            void var2_2;
            ClassLoader classLoader;
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, classLoader, var2_2, (boolean)var1_1, (URI)var3_3, name);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static LoggerContext getContext(String fqcn, boolean currentContext) {
        try {
            return factory.getContext(fqcn, null, null, currentContext);
        }
        catch (IllegalStateException ex) {
            void var1_1;
            String string;
            void var2_2;
            LOGGER.warn(var2_2.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(string, null, null, (boolean)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        try {
            return factory.getContext(fqcn, loader, null, currentContext);
        }
        catch (IllegalStateException ex) {
            void var2_2;
            void var1_1;
            String string;
            void var3_3;
            LOGGER.warn(var3_3.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(string, (ClassLoader)var1_1, null, (boolean)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation, String name) {
        try {
            return factory.getContext(fqcn, loader, null, currentContext, configLocation, name);
        }
        catch (IllegalStateException ex) {
            void var2_2;
            void var1_1;
            String string;
            void var3_4;
            LOGGER.warn(var3_4.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(string, (ClassLoader)var1_1, null, (boolean)var2_2);
        }
    }

    public static void shutdown() {
        LogManager.shutdown(false);
    }

    public static void shutdown(boolean currentContext) {
        boolean bl;
        factory.shutdown(FQCN, null, bl, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void shutdown(boolean currentContext, boolean allContexts) {
        void var1_1;
        boolean bl;
        factory.shutdown(FQCN, null, bl, (boolean)var1_1);
    }

    public static void shutdown(LoggerContext context) {
        if (context instanceof Terminable) {
            LoggerContext loggerContext;
            ((Terminable)((Object)loggerContext)).terminate();
        }
    }

    public static LoggerContextFactory getFactory() {
        return factory;
    }

    public static void setFactory(LoggerContextFactory factory) {
        LogManager.factory = factory;
    }

    public static Logger getFormatterLogger() {
        return LogManager.getFormatterLogger(StackLocatorUtil.getCallerClass(2));
    }

    public static Logger getFormatterLogger(Class<?> clazz) {
        Class<?> clazz2;
        return LogManager.getLogger(clazz != null ? clazz2 : StackLocatorUtil.getCallerClass(2), (MessageFactory)StringFormatterMessageFactory.INSTANCE);
    }

    public static Logger getFormatterLogger(Object value) {
        Object object;
        return LogManager.getLogger(value != null ? object.getClass() : StackLocatorUtil.getCallerClass(2), (MessageFactory)StringFormatterMessageFactory.INSTANCE);
    }

    public static Logger getFormatterLogger(String name) {
        String string;
        if (name == null) {
            return LogManager.getFormatterLogger(StackLocatorUtil.getCallerClass(2));
        }
        return LogManager.getLogger(string, (MessageFactory)StringFormatterMessageFactory.INSTANCE);
    }

    private static Class<?> callerClass(Class<?> clazz) {
        Class<?> clazz2;
        if (clazz != null) {
            return clazz;
        }
        Class<?> candidate = StackLocatorUtil.getCallerClass(3);
        if (candidate == null) {
            throw new UnsupportedOperationException("No class provided, and an appropriate one cannot be found.");
        }
        return clazz2;
    }

    public static Logger getLogger() {
        return LogManager.getLogger(StackLocatorUtil.getCallerClass(2));
    }

    public static Logger getLogger(Class<?> clazz) {
        Class<?> clazz2;
        Class<?> cls = LogManager.callerClass(clazz);
        return LogManager.getContext(cls.getClassLoader(), false).getLogger(clazz2);
    }

    /*
     * WARNING - void declaration
     */
    public static Logger getLogger(Class<?> clazz, MessageFactory messageFactory) {
        void var1_1;
        Class<?> clazz2;
        Class<?> cls = LogManager.callerClass(clazz);
        return LogManager.getContext(cls.getClassLoader(), false).getLogger(clazz2, (MessageFactory)var1_1);
    }

    public static Logger getLogger(MessageFactory messageFactory) {
        MessageFactory messageFactory2;
        return LogManager.getLogger(StackLocatorUtil.getCallerClass(2), messageFactory2);
    }

    public static Logger getLogger(Object value) {
        Object object;
        return LogManager.getLogger(value != null ? object.getClass() : StackLocatorUtil.getCallerClass(2));
    }

    /*
     * WARNING - void declaration
     */
    public static Logger getLogger(Object value, MessageFactory messageFactory) {
        void var1_1;
        Object object;
        return LogManager.getLogger(value != null ? object.getClass() : StackLocatorUtil.getCallerClass(2), (MessageFactory)var1_1);
    }

    public static Logger getLogger(String name) {
        if (name != null) {
            String string;
            return LogManager.getContext(false).getLogger(string);
        }
        return LogManager.getLogger(StackLocatorUtil.getCallerClass(2));
    }

    /*
     * WARNING - void declaration
     */
    public static Logger getLogger(String name, MessageFactory messageFactory) {
        void var1_1;
        if (name != null) {
            String string;
            return LogManager.getContext(false).getLogger(string, messageFactory);
        }
        return LogManager.getLogger(StackLocatorUtil.getCallerClass(2), (MessageFactory)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static Logger getLogger(String fqcn, String name) {
        void var1_1;
        String string;
        return factory.getContext(string, null, null, false).getLogger((String)var1_1);
    }

    public static Logger getRootLogger() {
        return LogManager.getLogger(ROOT_LOGGER_NAME);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block12: {
            LogManager.LOGGER = StatusLogger.getLogger();
            LogManager.FQCN = LogManager.class.getName();
            var0 = PropertiesUtil.getProperties();
            factoryClassName = var0.getStringProperty("log4j2.loggerContextFactory");
            if (factoryClassName != null) {
                try {
                    LogManager.factory = LoaderUtil.newCheckedInstanceOf(factoryClassName, LoggerContextFactory.class);
                }
                catch (ClassNotFoundException v0) {
                    LogManager.LOGGER.error("Unable to locate configured LoggerContextFactory {}", (Object)factoryClassName);
                }
                catch (Exception ex) {
                    LogManager.LOGGER.error("Unable to create configured LoggerContextFactory {}", (Object)factoryClassName, (Object)ex);
                }
            }
            if (LogManager.factory != null) break block12;
            factories = new TreeMap<Integer, LoggerContextFactory>();
            if (!ProviderUtil.hasProviders()) ** GOTO lbl-1000
            for (Provider provider : ProviderUtil.getProviders()) {
                factoryClass = provider.loadLoggerContextFactory();
                if (factoryClass == null) continue;
                try {
                    factories.put(provider.getPriority(), factoryClass.newInstance());
                }
                catch (Exception e) {
                    LogManager.LOGGER.error("Unable to create class {} specified in provider URL {}", (Object)factoryClass.getName(), (Object)var2_3.getUrl(), (Object)e);
                }
            }
            if (!factories.isEmpty()) {
                if (factories.size() == 1) {
                    v1 = factories;
                    LogManager.factory = (LoggerContextFactory)v1.get(v1.lastKey());
                } else {
                    sb = new StringBuilder("Multiple logging implementations found: \n");
                    for (Map.Entry<K, V> entry : factories.entrySet()) {
                        sb.append("Factory: ").append(((LoggerContextFactory)entry.getValue()).getClass().getName());
                        sb.append(", Weighting: ").append(var3_4.getKey()).append('\n');
                    }
                    v2 = var1_2;
                    LogManager.factory = (LoggerContextFactory)v2.get(v2.lastKey());
                    sb.append("Using factory: ").append(LogManager.factory.getClass().getName());
                    LogManager.LOGGER.warn(var0.toString());
                }
            } else lbl-1000:
            // 2 sources

            {
                LogManager.LOGGER.error("Log4j2 could not find a logging implementation. Please add log4j-core to the classpath. Using SimpleLogger to log to the console...");
                LogManager.factory = SimpleLoggerContextFactory.INSTANCE;
            }
        }
        LogManagerStatus.setInitialized(true);
    }
}

