/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.spi.StandardLevel;
import org.apache.logging.log4j.util.Strings;

public final class Level
implements Serializable,
Comparable<Level> {
    private static final Level[] EMPTY_ARRAY = new Level[0];
    private static final ConcurrentMap<String, Level> LEVELS = new ConcurrentHashMap<String, Level>();
    public static final Level OFF = new Level("OFF", StandardLevel.OFF.intLevel());
    public static final Level FATAL = new Level("FATAL", StandardLevel.FATAL.intLevel());
    public static final Level ERROR = new Level("ERROR", StandardLevel.ERROR.intLevel());
    public static final Level WARN = new Level("WARN", StandardLevel.WARN.intLevel());
    public static final Level INFO = new Level("INFO", StandardLevel.INFO.intLevel());
    public static final Level DEBUG = new Level("DEBUG", StandardLevel.DEBUG.intLevel());
    public static final Level TRACE = new Level("TRACE", StandardLevel.TRACE.intLevel());
    public static final Level ALL = new Level("ALL", StandardLevel.ALL.intLevel());
    public static final String CATEGORY = "Level";
    private static final long serialVersionUID = 1581082L;
    private final String name;
    private final int intLevel;
    private final StandardLevel standardLevel;

    /*
     * WARNING - void declaration
     */
    private Level(String name, int intLevel) {
        void var2_2;
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("Illegal null or empty Level name.");
        }
        if (intLevel < 0) {
            throw new IllegalArgumentException("Illegal Level int less than zero.");
        }
        this.name = name;
        this.intLevel = intLevel;
        this.standardLevel = StandardLevel.getStandardLevel((int)var2_2);
        if (LEVELS.putIfAbsent(Level.toUpperCase(name.trim()), this) != null) {
            void var1_1;
            throw new IllegalStateException("Level " + (String)var1_1 + " has already been defined.");
        }
    }

    public final int intLevel() {
        return this.intLevel;
    }

    public final StandardLevel getStandardLevel() {
        return this.standardLevel;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isInRange(Level minLevel, Level maxLevel) {
        void var2_2;
        void var1_1;
        return this.intLevel >= var1_1.intLevel && this.intLevel <= var2_2.intLevel;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isLessSpecificThan(Level level) {
        void var1_1;
        return this.intLevel >= var1_1.intLevel;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isMoreSpecificThan(Level level) {
        void var1_1;
        return this.intLevel <= var1_1.intLevel;
    }

    public final Level clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Level other) {
        void var1_1;
        if (this.intLevel < other.intLevel) {
            return -1;
        }
        if (this.intLevel > var1_1.intLevel) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof Level && var1_1 == this;
    }

    public final Class<Level> getDeclaringClass() {
        return Level.class;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final String name() {
        return this.name;
    }

    public final String toString() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public static Level forName(String name, int intValue) {
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("Illegal null or empty Level name.");
        }
        String normalizedName = Level.toUpperCase(name.trim());
        Level level = (Level)LEVELS.get(normalizedName);
        if (level != null) {
            void var3_3;
            return var3_3;
        }
        try {
            void var1_1;
            String string;
            return new Level(string, (int)var1_1);
        }
        catch (IllegalStateException illegalStateException) {
            void var2_2;
            return (Level)LEVELS.get(var2_2);
        }
    }

    public static Level getLevel(String name) {
        String string;
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("Illegal null or empty Level name.");
        }
        return (Level)LEVELS.get(Level.toUpperCase(string.trim()));
    }

    public static Level toLevel(String level) {
        return Level.toLevel(level, DEBUG);
    }

    /*
     * WARNING - void declaration
     */
    public static Level toLevel(String name, Level defaultLevel) {
        Level level;
        if (name == null) {
            return defaultLevel;
        }
        Level level2 = (Level)LEVELS.get(Level.toUpperCase(name.trim()));
        if (level2 == null) {
            void var1_1;
            return var1_1;
        }
        return level;
    }

    private static String toUpperCase(String name) {
        return name.toUpperCase(Locale.ENGLISH);
    }

    public static Level[] values() {
        return LEVELS.values().toArray(EMPTY_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static Level valueOf(String name) {
        String string;
        Objects.requireNonNull(name, "No level name given.");
        String levelName = Level.toUpperCase(name.trim());
        Level level = (Level)LEVELS.get(levelName);
        if (level != null) {
            void var1_1;
            return var1_1;
        }
        throw new IllegalArgumentException("Unknown level constant [" + string + "].");
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String name) {
        void var1_1;
        return Enum.valueOf(enumType, (String)var1_1);
    }

    protected final Object readResolve() {
        return Level.valueOf(this.name);
    }
}

