/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.ThreadContext;

public class CloseableThreadContext {
    private CloseableThreadContext() {
    }

    public static Instance push(String message) {
        String string;
        return new Instance().push(string);
    }

    /*
     * WARNING - void declaration
     */
    public static Instance push(String message, Object ... args) {
        void var1_1;
        String string;
        return new Instance().push(string, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Instance put(String key, String value) {
        void var1_1;
        String string;
        return new Instance().put(string, (String)var1_1);
    }

    public static Instance pushAll(List<String> messages) {
        List<String> list;
        return new Instance().pushAll(list);
    }

    public static Instance putAll(Map<String, String> values) {
        Map<String, String> map;
        return new Instance().putAll(map);
    }

    public static class Instance
    implements AutoCloseable {
        private int pushCount = 0;
        private final Map<String, String> originalValues = new HashMap<String, String>();

        private Instance() {
        }

        public Instance push(String message) {
            ThreadContext.push(message);
            ++this.pushCount;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Instance push(String message, Object[] args) {
            void var2_2;
            ThreadContext.push(message, (Object[])var2_2);
            ++this.pushCount;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Instance put(String key, String value) {
            void var2_2;
            void var1_1;
            if (!this.originalValues.containsKey(key)) {
                String string = key;
                this.originalValues.put(string, ThreadContext.get(string));
            }
            ThreadContext.put((String)var1_1, (String)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Instance putAll(Map<String, String> values) {
            Iterator iterator;
            Map<String, String> currentValues = ThreadContext.getContext();
            ThreadContext.putAll(values);
            for (String key : iterator.keySet()) {
                void var3_3;
                if (this.originalValues.containsKey(key)) continue;
                this.originalValues.put(key, currentValues.get(var3_3));
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Instance pushAll(List<String> messages) {
            for (String message : messages) {
                void var2_2;
                this.push((String)var2_2);
            }
            return this;
        }

        @Override
        public void close() {
            this.closeStack();
            this.closeMap();
        }

        /*
         * WARNING - void declaration
         */
        private void closeMap() {
            Iterator<Map.Entry<String, String>> it = this.originalValues.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                String key = entry.getKey();
                String originalValue = entry.getValue();
                if (originalValue == null) {
                    ThreadContext.remove(key);
                } else {
                    void var2_2;
                    void var3_3;
                    ThreadContext.put((String)var3_3, (String)var2_2);
                }
                it.remove();
            }
        }

        private void closeStack() {
            for (int i = 0; i < this.pushCount; ++i) {
                ThreadContext.pop();
            }
            this.pushCount = 0;
        }
    }
}

