/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.FileHandle;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.ZipFileSystem;
import okio.internal.EocdRecord;
import okio.internal.ZipEntry;
import okio.internal._ZlibJvmKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a5\u0010\t\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a)\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00050\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0013\u0010\u0011\u001a\u00020\u0005*\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0013\u0010\u0014\u001a\u00020\u0013*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u001b\u0010\u0017\u001a\u00020\u0013*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a5\u0010\u001f\u001a\u00020\u001d*\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00192\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u0013\u0010!\u001a\u00020\u001d*\u00020\u0010H\u0000\u00a2\u0006\u0004\b!\u0010\"\u001a\u001b\u0010$\u001a\u00020\u0005*\u00020\u00102\u0006\u0010#\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b$\u0010%\u001a\u001f\u0010&\u001a\u0004\u0018\u00010\u0005*\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0004\b&\u0010%\u001a\u0017\u0010(\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001cH\u0000\u00a2\u0006\u0004\b(\u0010)\u001a!\u0010,\u001a\u0004\u0018\u00010\u001c2\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b,\u0010-\"\u0018\u00101\u001a\u00020.*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100"}, d2={"Lokio/Path;", "zipPath", "Lokio/FileSystem;", "fileSystem", "Lkotlin/Function1;", "Lokio/internal/ZipEntry;", "", "predicate", "Lokio/ZipFileSystem;", "openZip", "(Lokio/Path;Lokio/FileSystem;Lkotlin/jvm/functions/Function1;)Lokio/ZipFileSystem;", "", "entries", "", "buildIndex", "(Ljava/util/List;)Ljava/util/Map;", "Lokio/BufferedSource;", "readCentralDirectoryZipEntry", "(Lokio/BufferedSource;)Lokio/internal/ZipEntry;", "Lokio/internal/EocdRecord;", "readEocdRecord", "(Lokio/BufferedSource;)Lokio/internal/EocdRecord;", "regularRecord", "readZip64EocdRecord", "(Lokio/BufferedSource;Lokio/internal/EocdRecord;)Lokio/internal/EocdRecord;", "", "extraSize", "Lkotlin/Function2;", "", "", "block", "readExtra", "(Lokio/BufferedSource;ILkotlin/jvm/functions/Function2;)V", "skipLocalHeader", "(Lokio/BufferedSource;)V", "centralDirectoryZipEntry", "readLocalHeader", "(Lokio/BufferedSource;Lokio/internal/ZipEntry;)Lokio/internal/ZipEntry;", "readOrSkipLocalHeader", "filetime", "filetimeToEpochMillis", "(J)J", "date", "time", "dosDateTimeToEpochMillis", "(II)Ljava/lang/Long;", "", "getHex", "(I)Ljava/lang/String;", "hex"})
@SourceDebugExtension(value={"SMAP\nZipFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFiles.kt\nokio/internal/ZipFilesKt\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,503:1\n52#2,4:504\n52#2,4:508\n52#2,22:512\n60#2,10:534\n56#2,3:544\n71#2,3:547\n52#2,22:550\n60#2,10:572\n56#2,3:582\n71#2,3:585\n1053#3:588\n*S KotlinDebug\n*F\n+ 1 ZipFiles.kt\nokio/internal/ZipFilesKt\n*L\n66#1:504,4\n101#1:508,4\n109#1:512,22\n101#1:534,10\n101#1:544,3\n101#1:547,3\n125#1:550,22\n66#1:572,10\n66#1:582,3\n66#1:585,3\n155#1:588\n*E\n"})
public final class ZipFilesKt {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final ZipFileSystem openZip(Path zipPath, FileSystem fileSystem, Function1<? super ZipEntry, Boolean> predicate) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Closeable $this$use$iv = fileSystem.openReadOnly((Path)zipPath);
        try {
            Unit unit;
            Throwable thrown$iv;
            List entries;
            Object result$iv;
            String comment;
            block59: {
                Object entry;
                EocdRecord record;
                long eocdOffset;
                FileHandle fileHandle;
                block56: {
                    fileHandle = (FileHandle)$this$use$iv;
                    long scanOffset = fileHandle.size() - 22L;
                    if (scanOffset < 0L) {
                        throw new IOException("not a zip: size=" + fileHandle.size());
                    }
                    long stopOffset = Math.max(scanOffset - 65536L, 0L);
                    do {
                        try (BufferedSource source2 = Okio.buffer(fileHandle.source(scanOffset));){
                            if (source2.readIntLe() != 101010256) continue;
                            eocdOffset = scanOffset;
                            record = ZipFilesKt.readEocdRecord(source2);
                            comment = source2.readUtf8(record.getCommentByteCount());
                            break block56;
                        }
                    } while ((scanOffset += -1L) >= stopOffset);
                    throw new IOException("not a zip: end of central directory signature not found");
                }
                long zip64LocatorOffset = eocdOffset - 20L;
                if (zip64LocatorOffset > 0L) {
                    Unit t$iv2222;
                    Throwable thrown$iv22222;
                    block58: {
                        Closeable $this$use$iv2 = Okio.buffer(fileHandle.source(zip64LocatorOffset));
                        thrown$iv22222 = null;
                        try {
                            BufferedSource zip64LocatorSource23322 = (BufferedSource)$this$use$iv2;
                            if (zip64LocatorSource23322.readIntLe() == 117853008) {
                                BufferedSource zip64EocdSource;
                                Throwable thrown$iv3;
                                block57: {
                                    int diskWithCentralDir = zip64LocatorSource23322.readIntLe();
                                    long zip64EocdRecordOffset = zip64LocatorSource23322.readLongLe();
                                    int zip64LocatorSource23322 = zip64LocatorSource23322.readIntLe();
                                    if (zip64LocatorSource23322 != 1) throw new IOException("unsupported zip: spanned");
                                    if (diskWithCentralDir != 0) {
                                        throw new IOException("unsupported zip: spanned");
                                    }
                                    Object $this$use$iv3 = Okio.buffer(fileHandle.source(zip64EocdRecordOffset));
                                    thrown$iv3 = null;
                                    try {
                                        zip64EocdSource = (BufferedSource)$this$use$iv3;
                                        int zip64EocdSignature = zip64EocdSource.readIntLe();
                                        if (zip64EocdSignature != 101075792) {
                                            throw new IOException("bad zip: expected " + ZipFilesKt.getHex(101075792) + " but was " + ZipFilesKt.getHex(zip64EocdSignature));
                                        }
                                        record = ZipFilesKt.readZip64EocdRecord(zip64EocdSource, record);
                                        zip64EocdSource = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable) {
                                        Throwable throwable4 = throwable;
                                        thrown$iv3 = throwable;
                                        zip64EocdSource = null;
                                        try {
                                            Closeable closeable = $this$use$iv3;
                                            if (closeable != null) {
                                                closeable.close();
                                            }
                                            break block57;
                                        }
                                        catch (Throwable t$iv2222) {
                                            ExceptionsKt.addSuppressed((Throwable)thrown$iv3, (Throwable)t$iv2222);
                                        }
                                        break block57;
                                    }
                                    catch (Throwable throwable5) {
                                        try {
                                            Unit unit2 = t$iv2222;
                                            if (unit2 == null) throw throwable5;
                                            unit2.close();
                                            throw throwable5;
                                        }
                                        catch (Throwable throwable) {}
                                        throw throwable5;
                                    }
                                    try {
                                        Closeable closeable = $this$use$iv3;
                                        if (closeable != null) {
                                            closeable.close();
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        $this$use$iv3 = throwable;
                                        thrown$iv3 = throwable;
                                    }
                                }
                                result$iv = zip64EocdSource;
                                Throwable throwable = thrown$iv3;
                                if (throwable != null) {
                                    throw throwable;
                                }
                            }
                            t$iv2222 = Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            thrown$iv22222 = throwable;
                            thrown$iv22222 = throwable;
                            t$iv2222 = null;
                            try {
                                Closeable closeable = $this$use$iv2;
                                if (closeable != null) {
                                    closeable.close();
                                }
                                break block58;
                            }
                            catch (Throwable t$iv3) {
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv22222, (Throwable)t$iv3);
                            }
                            break block58;
                        }
                        catch (Throwable thrown$iv22222) {
                            try {
                                Closeable closeable = $this$use$iv2;
                                if (closeable == null) throw thrown$iv22222;
                                closeable.close();
                                throw thrown$iv22222;
                            }
                            catch (Throwable throwable) {}
                            throw thrown$iv22222;
                        }
                        try {
                            Closeable closeable = $this$use$iv2;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable throwable) {
                            result$iv = throwable;
                            thrown$iv22222 = throwable;
                        }
                    }
                    Unit result$iv2 = t$iv2222;
                    Throwable throwable = thrown$iv22222;
                    if (throwable != null) {
                        throw throwable;
                    }
                }
                entries = new ArrayList();
                Closeable $this$use$iv4 = Okio.buffer(fileHandle.source(record.getCentralDirectoryOffset()));
                thrown$iv = null;
                try {
                    BufferedSource source3 = (BufferedSource)$this$use$iv4;
                    long l = record.getEntryCount();
                    for (long i = 0L; i < l; ++i) {
                        entry = ZipFilesKt.readCentralDirectoryZipEntry(source3);
                        if (((ZipEntry)entry).getOffset() >= record.getCentralDirectoryOffset()) {
                            throw new IOException("bad zip: local file header offset >= central directory offset");
                        }
                        if (!((Boolean)predicate.invoke(entry)).booleanValue()) continue;
                        ((Collection)entries).add(entry);
                    }
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    Throwable throwable14 = throwable;
                    thrown$iv = throwable;
                    unit = null;
                    try {
                        Closeable closeable = $this$use$iv4;
                        if (closeable != null) {
                            closeable.close();
                        }
                        break block59;
                    }
                    catch (Throwable t$iv) {
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
                    }
                    break block59;
                }
                catch (Throwable throwable15) {
                    try {
                        Closeable closeable = $this$use$iv4;
                        if (closeable == null) throw throwable15;
                        closeable.close();
                        throw throwable15;
                    }
                    catch (Throwable throwable) {}
                    throw throwable15;
                }
                try {
                    Closeable closeable = $this$use$iv4;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable throwable) {
                    entry = throwable;
                    thrown$iv = throwable;
                }
            }
            result$iv = unit;
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
            Map<Path, ZipEntry> index = ZipFilesKt.buildIndex(entries);
            zipPath = new ZipFileSystem((Path)zipPath, fileSystem, index, comment);
        }
        catch (Throwable throwable) {
            Throwable throwable4;
            Throwable throwable20 = throwable;
            Throwable thrown$iv4 = throwable;
            try {
                Closeable closeable = $this$use$iv;
                if (closeable == null) throw throwable4;
                closeable.close();
                throw throwable4;
            }
            catch (Throwable t$iv) {
                void var1_3;
                ExceptionsKt.addSuppressed((Throwable)thrown$iv4, (Throwable)var1_3);
                throw throwable4;
            }
        }
        catch (Throwable throwable21) {
            try {
                void var3_5;
                void v23 = var3_5;
                if (v23 == null) throw throwable21;
                v23.close();
                throw throwable21;
            }
            catch (Throwable throwable) {}
            throw throwable21;
        }
        try {
            Closeable closeable = $this$use$iv;
            if (closeable == null) return zipPath;
            closeable.close();
            return zipPath;
        }
        catch (Throwable throwable) {}
        return zipPath;
    }

    public static /* synthetic */ ZipFileSystem openZip$default(Path path, FileSystem fileSystem, Function1 function1, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            function1 = ZipFilesKt::openZip$lambda$0;
        }
        return ZipFilesKt.openZip(path, fileSystem, (Function1<? super ZipEntry, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<Path, ZipEntry> buildIndex(List<ZipEntry> entries) {
        void var1_1;
        Path root = Path.Companion.get$default(Path.Companion, "/", false, 1, null);
        Pair[] pairArray = new Pair[1];
        Pair[] pairArray2 = pairArray;
        pairArray[0] = TuplesKt.to((Object)root, (Object)new ZipEntry(root, true, null, 0L, 0L, 0L, 0, 0L, 0, 0, null, null, null, null, null, null, 65532, null));
        Map result = MapsKt.mutableMapOf((Pair[])pairArray2);
        entries = entries;
        block0: for (ZipEntry entry : CollectionsKt.sortedWith((Iterable)entries, (Comparator)new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var1_1;
                Comparable comparable;
                a = (ZipEntry)a;
                ZipEntry it = (ZipEntry)((Object)comparable);
                comparable = ((ZipEntry)a).getCanonicalPath();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)var1_1.getCanonicalPath());
            }
        })) {
            ZipEntry child;
            ZipEntry zipEntry = (ZipEntry)result.put(entry.getCanonicalPath(), entry);
            if (zipEntry != null) continue;
            while (child.getCanonicalPath().parent() != null) {
                Path parentPath;
                ZipEntry parentEntry = (ZipEntry)result.get(parentPath);
                if (parentEntry != null) {
                    ((Collection)parentEntry.getChildren()).add(child.getCanonicalPath());
                    continue block0;
                }
                parentEntry = new ZipEntry(parentPath, true, null, 0L, 0L, 0L, 0, 0L, 0, 0, null, null, null, null, null, null, 65532, null);
                result.put(zipEntry, parentEntry);
                ((Collection)parentEntry.getChildren()).add(child.getCanonicalPath());
                child = parentEntry;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final ZipEntry readCentralDirectoryZipEntry(BufferedSource $this$readCentralDirectoryZipEntry) throws IOException {
        void var2_2;
        void var3_3;
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$readCentralDirectoryZipEntry, (String)"<this>");
        int signature = $this$readCentralDirectoryZipEntry.readIntLe();
        if (signature != 33639248) {
            throw new IOException("bad zip: expected " + ZipFilesKt.getHex(33639248) + " but was " + ZipFilesKt.getHex(signature));
        }
        $this$readCentralDirectoryZipEntry.skip(4L);
        int bitFlag = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        if ((bitFlag & 1) != 0) {
            throw new IOException("unsupported zip: general purpose bit flag=" + ZipFilesKt.getHex(bitFlag));
        }
        int compressionMethod = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        int dosLastModifiedTime = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        int dosLastModifiedDate = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        long crc = (long)$this$readCentralDirectoryZipEntry.readIntLe() & 0xFFFFFFFFL;
        Ref.LongRef compressedSize = new Ref.LongRef();
        new Ref.LongRef().element = (long)$this$readCentralDirectoryZipEntry.readIntLe() & 0xFFFFFFFFL;
        Ref.LongRef size = new Ref.LongRef();
        new Ref.LongRef().element = (long)$this$readCentralDirectoryZipEntry.readIntLe() & 0xFFFFFFFFL;
        int nameSize = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        int extraSize = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        int commentByteCount = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        $this$readCentralDirectoryZipEntry.skip(8L);
        Ref.LongRef offset = new Ref.LongRef();
        new Ref.LongRef().element = (long)$this$readCentralDirectoryZipEntry.readIntLe() & 0xFFFFFFFFL;
        String name = $this$readCentralDirectoryZipEntry.readUtf8(nameSize);
        if (StringsKt.contains$default((CharSequence)name, (char)'\u0000', (boolean)false, (int)2, null)) {
            throw new IOException("bad zip: filename contains 0x00");
        }
        long result = 0L;
        if (size.element == 0xFFFFFFFFL) {
            result = 8L;
        }
        if (compressedSize.element == 0xFFFFFFFFL) {
            result += 8L;
        }
        if (offset.element == 0xFFFFFFFFL) {
            result += 8L;
        }
        long requiredZip64ExtraSize = result;
        Ref.ObjectRef ntfsLastModifiedAtFiletime = new Ref.ObjectRef();
        Ref.ObjectRef ntfsLastAccessedAtFiletime = new Ref.ObjectRef();
        Ref.ObjectRef ntfsCreatedAtFiletime = new Ref.ObjectRef();
        Ref.BooleanRef hasZip64Extra = new Ref.BooleanRef();
        ZipFilesKt.readExtra($this$readCentralDirectoryZipEntry, extraSize, (Function2<? super Integer, ? super Long, Unit>)((Function2)(arg_0, arg_1) -> ZipFilesKt.readCentralDirectoryZipEntry$lambda$8(hasZip64Extra, requiredZip64ExtraSize, size, $this$readCentralDirectoryZipEntry, compressedSize, offset, ntfsLastModifiedAtFiletime, ntfsLastAccessedAtFiletime, ntfsCreatedAtFiletime, arg_0, arg_1)));
        if (requiredZip64ExtraSize > 0L && !hasZip64Extra.element) {
            throw new IOException("bad zip: zip64 extra required but absent");
        }
        String comment = $this$readCentralDirectoryZipEntry.readUtf8(commentByteCount);
        Path canonicalPath = Path.Companion.get$default(Path.Companion, "/", false, 1, null).resolve(name);
        boolean isDirectory = StringsKt.endsWith$default((String)name, (String)"/", (boolean)false, (int)2, null);
        return new ZipEntry(path, isDirectory, comment, crc, compressedSize.element, size.element, (int)var1_1, offset.element, (int)var3_3, (int)var2_2, (Long)ntfsLastModifiedAtFiletime.element, (Long)ntfsLastAccessedAtFiletime.element, (Long)ntfsCreatedAtFiletime.element, null, null, null, 57344, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final EocdRecord readEocdRecord(BufferedSource $this$readEocdRecord) throws IOException {
        void var0_1;
        void var3_4;
        void var2_3;
        void var1_2;
        long totalEntryCount;
        int diskNumber = $this$readEocdRecord.readShortLe() & 0xFFFF;
        int diskWithCentralDir = $this$readEocdRecord.readShortLe() & 0xFFFF;
        long entryCount = $this$readEocdRecord.readShortLe() & 0xFFFF;
        if (entryCount != (totalEntryCount = (long)($this$readEocdRecord.readShortLe() & 0xFFFF)) || var1_2 != false || var2_3 != false) {
            throw new IOException("unsupported zip: spanned");
        }
        $this$readEocdRecord.skip(4L);
        long centralDirectoryOffset = (long)$this$readEocdRecord.readIntLe() & 0xFFFFFFFFL;
        int commentByteCount = $this$readEocdRecord.readShortLe() & 0xFFFF;
        return new EocdRecord((long)var3_4, centralDirectoryOffset, (int)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final EocdRecord readZip64EocdRecord(BufferedSource $this$readZip64EocdRecord, EocdRecord regularRecord) throws IOException {
        void var1_1;
        BufferedSource bufferedSource;
        void var3_3;
        void var2_2;
        $this$readZip64EocdRecord.skip(12L);
        int diskNumber = $this$readZip64EocdRecord.readIntLe();
        int diskWithCentralDirStart = $this$readZip64EocdRecord.readIntLe();
        long entryCount = $this$readZip64EocdRecord.readLongLe();
        long totalEntryCount = $this$readZip64EocdRecord.readLongLe();
        if (entryCount != totalEntryCount || var2_2 != false || var3_3 != false) {
            throw new IOException("unsupported zip: spanned");
        }
        $this$readZip64EocdRecord.skip(8L);
        long centralDirectoryOffset = bufferedSource.readLongLe();
        return new EocdRecord(entryCount, centralDirectoryOffset, var1_1.getCommentByteCount());
    }

    /*
     * WARNING - void declaration
     */
    private static final void readExtra(BufferedSource $this$readExtra, int extraSize, Function2<? super Integer, ? super Long, Unit> block) {
        long dataSize;
        for (long remaining = (long)extraSize; remaining != 0L; remaining -= dataSize) {
            if (remaining < 4L) {
                throw new IOException("bad zip: truncated header in extra field");
            }
            int headerId = $this$readExtra.readShortLe() & 0xFFFF;
            dataSize = (long)$this$readExtra.readShortLe() & 0xFFFFL;
            if ((remaining -= 4L) < dataSize) {
                throw new IOException("bad zip: truncated value in extra field");
            }
            $this$readExtra.require(dataSize);
            long sizeBefore = $this$readExtra.getBuffer().size();
            block.invoke((Object)headerId, (Object)dataSize);
            long fieldRemaining = dataSize + $this$readExtra.getBuffer().size() - sizeBefore;
            if (fieldRemaining < 0L) {
                void var1_1;
                throw new IOException("unsupported zip: too many bytes processed for " + (int)var1_1);
            }
            if (fieldRemaining <= 0L) continue;
            $this$readExtra.getBuffer().skip(fieldRemaining);
        }
    }

    public static final void skipLocalHeader(BufferedSource $this$skipLocalHeader) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)$this$skipLocalHeader, (String)"<this>");
        ZipFilesKt.readOrSkipLocalHeader(bufferedSource, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final ZipEntry readLocalHeader(BufferedSource $this$readLocalHeader, ZipEntry centralDirectoryZipEntry) {
        void var1_1;
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)$this$readLocalHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)centralDirectoryZipEntry, (String)"centralDirectoryZipEntry");
        ZipEntry zipEntry = ZipFilesKt.readOrSkipLocalHeader(bufferedSource, (ZipEntry)var1_1);
        Intrinsics.checkNotNull((Object)zipEntry);
        return zipEntry;
    }

    /*
     * WARNING - void declaration
     */
    private static final ZipEntry readOrSkipLocalHeader(BufferedSource $this$readOrSkipLocalHeader, ZipEntry centralDirectoryZipEntry) {
        void var3_5;
        void var1_1;
        BufferedSource bufferedSource;
        void var2_2;
        int signature = $this$readOrSkipLocalHeader.readIntLe();
        if (signature != 67324752) {
            throw new IOException("bad zip: expected " + ZipFilesKt.getHex(67324752) + " but was " + ZipFilesKt.getHex(signature));
        }
        $this$readOrSkipLocalHeader.skip(2L);
        int bitFlag = $this$readOrSkipLocalHeader.readShortLe() & 0xFFFF;
        if ((bitFlag & 1) != 0) {
            throw new IOException("unsupported zip: general purpose bit flag=" + ZipFilesKt.getHex(bitFlag));
        }
        $this$readOrSkipLocalHeader.skip(18L);
        long fileNameLength = (long)$this$readOrSkipLocalHeader.readShortLe() & 0xFFFFL;
        int extraSize = $this$readOrSkipLocalHeader.readShortLe() & 0xFFFF;
        $this$readOrSkipLocalHeader.skip(fileNameLength);
        if (centralDirectoryZipEntry == null) {
            $this$readOrSkipLocalHeader.skip(extraSize);
            return null;
        }
        Ref.ObjectRef extendedLastModifiedAtSeconds = new Ref.ObjectRef();
        Ref.ObjectRef extendedLastAccessedAtSeconds = new Ref.ObjectRef();
        Ref.ObjectRef extendedCreatedAtSeconds = new Ref.ObjectRef();
        ZipFilesKt.readExtra($this$readOrSkipLocalHeader, (int)var2_2, (Function2<? super Integer, ? super Long, Unit>)((Function2)(arg_0, arg_1) -> ZipFilesKt.readOrSkipLocalHeader$lambda$10(bufferedSource, extendedLastModifiedAtSeconds, extendedLastAccessedAtSeconds, extendedCreatedAtSeconds, arg_0, arg_1)));
        return var1_1.copy$okio((Integer)var3_5.element, (Integer)extendedLastAccessedAtSeconds.element, (Integer)extendedCreatedAtSeconds.element);
    }

    public static final long filetimeToEpochMillis(long filetime) {
        return filetime / 10000L - 11644473600000L;
    }

    /*
     * WARNING - void declaration
     */
    public static final Long dosDateTimeToEpochMillis(int date, int time) {
        void var1_1;
        int n;
        if (time == -1) {
            return null;
        }
        return _ZlibJvmKt.datePartsToEpochMillis(1980 + (date >> 9 & 0x7F), date >> 5 & 0xF, n & 0x1F, time >> 11 & 0x1F, time >> 5 & 0x3F, (var1_1 & 0x1F) << 1);
    }

    private static final String getHex(int $this$hex) {
        int n;
        StringBuilder stringBuilder = new StringBuilder("0x");
        String string = Integer.toString(n, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder.append(string).toString();
    }

    private static final boolean openZip$lambda$0(ZipEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit readCentralDirectoryZipEntry$lambda$8$lambda$7(Ref.ObjectRef $ntfsLastModifiedAtFiletime, BufferedSource $this_readCentralDirectoryZipEntry, Ref.ObjectRef $ntfsLastAccessedAtFiletime, Ref.ObjectRef $ntfsCreatedAtFiletime, int attributeId, long attributeSize) {
        if (attributeId == 1) {
            void var1_1;
            if ($ntfsLastModifiedAtFiletime.element != null) {
                throw new IOException("bad zip: NTFS extra attribute tag 0x0001 repeated");
            }
            if (attributeSize != 24L) {
                throw new IOException("bad zip: NTFS extra attribute tag 0x0001 size != 24");
            }
            var0.element = $this_readCentralDirectoryZipEntry.readLongLe();
            var2_2.element = $this_readCentralDirectoryZipEntry.readLongLe();
            var3_3.element = var1_1.readLongLe();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit readCentralDirectoryZipEntry$lambda$8(Ref.BooleanRef $hasZip64Extra, long $requiredZip64ExtraSize, Ref.LongRef $size, BufferedSource $this_readCentralDirectoryZipEntry, Ref.LongRef $compressedSize, Ref.LongRef $offset, Ref.ObjectRef $ntfsLastModifiedAtFiletime, Ref.ObjectRef $ntfsLastAccessedAtFiletime, Ref.ObjectRef $ntfsCreatedAtFiletime, int headerId, long dataSize) {
        switch (headerId) {
            case 1: {
                void var3_2;
                void var1_1;
                if ($hasZip64Extra.element) {
                    throw new IOException("bad zip: zip64 extra repeated");
                }
                var0.element = true;
                if (dataSize < var1_1) {
                    throw new IOException("bad zip: zip64 extra too short");
                }
                $size.element = $size.element == 0xFFFFFFFFL ? $this_readCentralDirectoryZipEntry.readLongLe() : var3_2.element;
                $compressedSize.element = $compressedSize.element == 0xFFFFFFFFL ? $this_readCentralDirectoryZipEntry.readLongLe() : 0L;
                $offset.element = $offset.element == 0xFFFFFFFFL ? $this_readCentralDirectoryZipEntry.readLongLe() : 0L;
                break;
            }
            case 10: {
                if (dataSize < 4L) {
                    throw new IOException("bad zip: NTFS extra too short");
                }
                $this_readCentralDirectoryZipEntry.skip(4L);
                ZipFilesKt.readExtra($this_readCentralDirectoryZipEntry, (int)(dataSize - 4L), (Function2<? super Integer, ? super Long, Unit>)((Function2)(arg_0, arg_1) -> ZipFilesKt.readCentralDirectoryZipEntry$lambda$8$lambda$7($ntfsLastModifiedAtFiletime, $this_readCentralDirectoryZipEntry, $ntfsLastAccessedAtFiletime, $ntfsCreatedAtFiletime, arg_0, arg_1)));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit readOrSkipLocalHeader$lambda$10(BufferedSource $this_readOrSkipLocalHeader, Ref.ObjectRef $extendedLastModifiedAtSeconds, Ref.ObjectRef $extendedLastAccessedAtSeconds, Ref.ObjectRef $extendedCreatedAtSeconds, int headerId, long dataSize) {
        if (headerId == 21589) {
            long requiredSize;
            if (dataSize < 1L) {
                throw new IOException("bad zip: extended timestamp extra too short");
            }
            int flags = $this_readOrSkipLocalHeader.readByte() & 0xFF;
            boolean hasLastModifiedAtMillis = (flags & 1) == 1;
            boolean hasLastAccessedAtMillis = (flags & 2) == 2;
            boolean hasCreatedAtMillis = (flags & 4) == 4;
            long result = 1L;
            if (hasLastModifiedAtMillis) {
                result = 5L;
            }
            if (hasLastAccessedAtMillis) {
                result += 4L;
            }
            if (hasCreatedAtMillis) {
                result += 4L;
            }
            if (dataSize < (requiredSize = result)) {
                throw new IOException("bad zip: extended timestamp extra too short");
            }
            if (hasLastModifiedAtMillis) {
                var1_1.element = $this_readOrSkipLocalHeader.readIntLe();
            }
            if (hasLastAccessedAtMillis) {
                var2_2.element = $this_readOrSkipLocalHeader.readIntLe();
            }
            if (hasCreatedAtMillis) {
                BufferedSource bufferedSource;
                var3_3.element = bufferedSource.readIntLe();
            }
        }
        return Unit.INSTANCE;
    }
}

