/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import okio.internal.ZipEntry;
import okio.internal.ZipFilesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0001\u0018\u0000 >2\u00020\u0001:\u0001>B#\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0019\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010\"\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010$\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b$\u0010#J\u001f\u0010&\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010)\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b)\u0010*J\u001f\u0010+\u001a\u00020%2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b+\u0010'J\u001f\u0010,\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b,\u0010*J\u0013\u0010.\u001a\u00020-*\u00020\tH\u0002\u00a2\u0006\u0004\b.\u0010/J%\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t000\u000f*\u00020\u0002H\u0002\u00a2\u0006\u0004\b1\u00102J!\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t\u0018\u000100*\u000203H\u0002\u00a2\u0006\u0004\b4\u00105J!\u00106\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t\u0018\u000100*\u000203H\u0002\u00a2\u0006\u0004\b6\u00105R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00107R\u0014\u0010\u0006\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u00108R-\u0010=\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t000\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<"}, d2={"Lokio/internal/ResourceFileSystem;", "Lokio/FileSystem;", "Ljava/lang/ClassLoader;", "classLoader", "", "indexEagerly", "systemFileSystem", "<init>", "(Ljava/lang/ClassLoader;ZLokio/FileSystem;)V", "Lokio/Path;", "path", "canonicalize", "(Lokio/Path;)Lokio/Path;", "canonicalizeInternal", "dir", "", "list", "(Lokio/Path;)Ljava/util/List;", "listOrNull", "file", "Lokio/FileHandle;", "openReadOnly", "(Lokio/Path;)Lokio/FileHandle;", "mustCreate", "mustExist", "openReadWrite", "(Lokio/Path;ZZ)Lokio/FileHandle;", "Lokio/FileMetadata;", "metadataOrNull", "(Lokio/Path;)Lokio/FileMetadata;", "Lokio/Source;", "source", "(Lokio/Path;)Lokio/Source;", "Lokio/Sink;", "sink", "(Lokio/Path;Z)Lokio/Sink;", "appendingSink", "", "createDirectory", "(Lokio/Path;Z)V", "target", "atomicMove", "(Lokio/Path;Lokio/Path;)V", "delete", "createSymlink", "", "toRelativePath", "(Lokio/Path;)Ljava/lang/String;", "Lkotlin/Pair;", "toClasspathRoots", "(Ljava/lang/ClassLoader;)Ljava/util/List;", "Ljava/net/URL;", "toFileRoot", "(Ljava/net/URL;)Lkotlin/Pair;", "toJarRoot", "Ljava/lang/ClassLoader;", "Lokio/FileSystem;", "roots$delegate", "Lkotlin/Lazy;", "getRoots", "()Ljava/util/List;", "roots", "Companion"})
@SourceDebugExtension(value={"SMAP\nResourceFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceFileSystem.kt\nokio/internal/ResourceFileSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n774#2:216\n865#2,2:217\n1557#2:219\n1628#2,3:220\n774#2:223\n865#2,2:224\n1557#2:226\n1628#2,3:227\n1611#2,9:230\n1863#2:239\n1864#2:241\n1620#2:242\n1611#2,9:243\n1863#2:252\n1864#2:254\n1620#2:255\n1#3:240\n1#3:253\n*S KotlinDebug\n*F\n+ 1 ResourceFileSystem.kt\nokio/internal/ResourceFileSystem\n*L\n75#1:216\n75#1:217,2\n76#1:219\n76#1:220,3\n91#1:223\n91#1:224,2\n92#1:226\n92#1:227,3\n178#1:230,9\n178#1:239\n178#1:241\n178#1:242\n179#1:243,9\n179#1:252\n179#1:254\n179#1:255\n178#1:240\n179#1:253\n*E\n"})
public final class ResourceFileSystem
extends FileSystem {
    private static final Companion Companion = new Companion(null);
    private final ClassLoader classLoader;
    private final FileSystem systemFileSystem;
    private final Lazy roots$delegate;
    private static final Path ROOT = Path.Companion.get$default(Path.Companion, "/", false, 1, null);

    /*
     * WARNING - void declaration
     */
    public ResourceFileSystem(ClassLoader classLoader, boolean indexEagerly, FileSystem systemFileSystem) {
        void var2_2;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)systemFileSystem, (String)"systemFileSystem");
        this.classLoader = var1_1;
        this.systemFileSystem = var3_3;
        this.roots$delegate = LazyKt.lazy(() -> ResourceFileSystem.roots_delegate$lambda$0(this));
        if (var2_2 != false) {
            this.getRoots().size();
        }
    }

    public /* synthetic */ ResourceFileSystem(ClassLoader classLoader, boolean bl, FileSystem fileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fileSystem = FileSystem.SYSTEM;
        }
        this(classLoader, bl, fileSystem);
    }

    private final List<Pair<FileSystem, Path>> getRoots() {
        Lazy lazy = this.roots$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Path canonicalize(Path path) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.canonicalizeInternal((Path)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final Path canonicalizeInternal(Path path) {
        void var1_1;
        return ROOT.resolve((Path)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Path> list(Path dir) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        String relativePath = this.toRelativePath(dir);
        Set result = new LinkedHashSet();
        boolean foundAny = false;
        for (Pair<FileSystem, Path> pair : this.getRoots()) {
            Object fileSystem = (FileSystem)pair.component1();
            Path base = (Path)pair.component2();
            try {
                void $this$mapTo$iv$iv;
                Path it;
                Object $this$filterTo$iv$iv;
                Collection collection = result;
                Object object = fileSystem = (Iterable)((FileSystem)fileSystem).list(base.resolve(relativePath));
                Collection destination$iv$iv = new ArrayList();
                $this$filterTo$iv$iv = $this$filterTo$iv$iv.iterator();
                while ($this$filterTo$iv$iv.hasNext()) {
                    Object element$iv$iv = $this$filterTo$iv$iv.next();
                    it = (Path)element$iv$iv;
                    if (!okio.internal.ResourceFileSystem$Companion.access$keepPath(Companion, it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Path)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    collection2.add(Companion.removeBase(it, base));
                }
                Iterable iterable = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                foundAny = true;
            }
            catch (IOException iOException) {}
        }
        if (!foundAny) {
            void var1_1;
            throw new FileNotFoundException("file not found: " + var1_1);
        }
        return CollectionsKt.toList((Iterable)((Iterable)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Path> listOrNull(Path dir) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        String relativePath = this.toRelativePath(dir);
        Set result = new LinkedHashSet();
        boolean foundAny = false;
        for (Pair<FileSystem, Path> pair : this.getRoots()) {
            List baseResult;
            List list;
            Object fileSystem = (FileSystem)pair.component1();
            Path base = (Path)pair.component2();
            if ((fileSystem = ((FileSystem)fileSystem).listOrNull(base.resolve(relativePath))) != null) {
                void $this$mapTo$iv$iv;
                Path it;
                Object $this$filterTo$iv$iv;
                Object object = fileSystem = (Iterable)fileSystem;
                Collection destination$iv$iv = new ArrayList();
                $this$filterTo$iv$iv = $this$filterTo$iv$iv.iterator();
                while ($this$filterTo$iv$iv.hasNext()) {
                    Object element$iv$iv = $this$filterTo$iv$iv.next();
                    it = (Path)element$iv$iv;
                    if (!okio.internal.ResourceFileSystem$Companion.access$keepPath(Companion, it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    collection.add(Companion.removeBase(it, base));
                }
                list = (List)destination$iv$iv;
            } else {
                list = baseResult = null;
            }
            if (list == null) continue;
            CollectionsKt.addAll((Collection)result, (Iterable)baseResult);
            foundAny = true;
        }
        if (var3_3 != false) {
            void var2_2;
            return CollectionsKt.toList((Iterable)((Iterable)var2_2));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final FileHandle openReadOnly(Path file) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!okio.internal.ResourceFileSystem$Companion.access$keepPath(Companion, file)) {
            throw new FileNotFoundException("file not found: " + file);
        }
        String relativePath = this.toRelativePath(file);
        for (Pair<FileSystem, Path> pair : this.getRoots()) {
            FileSystem fileSystem = (FileSystem)pair.component1();
            Path base = (Path)pair.component2();
            try {
                return fileSystem.openReadOnly(base.resolve(relativePath));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        throw new FileNotFoundException("file not found: " + var1_1);
    }

    @Override
    public final FileHandle openReadWrite(Path file, boolean mustCreate, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw new IOException("resources are not writable");
    }

    @Override
    public final FileMetadata metadataOrNull(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!okio.internal.ResourceFileSystem$Companion.access$keepPath(Companion, path)) {
            return null;
        }
        String relativePath = this.toRelativePath(path);
        for (Pair<FileSystem, Path> pair : this.getRoots()) {
            FileSystem fileSystem = (FileSystem)pair.component1();
            Path base = (Path)pair.component2();
            FileMetadata fileMetadata = fileSystem.metadataOrNull(pair.resolve(relativePath));
            if (fileMetadata == null) continue;
            return fileMetadata;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Source source(Path file) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!okio.internal.ResourceFileSystem$Companion.access$keepPath(Companion, (Path)file)) {
            throw new FileNotFoundException("file not found: " + file);
        }
        Path relativePath = Path.resolve$default(ROOT, (Path)file, false, 2, null).relativeTo(ROOT);
        URL uRL = this.classLoader.getResource(var2_2.toString());
        if (uRL == null) {
            throw new FileNotFoundException("file not found: " + file);
        }
        file = uRL;
        URLConnection urlConnection = uRL.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            ((JarURLConnection)urlConnection).setUseCaches(false);
        }
        InputStream inputStream2 = var1_1.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
        return Okio.source(inputStream2);
    }

    @Override
    public final Sink sink(Path file, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw new IOException(this + " is read-only");
    }

    @Override
    public final Sink appendingSink(Path file, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw new IOException(this + " is read-only");
    }

    @Override
    public final void createDirectory(Path dir, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        throw new IOException(this + " is read-only");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void atomicMove(Path source2, Path target) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"target");
        throw new IOException(this + " is read-only");
    }

    @Override
    public final void delete(Path path, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        throw new IOException(this + " is read-only");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void createSymlink(Path source2, Path target) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"target");
        throw new IOException(this + " is read-only");
    }

    private final String toRelativePath(Path $this$toRelativePath) {
        Path path;
        path = this.canonicalizeInternal(path);
        return path.relativeTo(ROOT).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<FileSystem, Path>> toClasspathRoots(ClassLoader $this$toClasspathRoots) {
        void var3_3;
        Collection collection;
        Object it$iv$iv;
        URL it;
        Iterator $this$mapNotNullTo$iv$iv;
        Enumeration<URL> enumeration = $this$toClasspathRoots.getResources("");
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
        ArrayList<URL> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Object object = arrayList;
        Collection destination$iv$iv = new ArrayList();
        $this$mapNotNullTo$iv$iv = $this$mapNotNullTo$iv$iv.iterator();
        while ($this$mapNotNullTo$iv$iv.hasNext()) {
            Object t = $this$mapNotNullTo$iv$iv.next();
            Object t2 = t;
            t2 = t;
            it = (URL)t;
            Intrinsics.checkNotNull((Object)it);
            if (this.toFileRoot(it) == null) continue;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection collection2 = (List)destination$iv$iv;
        Enumeration<URL> enumeration2 = ((ClassLoader)((Object)collection)).getResources("META-INF/MANIFEST.MF");
        Intrinsics.checkNotNullExpressionValue(enumeration2, (String)"getResources(...)");
        ArrayList<URL> arrayList2 = Collections.list(enumeration2);
        Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"list(...)");
        Iterable $this$mapNotNull$iv = arrayList2;
        collection = collection2;
        destination$iv$iv = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            it$iv$iv = e;
            it$iv$iv = e;
            it = (URL)e;
            Intrinsics.checkNotNull((Object)it);
            Pair<FileSystem, Path> pair = this.toJarRoot(it);
            if (pair == null) continue;
            it$iv$iv = pair;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<FileSystem, Path> toFileRoot(URL $this$toFileRoot) {
        void var1_1;
        if (!Intrinsics.areEqual((Object)$this$toFileRoot.getProtocol(), (Object)"file")) {
            return null;
        }
        return TuplesKt.to((Object)this.systemFileSystem, (Object)Path.Companion.get$default(Path.Companion, new File(var1_1.toURI()), false, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<FileSystem, Path> toJarRoot(URL $this$toJarRoot) {
        void var2_2;
        Object object;
        String string = $this$toJarRoot.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String urlString = string;
        if (!StringsKt.startsWith$default((String)string, (String)"jar:file:", (boolean)false, (int)2, null)) {
            return null;
        }
        int suffixStart = StringsKt.lastIndexOf$default((CharSequence)urlString, (String)"!", (int)0, (boolean)false, (int)6, null);
        if (suffixStart == -1) {
            return null;
        }
        String string2 = ((String)object).substring(4, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        object = Path.Companion.get$default(Path.Companion, new File(URI.create(string2)), false, 1, null);
        object = ZipFilesKt.openZip((Path)object, this.systemFileSystem, (Function1<? super ZipEntry, Boolean>)((Function1)ResourceFileSystem::toJarRoot$lambda$7));
        return TuplesKt.to((Object)object, (Object)ROOT);
    }

    private static final List roots_delegate$lambda$0(ResourceFileSystem this$0) {
        ResourceFileSystem resourceFileSystem = this$0;
        return resourceFileSystem.toClasspathRoots(resourceFileSystem.classLoader);
    }

    private static final boolean toJarRoot$lambda$7(ZipEntry entry) {
        ZipEntry zipEntry;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return okio.internal.ResourceFileSystem$Companion.access$keepPath(Companion, zipEntry.getCanonicalPath());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f"}, d2={"Lokio/internal/ResourceFileSystem$Companion;", "", "<init>", "()V", "Lokio/Path;", "base", "removeBase", "(Lokio/Path;Lokio/Path;)Lokio/Path;", "path", "", "keepPath", "(Lokio/Path;)Z", "ROOT", "Lokio/Path;", "getROOT", "()Lokio/Path;"})
    private static final class Companion {
        private Companion() {
        }

        public final Path getROOT() {
            return ROOT;
        }

        /*
         * WARNING - void declaration
         */
        public final Path removeBase(Path $this$removeBase, Path base) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$removeBase, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            String prefix = base.toString();
            return this.getROOT().resolve(StringsKt.replace$default((String)StringsKt.removePrefix((String)var1_1.toString(), (CharSequence)((CharSequence)var2_2)), (char)'\\', (char)'/', (boolean)false, (int)4, null));
        }

        private final boolean keepPath(Path path) {
            return !StringsKt.endsWith((String)path.name(), (String)".class", (boolean)true);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ boolean access$keepPath(Companion $this, Path path) {
            void var1_1;
            return $this.keepPath((Path)var1_1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

