/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ForwardingSource;
import okio.Source;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0011\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013"}, d2={"Lokio/internal/FixedLengthSource;", "Lokio/ForwardingSource;", "Lokio/Source;", "delegate", "", "size", "", "truncate", "<init>", "(Lokio/Source;JZ)V", "Lokio/Buffer;", "sink", "byteCount", "read", "(Lokio/Buffer;J)J", "newSize", "", "truncateToSize", "(Lokio/Buffer;J)V", "J", "Z", "bytesReceived"})
public final class FixedLengthSource
extends ForwardingSource {
    private final long size;
    private final boolean truncate;
    private long bytesReceived;

    /*
     * WARNING - void declaration
     */
    public FixedLengthSource(Source delegate, long size, boolean truncate) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        super((Source)var1_1);
        this.size = var2_2;
        this.truncate = truncate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(Buffer sink2, long byteCount) {
        long l;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        if (this.bytesReceived > this.size) {
            l = 0L;
        } else if (this.truncate) {
            long remaining = this.size - this.bytesReceived;
            if (remaining == 0L) {
                return -1L;
            }
            l = Math.min(byteCount, remaining);
        } else {
            void var2_2;
            l = var2_2;
        }
        long toRead = l;
        long result = super.read(sink2, toRead);
        if (result != -1L) {
            this.bytesReceived += result;
        }
        if (this.bytesReceived < this.size && result == -1L || this.bytesReceived > this.size) {
            if (result > 0L && this.bytesReceived > this.size) {
                void var1_1;
                void v1 = var1_1;
                this.truncateToSize((Buffer)v1, v1.size() - (this.bytesReceived - this.size));
            }
            throw new IOException("expected " + this.size + " bytes but got " + this.bytesReceived);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void truncateToSize(Buffer $this$truncateToSize, long newSize) {
        void var2_2;
        void var1_1;
        Buffer scratch = new Buffer();
        scratch.writeAll($this$truncateToSize);
        var1_1.write(scratch, (long)var2_2);
        scratch.clear();
    }
}

