/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.ByteString;
import okio.Path;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u000e\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0013\u0010\u0005\u001a\u00020\u0004*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a#\u0010\t\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001b\u0010\f\u001a\u00020\u0000*\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a\u001b\u0010\u000f\u001a\u00020\u0000*\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0015\u001a\u001b\u0010\u0017\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\"\u0014\u0010\u0019\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\"\u0014\u0010\u001b\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001a\"\u0014\u0010\u001c\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001a\"\u0014\u0010\u001d\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001a\"\u0014\u0010\u001e\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001a\"\u0018\u0010 \u001a\u00020\u0001*\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0003\"\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u0011*\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\""}, d2={"Lokio/Path;", "", "rootLength", "(Lokio/Path;)I", "", "lastSegmentIsDotDot", "(Lokio/Path;)Z", "child", "normalize", "commonResolve", "(Lokio/Path;Lokio/Path;Z)Lokio/Path;", "", "commonToPath", "(Ljava/lang/String;Z)Lokio/Path;", "Lokio/Buffer;", "toPath", "(Lokio/Buffer;Z)Lokio/Path;", "Lokio/ByteString;", "toSlash", "(Ljava/lang/String;)Lokio/ByteString;", "", "(B)Lokio/ByteString;", "slash", "startsWithVolumeLetterAndColon", "(Lokio/Buffer;Lokio/ByteString;)Z", "SLASH", "Lokio/ByteString;", "BACKSLASH", "ANY_SLASH", "DOT", "DOT_DOT", "getIndexOfLastSlash", "indexOfLastSlash", "getSlash", "(Lokio/Path;)Lokio/ByteString;"})
@JvmName(name="-Path")
@SourceDebugExtension(value={"SMAP\nPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Path.kt\nokio/internal/-Path\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,405:1\n53#1,22:406\n203#1:432\n203#1:433\n1557#2:428\n1628#2,3:429\n*S KotlinDebug\n*F\n+ 1 Path.kt\nokio/internal/-Path\n*L\n47#1:406,22\n193#1:432\n198#1:433\n47#1:428\n47#1:429,3\n*E\n"})
public final class -Path {
    private static final ByteString SLASH = ByteString.Companion.encodeUtf8("/");
    private static final ByteString BACKSLASH = ByteString.Companion.encodeUtf8("\\");
    private static final ByteString ANY_SLASH = ByteString.Companion.encodeUtf8("/\\");
    private static final ByteString DOT = ByteString.Companion.encodeUtf8(".");
    private static final ByteString DOT_DOT = ByteString.Companion.encodeUtf8("..");

    /*
     * WARNING - void declaration
     */
    private static final int rootLength(Path $this$rootLength) {
        if ($this$rootLength.getBytes$okio().size() == 0) {
            return -1;
        }
        if ($this$rootLength.getBytes$okio().getByte(0) == 47) {
            return 1;
        }
        if ($this$rootLength.getBytes$okio().getByte(0) == 92) {
            if ($this$rootLength.getBytes$okio().size() > 2 && $this$rootLength.getBytes$okio().getByte(1) == 92) {
                int uncRootEnd = $this$rootLength.getBytes$okio().indexOf(BACKSLASH, 2);
                if (uncRootEnd == -1) {
                    uncRootEnd = $this$rootLength.getBytes$okio().size();
                }
                return uncRootEnd;
            }
            return 1;
        }
        if ($this$rootLength.getBytes$okio().size() > 2 && $this$rootLength.getBytes$okio().getByte(1) == 58 && $this$rootLength.getBytes$okio().getByte(2) == 92) {
            Path path;
            char c = (char)path.getBytes$okio().getByte(0);
            if (!('a' <= c ? c < '{' : false)) {
                void var1_2;
                if (!('A' <= c ? var1_2 < 91 : false)) {
                    return -1;
                }
            }
            return 3;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static final int getIndexOfLastSlash(Path $this$indexOfLastSlash) {
        Path path;
        int lastSlash = ByteString.lastIndexOf$default($this$indexOfLastSlash.getBytes$okio(), SLASH, 0, 2, null);
        if (lastSlash != -1) {
            void var1_1;
            return (int)var1_1;
        }
        return ByteString.lastIndexOf$default(path.getBytes$okio(), BACKSLASH, 0, 2, null);
    }

    private static final boolean lastSegmentIsDotDot(Path $this$lastSegmentIsDotDot) {
        if ($this$lastSegmentIsDotDot.getBytes$okio().endsWith(DOT_DOT)) {
            Path path;
            if ($this$lastSegmentIsDotDot.getBytes$okio().size() == 2) {
                return true;
            }
            if ($this$lastSegmentIsDotDot.getBytes$okio().rangeEquals($this$lastSegmentIsDotDot.getBytes$okio().size() - 3, SLASH, 0, 1)) {
                return true;
            }
            if ($this$lastSegmentIsDotDot.getBytes$okio().rangeEquals(path.getBytes$okio().size() - 3, BACKSLASH, 0, 1)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final Path commonResolve(Path $this$commonResolve, Path child, boolean normalize) {
        void var2_2;
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$commonResolve, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (child.isAbsolute() || child.volumeLetter() != null) {
            return child;
        }
        ByteString byteString = -Path.getSlash($this$commonResolve);
        if (byteString == null && (byteString = -Path.getSlash(child)) == null) {
            byteString = -Path.toSlash(Path.DIRECTORY_SEPARATOR);
        }
        ByteString slash = byteString;
        Buffer buffer = new Buffer();
        buffer.write(path.getBytes$okio());
        if (buffer.size() > 0L) {
            void var3_3;
            buffer.write((ByteString)var3_3);
        }
        buffer.write(var1_1.getBytes$okio());
        return -Path.toPath(buffer, (boolean)var2_2);
    }

    private static final ByteString getSlash(Path $this$slash) {
        Path path;
        if (ByteString.indexOf$default($this$slash.getBytes$okio(), SLASH, 0, 2, null) != -1) {
            return SLASH;
        }
        if (ByteString.indexOf$default(path.getBytes$okio(), BACKSLASH, 0, 2, null) != -1) {
            return BACKSLASH;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static final Path commonToPath(String $this$commonToPath, boolean normalize) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$commonToPath, (String)"<this>");
        return -Path.toPath(new Buffer().writeUtf8(string), (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final Path toPath(Buffer $this$toPath, boolean normalize) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        ByteString slash = null;
        Buffer result = new Buffer();
        int leadingSlashCount = 0;
        while ($this$toPath.rangeEquals(0L, SLASH) || $this$toPath.rangeEquals(0L, BACKSLASH)) {
            byte by = $this$toPath.readByte();
            ByteString byteString = slash;
            if (byteString == null) {
                byteString = -Path.toSlash(by);
            }
            slash = byteString;
            ++leadingSlashCount;
        }
        boolean windowsUncPath = leadingSlashCount >= 2 && Intrinsics.areEqual((Object)slash, (Object)BACKSLASH);
        if (windowsUncPath) {
            ByteString byteString = slash;
            Intrinsics.checkNotNull((Object)byteString);
            result.write(byteString);
            result.write(slash);
        } else if (leadingSlashCount > 0) {
            ByteString byteString = slash;
            Intrinsics.checkNotNull((Object)byteString);
            result.write(byteString);
        } else {
            long limit = $this$toPath.indexOfElement(ANY_SLASH);
            ByteString byteString = slash;
            if (byteString == null) {
                byteString = limit == -1L ? -Path.toSlash(Path.DIRECTORY_SEPARATOR) : -Path.toSlash($this$toPath.getByte(limit));
            }
            if (-Path.startsWithVolumeLetterAndColon($this$toPath, slash = byteString)) {
                if (limit == 2L) {
                    result.write($this$toPath, 3L);
                } else {
                    result.write($this$toPath, 2L);
                }
            }
        }
        boolean absolute = result.size() > 0L;
        List canonicalParts = new ArrayList();
        while (!$this$toPath.exhausted()) {
            ByteString part;
            long limit = $this$toPath.indexOfElement(ANY_SLASH);
            if (limit == -1L) {
                part = $this$toPath.readByteString();
            } else {
                part = $this$toPath.readByteString(limit);
                $this$toPath.readByte();
            }
            if (Intrinsics.areEqual((Object)part, (Object)DOT_DOT)) {
                if (absolute && canonicalParts.isEmpty()) continue;
                if (!normalize || !absolute && (canonicalParts.isEmpty() || Intrinsics.areEqual((Object)CollectionsKt.last((List)canonicalParts), (Object)DOT_DOT))) {
                    canonicalParts.add(part);
                    continue;
                }
                if (windowsUncPath && canonicalParts.size() == 1) continue;
                CollectionsKt.removeLastOrNull((List)canonicalParts);
                continue;
            }
            if (Intrinsics.areEqual((Object)part, (Object)DOT) || Intrinsics.areEqual((Object)part, (Object)ByteString.EMPTY)) continue;
            canonicalParts.add(part);
        }
        int n = canonicalParts.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                result.write(slash);
            }
            result.write((ByteString)canonicalParts.get(i));
        }
        if (result.size() == 0L) {
            result.write(DOT);
        }
        return new Path(var3_3.readByteString());
    }

    private static final ByteString toSlash(String $this$toSlash) {
        String string;
        String string2 = $this$toSlash;
        if (Intrinsics.areEqual((Object)string2, (Object)"/")) {
            return SLASH;
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"\\")) {
            return BACKSLASH;
        }
        throw new IllegalArgumentException("not a directory separator: " + string);
    }

    private static final ByteString toSlash(byte $this$toSlash) {
        byte by;
        switch ($this$toSlash) {
            case 47: {
                return SLASH;
            }
            case 92: {
                return BACKSLASH;
            }
        }
        throw new IllegalArgumentException("not a directory separator: " + by);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean startsWithVolumeLetterAndColon(Buffer $this$startsWithVolumeLetterAndColon, ByteString slash) {
        block7: {
            block6: {
                void var0_1;
                if (!Intrinsics.areEqual((Object)slash, (Object)BACKSLASH)) {
                    return false;
                }
                if ($this$startsWithVolumeLetterAndColon.size() < 2L) {
                    return false;
                }
                if ($this$startsWithVolumeLetterAndColon.getByte(1L) != 58) {
                    return false;
                }
                char b = (char)$this$startsWithVolumeLetterAndColon.getByte(0L);
                if ('a' <= b ? b < '{' : false) break block6;
                boolean bl = 'A' <= b ? var0_1 < 91 : false;
                if (!bl) break block7;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ int access$rootLength(Path $receiver) {
        return -Path.rootLength($receiver);
    }

    public static final /* synthetic */ ByteString access$getSLASH$p() {
        return SLASH;
    }

    public static final /* synthetic */ int access$getIndexOfLastSlash(Path $receiver) {
        return -Path.getIndexOfLastSlash($receiver);
    }

    public static final /* synthetic */ ByteString access$getDOT$p() {
        return DOT;
    }

    public static final /* synthetic */ ByteString access$getBACKSLASH$p() {
        return BACKSLASH;
    }

    public static final /* synthetic */ boolean access$lastSegmentIsDotDot(Path $receiver) {
        return -Path.lastSegmentIsDotDot($receiver);
    }

    public static final /* synthetic */ ByteString access$getDOT_DOT$p() {
        return DOT_DOT;
    }

    public static final /* synthetic */ ByteString access$getSlash(Path $receiver) {
        return -Path.getSlash($receiver);
    }

    public static final /* synthetic */ ByteString access$toSlash(String $receiver) {
        return -Path.toSlash($receiver);
    }
}

