/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000f\u001a\u00020\u0002*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u0002*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\tR\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u00188\u0006\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a"}, d2={"Lokio/Throttler;", "", "", "allocatedUntil", "<init>", "(J)V", "()V", "byteCount", "take$okio", "(J)J", "take", "now", "byteCountOrWaitNanos$okio", "(JJ)J", "byteCountOrWaitNanos", "nanosToBytes", "bytesToNanos", "J", "bytesPerSecond", "waitByteCount", "maxByteCount", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Ljava/util/concurrent/locks/Condition;", "condition", "Ljava/util/concurrent/locks/Condition;"})
public final class Throttler {
    private long allocatedUntil;
    private long bytesPerSecond;
    private long waitByteCount;
    private long maxByteCount;
    public final ReentrantLock lock;
    public final Condition condition;

    /*
     * WARNING - void declaration
     */
    public Throttler(long allocatedUntil) {
        void var1_1;
        this.allocatedUntil = var1_1;
        this.waitByteCount = 8192L;
        this.maxByteCount = 262144L;
        this.lock = new ReentrantLock();
        Condition condition = this.lock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"newCondition(...)");
        this.condition = condition;
    }

    public Throttler() {
        this(System.nanoTime());
    }

    public final long take$okio(long byteCount2) {
        if (!(byteCount2 > 0L)) {
            String byteCount2 = "Failed requirement.";
            throw new IllegalArgumentException(byteCount2.toString());
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            while (true) {
                long byteCount2;
                long now;
                long byteCountOrWaitNanos;
                if ((byteCountOrWaitNanos = this.byteCountOrWaitNanos$okio(now = System.nanoTime(), byteCount2)) >= 0L) {
                    long l = byteCountOrWaitNanos;
                    return l;
                }
                this.condition.awaitNanos(-byteCountOrWaitNanos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final long byteCountOrWaitNanos$okio(long now, long byteCount) {
        void var3_2;
        if (this.bytesPerSecond == 0L) {
            return byteCount;
        }
        long idleInNanos = Math.max(this.allocatedUntil - now, 0L);
        long immediateBytes = this.maxByteCount - this.nanosToBytes(idleInNanos);
        if (immediateBytes >= byteCount) {
            this.allocatedUntil = now + idleInNanos + this.bytesToNanos(byteCount);
            return byteCount;
        }
        if (immediateBytes >= this.waitByteCount) {
            Throttler throttler = this;
            this.allocatedUntil = now + throttler.bytesToNanos(throttler.maxByteCount);
            return immediateBytes;
        }
        long minByteCount = Math.min(this.waitByteCount, (long)var3_2);
        long minWaitNanos = idleInNanos + this.bytesToNanos(minByteCount - this.maxByteCount);
        if (minWaitNanos == 0L) {
            void var1_1;
            Throttler throttler = this;
            this.allocatedUntil = var1_1 + throttler.bytesToNanos(throttler.maxByteCount);
            return minByteCount;
        }
        return -minWaitNanos;
    }

    private final long nanosToBytes(long $this$nanosToBytes) {
        return $this$nanosToBytes * this.bytesPerSecond / 1000000000L;
    }

    private final long bytesToNanos(long $this$bytesToNanos) {
        return $this$bytesToNanos * 1000000000L / this.bytesPerSecond;
    }
}

