/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.ByteString;
import okio.Segment;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0001H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016J\u0015\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0018J\u001d\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u000fH\u0016J\u001c\u0010\u001d\u001a\u00020\u00012\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u001fH\u0016J\u0015\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020\u0004H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J%\u0010*\u001a\u00020+2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b2J(\u00103\u001a\u0002042\u0006\u00100\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fH\u0016J(\u00103\u001a\u0002042\u0006\u00100\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fH\u0016J,\u00107\u001a\u00020+2\b\b\u0002\u00100\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u00042\b\b\u0002\u00109\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001fH\u0016J\u001a\u0010:\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u00042\b\b\u0002\u0010;\u001a\u00020\u001fH\u0016J\u001a\u0010<\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u00042\b\b\u0002\u0010;\u001a\u00020\u001fH\u0016J\b\u0010=\u001a\u00020\u0001H\u0002J\r\u0010>\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b?J\u0013\u0010@\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010AH\u0096\u0002J\b\u0010B\u001a\u00020\u001fH\u0016J\b\u0010C\u001a\u00020\u000fH\u0016J\b\u0010D\u001a\u00020EH\u0002R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006F"}, d2={"Lokio/SegmentedByteString;", "Lokio/ByteString;", "segments", "", "", "directory", "", "<init>", "([[B[I)V", "getSegments$okio", "()[[B", "[[B", "getDirectory$okio", "()[I", "string", "", "charset", "Ljava/nio/charset/Charset;", "base64", "hex", "toAsciiLowercase", "toAsciiUppercase", "digest", "algorithm", "digest$okio", "hmac", "key", "hmac$okio", "base64Url", "substring", "beginIndex", "", "endIndex", "internalGet", "", "pos", "internalGet$okio", "getSize", "getSize$okio", "toByteArray", "asByteBuffer", "Ljava/nio/ByteBuffer;", "write", "", "out", "Ljava/io/OutputStream;", "buffer", "Lokio/Buffer;", "offset", "byteCount", "write$okio", "rangeEquals", "", "other", "otherOffset", "copyInto", "target", "targetOffset", "indexOf", "fromIndex", "lastIndexOf", "toByteString", "internalArray", "internalArray$okio", "equals", "", "hashCode", "toString", "writeReplace", "Ljava/lang/Object;", "okio"})
@SourceDebugExtension(value={"SMAP\nSegmentedByteString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentedByteString.kt\nokio/SegmentedByteString\n+ 2 SegmentedByteString.kt\nokio/internal/-SegmentedByteString\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n63#2,12:141\n63#2,12:153\n104#2,2:165\n106#2,26:168\n135#2,5:194\n142#2:199\n145#2,3:200\n63#2,8:203\n148#2,8:211\n71#2,4:219\n156#2:223\n63#2,12:224\n160#2:236\n85#2,10:237\n161#2,9:247\n95#2,4:256\n170#2,2:260\n179#2,4:262\n85#2,10:266\n183#2,3:276\n95#2,4:279\n186#2:283\n195#2,8:284\n85#2,10:292\n203#2,3:302\n95#2,4:305\n206#2:309\n215#2,5:310\n85#2,10:315\n220#2,3:325\n95#2,4:328\n223#2:332\n226#2,4:333\n234#2,6:337\n63#2,8:343\n240#2,7:351\n71#2,4:358\n247#2,2:362\n1#3:167\n*S KotlinDebug\n*F\n+ 1 SegmentedByteString.kt\nokio/SegmentedByteString\n*L\n54#1:141,12\n66#1:153,12\n78#1:165,2\n78#1:168,26\n80#1:194,5\n82#1:199\n84#1:200,3\n84#1:203,8\n84#1:211,8\n84#1:219,4\n84#1:223\n90#1:224,12\n96#1:236\n96#1:237,10\n96#1:247,9\n96#1:256,4\n96#1:260,2\n103#1:262,4\n103#1:266,10\n103#1:276,3\n103#1:279,4\n103#1:283\n110#1:284,8\n110#1:292,10\n110#1:302,3\n110#1:305,4\n110#1:309\n117#1:310,5\n117#1:315,10\n117#1:325,3\n117#1:328,4\n117#1:332\n131#1:333,4\n133#1:337,6\n133#1:343,8\n133#1:351,7\n133#1:358,4\n133#1:362,2\n78#1:167\n*E\n"})
public final class SegmentedByteString
extends ByteString {
    private final transient byte[][] segments;
    private final transient int[] directory;

    /*
     * WARNING - void declaration
     */
    public SegmentedByteString(byte[][] segments, int[] directory) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        super(ByteString.EMPTY.getData$okio());
        this.segments = var1_1;
        this.directory = var2_2;
    }

    public final byte[][] getSegments$okio() {
        return this.segments;
    }

    public final int[] getDirectory$okio() {
        return this.directory;
    }

    @Override
    public final String base64() {
        return this.toByteString().base64();
    }

    @Override
    public final String hex() {
        return this.toByteString().hex();
    }

    @Override
    public final ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteString digest$okio(String algorithm) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        MessageDigest $this$digest_u24lambda_u241 = MessageDigest.getInstance(algorithm);
        SegmentedByteString $this$forEachSegment$iv = this;
        int segmentCount$iv = ((Object[])$this$forEachSegment$iv.getSegments$okio()).length;
        int pos$iv = 0;
        for (int s$iv = 0; s$iv < segmentCount$iv; ++s$iv) {
            void byteCount;
            void offset;
            int segmentPos$iv = $this$forEachSegment$iv.getDirectory$okio()[segmentCount$iv + s$iv];
            int nextSegmentOffset$iv = $this$forEachSegment$iv.getDirectory$okio()[s$iv];
            pos$iv = nextSegmentOffset$iv - pos$iv;
            byte[] data = $this$forEachSegment$iv.getSegments$okio()[s$iv];
            $this$digest_u24lambda_u241.update(data, (int)offset, (int)byteCount);
            int n = nextSegmentOffset$iv;
        }
        byte[] digestBytes = $this$digest_u24lambda_u241.digest();
        Intrinsics.checkNotNull((Object)digestBytes);
        return new ByteString((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteString substring(int beginIndex, int endIndex) {
        void var1_1;
        void var3_4;
        SegmentedByteString $this$commonSubstring$iv = this;
        int endIndex$iv2 = -SegmentedByteString.resolveDefaultParameter($this$commonSubstring$iv, endIndex);
        if (!(beginIndex >= 0)) {
            String string = "beginIndex=" + beginIndex + " < 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(endIndex$iv2 <= $this$commonSubstring$iv.size())) {
            String string = "endIndex=" + endIndex$iv2 + " > length(" + $this$commonSubstring$iv.size() + ')';
            throw new IllegalArgumentException(string.toString());
        }
        int subLen$iv = endIndex$iv2 - beginIndex;
        if (!(subLen$iv >= 0)) {
            String endIndex$iv2 = "endIndex=" + endIndex$iv2 + " < beginIndex=" + beginIndex;
            throw new IllegalArgumentException(endIndex$iv2.toString());
        }
        if (beginIndex == 0 && endIndex$iv2 == $this$commonSubstring$iv.size()) {
            return $this$commonSubstring$iv;
        }
        if (beginIndex == endIndex$iv2) {
            return ByteString.EMPTY;
        }
        int beginSegment$iv = okio.internal.-SegmentedByteString.segment($this$commonSubstring$iv, beginIndex);
        int endSegment$iv = okio.internal.-SegmentedByteString.segment($this$commonSubstring$iv, endIndex$iv2 - 1);
        Object[] objectArray = (Object[])$this$commonSubstring$iv.getSegments$okio();
        int n = endSegment$iv + 1;
        byte[][] newSegments$iv = (byte[][])ArraysKt.copyOfRange((Object[])objectArray, (int)beginSegment$iv, (int)n);
        int[] newDirectory$iv = new int[((Object[])newSegments$iv).length << 1];
        int index$iv = 0;
        int s$iv = beginSegment$iv;
        if (s$iv <= endSegment$iv) {
            while (true) {
                newDirectory$iv[index$iv] = Math.min($this$commonSubstring$iv.getDirectory$okio()[s$iv] - beginIndex, subLen$iv);
                newDirectory$iv[index$iv++ + ((Object[])newSegments$iv).length] = $this$commonSubstring$iv.getDirectory$okio()[s$iv + ((Object[])$this$commonSubstring$iv.getSegments$okio()).length];
                if (s$iv == endSegment$iv) break;
                ++s$iv;
            }
        }
        int segmentOffset$iv = beginSegment$iv == 0 ? 0 : var3_4.getDirectory$okio()[beginSegment$iv - 1];
        int n2 = ((Object[])newSegments$iv).length;
        newDirectory$iv[n2] = newDirectory$iv[n2] + (var1_1 - segmentOffset$iv);
        return new SegmentedByteString(newSegments$iv, newDirectory$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte internalGet$okio(int pos) {
        void var1_1;
        void var3_3;
        void var2_2;
        SegmentedByteString $this$commonInternalGet$iv = this;
        -SegmentedByteString.checkOffsetAndCount($this$commonInternalGet$iv.getDirectory$okio()[((Object[])$this$commonInternalGet$iv.getSegments$okio()).length - 1], pos, 1L);
        int segment$iv = okio.internal.-SegmentedByteString.segment($this$commonInternalGet$iv, pos);
        int segmentOffset$iv = segment$iv == 0 ? 0 : $this$commonInternalGet$iv.getDirectory$okio()[segment$iv - 1];
        int segmentPos$iv = $this$commonInternalGet$iv.getDirectory$okio()[segment$iv + ((Object[])$this$commonInternalGet$iv.getSegments$okio()).length];
        return var2_2.getSegments$okio()[var3_3][var1_1 - segmentOffset$iv + segmentPos$iv];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getSize$okio() {
        void var1_1;
        SegmentedByteString $this$commonGetSize$iv = this;
        return $this$commonGetSize$iv.getDirectory$okio()[((Object[])var1_1.getSegments$okio()).length - 1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] toByteArray() {
        void var2_2;
        SegmentedByteString $this$commonToByteArray$iv = this;
        byte[] result$iv = new byte[$this$commonToByteArray$iv.size()];
        int resultPos$iv = 0;
        SegmentedByteString $this$forEachSegment$iv$iv = $this$commonToByteArray$iv;
        int segmentCount$iv$iv = ((Object[])$this$forEachSegment$iv$iv.getSegments$okio()).length;
        int pos$iv$iv = 0;
        for (int s$iv$iv = 0; s$iv$iv < segmentCount$iv$iv; ++s$iv$iv) {
            void byteCount$iv;
            void offset$iv;
            int segmentPos$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[segmentCount$iv$iv + s$iv$iv];
            int nextSegmentOffset$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv];
            pos$iv$iv = nextSegmentOffset$iv$iv - pos$iv$iv;
            byte[] byArray = $this$forEachSegment$iv$iv.getSegments$okio()[s$iv$iv];
            void v0 = offset$iv;
            ArraysKt.copyInto((byte[])byArray, (byte[])result$iv, (int)resultPos$iv, (int)v0, (int)(v0 + byteCount$iv));
            resultPos$iv += byteCount$iv;
            int n = nextSegmentOffset$iv$iv;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write$okio(Buffer buffer, int offset, int byteCount) {
        void var3_3;
        void var1_1;
        void pos$iv$iv;
        void $this$forEachSegment$iv$iv;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        SegmentedByteString segmentedByteString = this;
        int endIndex$iv$iv = offset + byteCount;
        int s$iv$iv = okio.internal.-SegmentedByteString.segment((SegmentedByteString)$this$forEachSegment$iv$iv, offset);
        while (pos$iv$iv < endIndex$iv$iv) {
            void byteCount$iv;
            void offset$iv;
            int offset$iv$iv;
            int segmentOffset$iv$iv = s$iv$iv == 0 ? 0 : $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv - 1];
            int segmentSize$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv] - segmentOffset$iv$iv;
            int segmentPos$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[((Object[])$this$forEachSegment$iv$iv.getSegments$okio()).length + s$iv$iv];
            int byteCount$iv$iv = Math.min(endIndex$iv$iv, segmentOffset$iv$iv + segmentSize$iv$iv) - pos$iv$iv;
            int n = offset$iv$iv = segmentPos$iv$iv + (pos$iv$iv - segmentOffset$iv$iv);
            offset$iv$iv = byteCount$iv$iv;
            segmentPos$iv$iv = n;
            byte[] data$iv = $this$forEachSegment$iv$iv.getSegments$okio()[s$iv$iv];
            void v1 = offset$iv;
            Segment segment$iv = new Segment(data$iv, (int)v1, (int)(v1 + byteCount$iv), true, false);
            if (buffer.head == null) {
                buffer.head = segment$iv.next = (segment$iv.prev = segment$iv);
            } else {
                Segment segment = buffer.head;
                Intrinsics.checkNotNull((Object)segment);
                Segment segment2 = segment.prev;
                Intrinsics.checkNotNull((Object)segment2);
                segment2.push(segment$iv);
            }
            pos$iv$iv += byteCount$iv$iv;
            ++s$iv$iv;
        }
        void v4 = var1_1;
        v4.setSize$okio(v4.size() + (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean rangeEquals(int offset, ByteString other, int otherOffset, int byteCount) {
        void pos$iv$iv;
        void $this$forEachSegment$iv$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        SegmentedByteString $this$commonRangeEquals$iv = this;
        if (offset < 0 || offset > $this$commonRangeEquals$iv.size() - byteCount) {
            return false;
        }
        int endIndex$iv$iv = offset + byteCount;
        int s$iv$iv = okio.internal.-SegmentedByteString.segment((SegmentedByteString)$this$forEachSegment$iv$iv, offset);
        while (pos$iv$iv < endIndex$iv$iv) {
            void byteCount$iv;
            void offset$iv;
            void otherOffset$iv;
            int offset$iv$iv;
            int segmentOffset$iv$iv = s$iv$iv == 0 ? 0 : $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv - 1];
            int segmentSize$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv] - segmentOffset$iv$iv;
            int segmentPos$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[((Object[])$this$forEachSegment$iv$iv.getSegments$okio()).length + s$iv$iv];
            int byteCount$iv$iv = Math.min(endIndex$iv$iv, segmentOffset$iv$iv + segmentSize$iv$iv) - pos$iv$iv;
            int n = offset$iv$iv = segmentPos$iv$iv + (pos$iv$iv - segmentOffset$iv$iv);
            offset$iv$iv = byteCount$iv$iv;
            segmentPos$iv$iv = n;
            byte[] data$iv = $this$forEachSegment$iv$iv.getSegments$okio()[s$iv$iv];
            if (!other.rangeEquals((int)otherOffset$iv, data$iv, (int)offset$iv, (int)byteCount$iv)) {
                return false;
            }
            otherOffset$iv += byteCount$iv;
            pos$iv$iv += byteCount$iv$iv;
            ++s$iv$iv;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean rangeEquals(int offset, byte[] other, int otherOffset, int byteCount) {
        void pos$iv$iv;
        void $this$forEachSegment$iv$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        SegmentedByteString $this$commonRangeEquals$iv = this;
        if (offset < 0 || offset > $this$commonRangeEquals$iv.size() - byteCount || otherOffset < 0 || otherOffset > other.length - byteCount) {
            return false;
        }
        int endIndex$iv$iv = offset + byteCount;
        int s$iv$iv = okio.internal.-SegmentedByteString.segment((SegmentedByteString)$this$forEachSegment$iv$iv, offset);
        while (pos$iv$iv < endIndex$iv$iv) {
            void byteCount$iv;
            void otherOffset$iv;
            void offset$iv;
            int offset$iv$iv;
            int segmentOffset$iv$iv = s$iv$iv == 0 ? 0 : $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv - 1];
            int segmentSize$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv] - segmentOffset$iv$iv;
            int segmentPos$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[((Object[])$this$forEachSegment$iv$iv.getSegments$okio()).length + s$iv$iv];
            int byteCount$iv$iv = Math.min(endIndex$iv$iv, segmentOffset$iv$iv + segmentSize$iv$iv) - pos$iv$iv;
            int n = offset$iv$iv = segmentPos$iv$iv + (pos$iv$iv - segmentOffset$iv$iv);
            offset$iv$iv = byteCount$iv$iv;
            segmentPos$iv$iv = n;
            byte[] byArray = $this$forEachSegment$iv$iv.getSegments$okio()[s$iv$iv];
            if (!-SegmentedByteString.arrayRangeEquals(byArray, (int)offset$iv, other, (int)otherOffset$iv, (int)byteCount$iv)) {
                return false;
            }
            otherOffset$iv += byteCount$iv;
            pos$iv$iv += byteCount$iv$iv;
            ++s$iv$iv;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int indexOf(byte[] other, int fromIndex) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toByteString().indexOf((byte[])var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lastIndexOf(byte[] other, int fromIndex) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toByteString().lastIndexOf((byte[])var1_1, (int)var2_2);
    }

    private final ByteString toByteString() {
        return new ByteString(((ByteString)this).toByteArray());
    }

    @Override
    public final byte[] internalArray$okio() {
        return ((ByteString)this).toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        SegmentedByteString $this$commonEquals$iv = this;
        if (other == $this$commonEquals$iv) {
            return true;
        }
        if (other instanceof ByteString) {
            void var2_2;
            void var1_1;
            return ((ByteString)other).size() == $this$commonEquals$iv.size() && ((ByteString)$this$commonEquals$iv).rangeEquals(0, (ByteString)var1_1, 0, var2_2.size());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var2_2;
        void var1_1;
        SegmentedByteString $this$commonHashCode$iv = this;
        int result$iv = $this$commonHashCode$iv.getHashCode$okio();
        if (result$iv != 0) {
            return result$iv;
        }
        result$iv = 1;
        SegmentedByteString $this$forEachSegment$iv$iv = $this$commonHashCode$iv;
        int segmentCount$iv$iv = ((Object[])$this$forEachSegment$iv$iv.getSegments$okio()).length;
        int pos$iv$iv = 0;
        for (int s$iv$iv = 0; s$iv$iv < segmentCount$iv$iv; ++s$iv$iv) {
            void byteCount$iv;
            void offset$iv;
            int segmentPos$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[segmentCount$iv$iv + s$iv$iv];
            int nextSegmentOffset$iv$iv = $this$forEachSegment$iv$iv.getDirectory$okio()[s$iv$iv];
            pos$iv$iv = nextSegmentOffset$iv$iv - pos$iv$iv;
            byte[] data$iv = $this$forEachSegment$iv$iv.getSegments$okio()[s$iv$iv];
            void limit$iv = offset$iv + byteCount$iv;
            for (void i$iv = offset$iv; i$iv < limit$iv; ++i$iv) {
                result$iv = result$iv * 31 + data$iv[i$iv];
            }
            int n = nextSegmentOffset$iv$iv;
        }
        var1_1.setHashCode$okio(result$iv);
        return (int)var2_2;
    }

    @Override
    public final String toString() {
        return this.toByteString().toString();
    }
}

