/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.ByteString;
import okio.internal.-Path;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\b\u0007\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00014B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006H\u0087\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0087\u0002\u00a2\u0006\u0004\b\b\u0010\u000bJ\u001f\u0010\b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\b\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0010\u0010\u000bJ\r\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001a\u0010\u001d\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u001cH\u0096\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b!\u0010\"R\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010#\u001a\u0004\b$\u0010%R\u0013\u0010'\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010,\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0013\u0010/\u001a\u0004\u0018\u00010.8G\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b1\u0010%R\u0011\u00102\u001a\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b2\u0010\"R\u0013\u00103\u001a\u0004\u0018\u00010\u00008G\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0012"}, d2={"Lokio/Path;", "", "Lokio/ByteString;", "bytes", "<init>", "(Lokio/ByteString;)V", "", "child", "resolve", "(Ljava/lang/String;)Lokio/Path;", "div", "(Lokio/Path;)Lokio/Path;", "", "normalize", "(Lokio/Path;Z)Lokio/Path;", "other", "relativeTo", "normalized", "()Lokio/Path;", "Ljava/io/File;", "toFile", "()Ljava/io/File;", "Ljava/nio/file/Path;", "toNioPath", "()Ljava/nio/file/Path;", "", "compareTo", "(Lokio/Path;)I", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Lokio/ByteString;", "getBytes$okio", "()Lokio/ByteString;", "getRoot", "root", "", "getSegmentsBytes", "()Ljava/util/List;", "segmentsBytes", "isAbsolute", "()Z", "", "volumeLetter", "()Ljava/lang/Character;", "nameBytes", "name", "parent", "Companion"})
@SourceDebugExtension(value={"SMAP\nPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Path.kt\nokio/Path\n+ 2 Path.kt\nokio/internal/-Path\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n39#2,3:133\n47#2,28:136\n53#2,22:168\n106#2:190\n111#2:191\n116#2,6:192\n133#2,5:198\n143#2:203\n148#2,25:204\n188#2:229\n193#2,11:230\n198#2,6:241\n193#2,11:247\n198#2,6:258\n222#2,41:264\n267#2:305\n281#2:306\n286#2:307\n291#2:308\n296#2:309\n1557#3:164\n1628#3,3:165\n*S KotlinDebug\n*F\n+ 1 Path.kt\nokio/Path\n*L\n44#1:133,3\n47#1:136,28\n50#1:168,22\n53#1:190\n56#1:191\n60#1:192,6\n64#1:198,5\n68#1:203\n72#1:204,25\n75#1:229\n78#1:230,11\n81#1:241,6\n87#1:247,11\n90#1:258,6\n95#1:264,41\n97#1:305\n104#1:306\n106#1:307\n108#1:308\n110#1:309\n47#1:164\n47#1:165,3\n*E\n"})
public final class Path
implements Comparable<Path> {
    public static final Companion Companion = new Companion(null);
    private final ByteString bytes;
    @JvmField
    public static final String DIRECTORY_SEPARATOR;

    /*
     * WARNING - void declaration
     */
    public Path(ByteString bytes) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = var1_1;
    }

    public final ByteString getBytes$okio() {
        return this.bytes;
    }

    /*
     * WARNING - void declaration
     */
    public final Path getRoot() {
        void var2_2;
        void var1_1;
        Path $this$commonRoot$iv = this;
        int rootLength$iv = -Path.access$rootLength($this$commonRoot$iv);
        if (rootLength$iv == -1) {
            return null;
        }
        return new Path(var1_1.getBytes$okio().substring(0, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final List<ByteString> getSegmentsBytes() {
        void var2_2;
        Path $this$commonSegmentsBytes$iv = this;
        List result$iv = new ArrayList();
        int segmentStart$iv = -Path.access$rootLength($this$commonSegmentsBytes$iv);
        if (segmentStart$iv == -1) {
            segmentStart$iv = 0;
        } else if (segmentStart$iv < $this$commonSegmentsBytes$iv.getBytes$okio().size() && $this$commonSegmentsBytes$iv.getBytes$okio().getByte(segmentStart$iv) == 92) {
            ++segmentStart$iv;
        }
        int n = $this$commonSegmentsBytes$iv.getBytes$okio().size();
        for (int i$iv = segmentStart$iv; i$iv < n; ++i$iv) {
            if ($this$commonSegmentsBytes$iv.getBytes$okio().getByte(i$iv) != 47 && $this$commonSegmentsBytes$iv.getBytes$okio().getByte(i$iv) != 92) continue;
            ((Collection)result$iv).add($this$commonSegmentsBytes$iv.getBytes$okio().substring(segmentStart$iv, i$iv));
            segmentStart$iv = i$iv + 1;
        }
        if (segmentStart$iv < $this$commonSegmentsBytes$iv.getBytes$okio().size()) {
            void var1_1;
            void var3_3;
            ((Collection)result$iv).add($this$commonSegmentsBytes$iv.getBytes$okio().substring((int)var3_3, var1_1.getBytes$okio().size()));
        }
        return var2_2;
    }

    public final boolean isAbsolute() {
        Path path = this;
        return -Path.access$rootLength(path) != -1;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="volumeLetter")
    public final Character volumeLetter() {
        void var1_2;
        Path $this$commonVolumeLetter$iv = this;
        if (ByteString.indexOf$default($this$commonVolumeLetter$iv.getBytes$okio(), -Path.access$getSLASH$p(), 0, 2, null) != -1) {
            return null;
        }
        if ($this$commonVolumeLetter$iv.getBytes$okio().size() < 2) {
            return null;
        }
        if ($this$commonVolumeLetter$iv.getBytes$okio().getByte(1) != 58) {
            return null;
        }
        char c$iv = (char)$this$commonVolumeLetter$iv.getBytes$okio().getByte(0);
        if (!('a' <= c$iv ? c$iv < '{' : false)) {
            if (!('A' <= c$iv ? c$iv < '[' : false)) {
                return null;
            }
        }
        return Character.valueOf((char)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="nameBytes")
    public final ByteString nameBytes() {
        void var1_1;
        Path $this$commonNameBytes$iv = this;
        int lastSlash$iv = -Path.access$getIndexOfLastSlash($this$commonNameBytes$iv);
        if (lastSlash$iv != -1) {
            void var2_2;
            return ByteString.substring$default($this$commonNameBytes$iv.getBytes$okio(), (int)(var2_2 + true), 0, 2, null);
        }
        if ($this$commonNameBytes$iv.volumeLetter() != null && $this$commonNameBytes$iv.getBytes$okio().size() == 2) {
            return ByteString.EMPTY;
        }
        return var1_1.getBytes$okio();
    }

    @JvmName(name="name")
    public final String name() {
        Path path = this;
        return path.nameBytes().utf8();
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="parent")
    public final Path parent() {
        void var2_2;
        void var1_1;
        Path $this$commonParent$iv = this;
        if (Intrinsics.areEqual((Object)$this$commonParent$iv.getBytes$okio(), (Object)-Path.access$getDOT$p()) || Intrinsics.areEqual((Object)$this$commonParent$iv.getBytes$okio(), (Object)-Path.access$getSLASH$p()) || Intrinsics.areEqual((Object)$this$commonParent$iv.getBytes$okio(), (Object)-Path.access$getBACKSLASH$p()) || -Path.access$lastSegmentIsDotDot($this$commonParent$iv)) {
            return null;
        }
        int lastSlash$iv = -Path.access$getIndexOfLastSlash($this$commonParent$iv);
        if (lastSlash$iv == 2 && $this$commonParent$iv.volumeLetter() != null) {
            if ($this$commonParent$iv.getBytes$okio().size() == 3) {
                return null;
            }
            return new Path(ByteString.substring$default($this$commonParent$iv.getBytes$okio(), 0, 3, 1, null));
        }
        if (lastSlash$iv == 1 && $this$commonParent$iv.getBytes$okio().startsWith(-Path.access$getBACKSLASH$p())) {
            return null;
        }
        if (lastSlash$iv == -1 && $this$commonParent$iv.volumeLetter() != null) {
            if ($this$commonParent$iv.getBytes$okio().size() == 2) {
                return null;
            }
            return new Path(ByteString.substring$default($this$commonParent$iv.getBytes$okio(), 0, 2, 1, null));
        }
        if (lastSlash$iv == -1) {
            return new Path(-Path.access$getDOT$p());
        }
        if (lastSlash$iv == 0) {
            return new Path(ByteString.substring$default($this$commonParent$iv.getBytes$okio(), 0, 1, 1, null));
        }
        return new Path(ByteString.substring$default(var1_1.getBytes$okio(), 0, (int)var2_2, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="resolve")
    public final Path resolve(String child) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path path = this;
        Buffer child$iv$iv = new Buffer().writeUtf8(child);
        return -Path.commonResolve(path, -Path.toPath((Buffer)var1_1, false), false);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="resolve")
    public final Path resolve(Path child) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return -Path.commonResolve(this, (Path)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public final Path resolve(Path child, boolean normalize) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return -Path.commonResolve(this, (Path)var1_1, (boolean)var2_2);
    }

    public static /* synthetic */ Path resolve$default(Path path, Path path2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return path.resolve(path2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final Path relativeTo(Path other) {
        int i$iv;
        void var3_5;
        int firstNewSegmentIndex$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path $this$commonRelativeTo$iv = this;
        if (!Intrinsics.areEqual((Object)$this$commonRelativeTo$iv.getRoot(), (Object)((Path)other).getRoot())) {
            String string = "Paths of different roots cannot be relative to each other: " + $this$commonRelativeTo$iv + " and " + other;
            throw new IllegalArgumentException(string.toString());
        }
        List<ByteString> thisSegments$iv = $this$commonRelativeTo$iv.getSegmentsBytes();
        List<ByteString> otherSegments$iv = ((Path)other).getSegmentsBytes();
        int minSegmentsSize$iv = Math.min(thisSegments$iv.size(), otherSegments$iv.size());
        for (firstNewSegmentIndex$iv = 0; firstNewSegmentIndex$iv < minSegmentsSize$iv && Intrinsics.areEqual((Object)thisSegments$iv.get(firstNewSegmentIndex$iv), (Object)otherSegments$iv.get(firstNewSegmentIndex$iv)); ++firstNewSegmentIndex$iv) {
        }
        if (firstNewSegmentIndex$iv == minSegmentsSize$iv && $this$commonRelativeTo$iv.getBytes$okio().size() == ((Path)other).getBytes$okio().size()) {
            return okio.Path$Companion.get$default(Companion, ".", false, 1, null);
        }
        if (!(otherSegments$iv.subList(firstNewSegmentIndex$iv, otherSegments$iv.size()).indexOf(-Path.access$getDOT_DOT$p()) == -1)) {
            other = "Impossible relative path to resolve: " + $this$commonRelativeTo$iv + " and " + other;
            throw new IllegalArgumentException(other.toString());
        }
        if (Intrinsics.areEqual((Object)((Path)other).getBytes$okio(), (Object)-Path.access$getDOT$p())) {
            return $this$commonRelativeTo$iv;
        }
        Buffer buffer$iv = new Buffer();
        ByteString byteString = -Path.access$getSlash((Path)other);
        if (byteString == null && (byteString = -Path.access$getSlash($this$commonRelativeTo$iv)) == null) {
            byteString = -Path.access$toSlash(DIRECTORY_SEPARATOR);
        }
        ByteString slash$iv = byteString;
        int n = var3_5.size();
        for (i$iv = firstNewSegmentIndex$iv; i$iv < n; ++i$iv) {
            buffer$iv.write(-Path.access$getDOT_DOT$p());
            buffer$iv.write(slash$iv);
        }
        n = thisSegments$iv.size();
        for (i$iv = firstNewSegmentIndex$iv; i$iv < n; ++i$iv) {
            buffer$iv.write(thisSegments$iv.get(i$iv));
            buffer$iv.write(slash$iv);
        }
        return -Path.toPath(buffer$iv, false);
    }

    /*
     * WARNING - void declaration
     */
    public final Path normalized() {
        void var1_1;
        Path $this$commonNormalized$iv = this;
        return Companion.get(var1_1.toString(), true);
    }

    public final File toFile() {
        return new File(this.toString());
    }

    public final java.nio.file.Path toNioPath() {
        java.nio.file.Path path = Paths.get(this.toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Path other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path path = this;
        return path.getBytes$okio().compareTo(var1_1.getBytes$okio());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var2_2;
        void var1_1;
        Path $this$commonEquals$iv = this;
        return other instanceof Path && Intrinsics.areEqual((Object)((Path)var1_1).getBytes$okio(), (Object)var2_2.getBytes$okio());
    }

    public final int hashCode() {
        Path path = this;
        return path.getBytes$okio().hashCode();
    }

    public final String toString() {
        Path path = this;
        return path.getBytes$okio().utf8();
    }

    static {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        DIRECTORY_SEPARATOR = string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\n\u001a\u00020\u0007*\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\u0007*\u00020\u000b2\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\b\u0010\fJ\u001d\u0010\r\u001a\u00020\u0007*\u00020\u000e2\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\b\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011"}, d2={"Lokio/Path$Companion;", "", "<init>", "()V", "", "", "normalize", "Lokio/Path;", "get", "(Ljava/lang/String;Z)Lokio/Path;", "toPath", "Ljava/io/File;", "(Ljava/io/File;Z)Lokio/Path;", "toOkioPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Z)Lokio/Path;", "DIRECTORY_SEPARATOR", "Ljava/lang/String;"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmName(name="get")
        @JvmOverloads
        public final Path get(String $this$toPath, boolean normalize) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
            return -Path.commonToPath((String)var1_1, (boolean)var2_2);
        }

        public static /* synthetic */ Path get$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.get(string, bl);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmName(name="get")
        @JvmOverloads
        public final Path get(File $this$toOkioPath, boolean normalize) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$toOkioPath, (String)"<this>");
            String string = var1_1.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return this.get(string, (boolean)var2_2);
        }

        public static /* synthetic */ Path get$default(Companion companion, File file, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.get(file, bl);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmName(name="get")
        @JvmOverloads
        public final Path get(java.nio.file.Path $this$toOkioPath, boolean normalize) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$toOkioPath, (String)"<this>");
            return this.get(var1_1.toString(), (boolean)var2_2);
        }

        public static /* synthetic */ Path get$default(Companion companion, java.nio.file.Path path, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.get(path, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

